#include "uupurge.h"

/*      dispatch
 *      PURPOSE:
 *  
 * 
 *      EXTERNALS:
 *         vars:   
 *                  worknames - array of filenames of uucp control files
 *                  Nojobs - no of jobs to perform
 *      CALLS:
 *                  read_job  - getinfo.c
 *                  fprintf   - UPM(3)
 *                  parse_job - this file
 *                  exit      - UPM(2)
 *                  removejob - this file
 *                  movejob   - this file
 *    
 *      CALLED BY:
 *                  main - uupurge.c
 *
 *	return code - none
 */

int dflag;   /* indicates uucp D file for a particular C file */
int xflag;   /* indicates an extra X file - 2nd line in C file */


dispatch()
 {       
	 int JOB;
	 int worktype;
         int wtype;
         int i;

	 JOB = 0;
    
	 if (Debug ) {
                fprintf(stderr,"DISPATCH: before loop - Nojobs is %d\n",Nojobs);
                for ( i = 0; i < Nojobs; i++)
                        fprintf(stderr,"Job[%d]: %s\n",i,worknames[i]);
         }

	 for ( JOB = 0; JOB < Nojobs; JOB++) {
	      wtype = read_job(worknames[JOB] );

              if (Debug) {
		      fprintf(stderr,"dispatch: wtype returned by read_job is %d\n",wtype);
		      fprintf(stderr,"dispatch: workname is %s\n",worknames[JOB]);
		      fprintf(stderr,"dispatch: DXDFNAME is %s\n",DXDFNAME);
		      fprintf(stderr,"dispatch: DDFNAME is %s\n",DDFNAME);
	      }

	      /* check to see if the Cfile existed - if it has
	       * disappeared then go on
	       * it will not be in the directory the next time we read it
	       * This is a result of the iflag being set
	       * otherwise we will have exited by now
	       */ 	

	      if (wtype == NOFILE) 
		      continue;

              /* 
	       * figure out what kind of C file job
	       * we are looking at
	       */

              worktype = parse_job(wtype);

              if (Debug) {
                      fprintf(stderr,"dispatch: worktype is %d \n",worktype);
	      }

	      /* flag
	       * the existence of files
	       * associated with the C. file
	       */

	      dflag = xflag = 0;

	      switch (worktype) {
		     case NOSPOOL:
			           dflag = 0;
			           xflag = 0;
				   break;
		     case NEWS:
			           dflag = 1;
			           xflag = 1;
				   break;
		     case NONNEWS:
				   if (wtype == EXEC)  {
			                 dflag = 1;
			                 xflag = 1;
				   }
				   else if (wtype == DATAONLY) {
					 dflag = 1;
					 xflag = 0;
				   }
				   break;
                     default:
				   fprintf(stderr,"fatal error: unknown worktype %d\n",worktype);
				   exit(0);

	      }
              
	      if (Debug){
                     fprintf(stderr,"dispatch: dflag is %d, xflag is %d\n",dflag,xflag);
	       }

	      /* if the remove flag is set AND the job
	       * is a news job, then remove it
	       */

              if ( Rflag && worktype == NEWS) {
		    removejob(worknames[JOB],dflag,xflag);
		    continue;
	      }

	     /* move and unlink
	      * the jobs
	      */

             CALLS(dispatch,movejob);
	     movejob(worknames[JOB],dflag,xflag,worktype);
             CALLS(dispatch,removejob);
	     removejob(worknames[JOB],dflag,xflag);
	      

         }
}


removejob(cfile,dflag,xflag)
char *cfile;
int dflag,xflag;
{

       unlink (cfile);

       if (dflag)
	  unlink (DDFNAME);

       if (xflag)
	  unlink (DXDFNAME);

}

movejob(cfile,dflag,xflag,worktype)
char *cfile;
int dflag,xflag,worktype;
{

      move(cfile,worktype);

      if (dflag )
	  move(DDFNAME,worktype);
   
      if (xflag )
	  move(DXDFNAME,worktype);
}

/* move
 *
 *
 *      PURPOSE:
 *         does the actual work of moving one file. The canlink
 *         flag allows use to determine if we can hopefully do
 *         a link instead of a copy.
 *
 *      CALLS:
 *               link   -  UPM(2)
 *               copy   -  copy.c
 *               exit   -  UPM(2)
 *               strcpy -  UPM(3)
 *               fprintf-  UPM(3)
 *               strcat -  UPM(3)
 *      CALLED BY:
 *               movejob  - this file
 */

int canlink=1;             /* flag to indicate link instead of copy */
char target[MAXFULLNAME];  /* name of destination file */

move(file,worktype)
char *file;
{
 
      int i,rc;

      for (i = 0; i < MAXFULLNAME; i++) 
	   target[i] = NULL;

      if (!aflag && worktype == NEWS)
              strcpy(target,ndestdir);
      else
              strcpy(target,destdir);
      strcat(target,"/");
      strcat(target,file);

      if (Debug) {
	      fprintf(stderr,"move aflag is %d, worktype is %d\n",aflag,worktype);
              fprintf(stderr,"move: target is %s\n",target);
              fprintf(stderr,"move: destdir is %s\n",destdir);
              fprintf(stderr,"move: ndestdir is %s\n",ndestdir);
      }
      if (canlink) {

	      if ( rc = link (file, target) < 0 ) {
	          if (Debug) {
                        fprintf(stderr,"rc on link is NEGATIVE\n");
		  }
		  canlink = 0;
                  if (!aflag && worktype == NEWS) {
		      if (copy(file,ndestdir)) {
			    fprintf(stderr,"copy failed on %s\n",file);
                            exit(0);
                      }
                  }
                  else	  {
		      if (copy(file,destdir)) {
			    fprintf(stderr,"copy failed on %s\n",file);
                            exit(0);
                      }
                  }
	      }
      }
      else    {
              if (!aflag && worktype == NEWS) {
	          if (copy(file,ndestdir)) {
		       fprintf(stderr,"copy failed on %s\n",file);
                       exit(0);
                  }
              }
              else   {
	          if (copy(file,destdir)) {
		      fprintf(stderr,"copy failed on %s\n",file);
                      exit(0);
                  }
              }
      }

}

/*      parse_job(wtype)
 *           int wtype -  Either DATAONLY or EXEC, meaning
 *               that the Cfile had one or two associated files
 *               respectively. EXEC is a bit of a misnomer.
 * 
 *              
 * 
 *      PURPOSE:
 *         determines nature of C file uucp style job. Simplistic   
 *         because we only care to discriminate news from non news.
 *         Return code indicates 1. the C file has no spool files,
 *         2. this C file is a news job, 3. the C file has related
 *         files but it is not a news job.
 *      
 *      EXTERNALS:
 *         constants: 
 *                   
 *         vars:    
 *      CALLS:
 *                   gettype  - this file
 *      CALLED BY:
 *                   dispatch - this file
 *	return codes:
 *                   NOSPOOL - indicates C file has no spool files 
 *                   NEWS    - indicates a news job, C file and
 *                             two data files
 *                   NONNEWS - indicates a C file with data files
 *                             but not news
 *
 */

parse_job(wtype)
{

    if( DTYPE[0] != 'S' )
	return(NOSPOOL);
           
    else {
	if ( wtype == DATAONLY ) 
            return(NONNEWS);
	if ( wtype == EXEC )
	    return ( gettype() );
    }
}

/* gettype - figure out whether work
 * is NEWS or NONNEWS. This is only called
 * in the case of  two files (lines ) in a "C." file
 */


gettype()
{
	if ( strcmp( C_COM,"rnews" ) == 0 )
	   return(NEWS);
        else
	   return(NONNEWS);
}
