
#include <stdio.h>
#include "treedef.h"
#include "usr.h"

char *fgets();

/* max size of input buf and numb of ptrs into in buf */
#define BUFSIZE 128
#define BUFPTRSIZE 50

/* locations of usr supplied strngs in bp. NOTE:bp is indexed from 0-(nf-1) */
#define KEY 0
#define RETSTR 1
#define LBRACKET 2
#define FIRSTCHILD 3
#define RBRACKET (nf-1)

/* the min number of flds expected on each line of input.  the min case
is for a null specification. this will be
changed to min number/tree level when the facility for tree levels are
expressed over more than one file line. */
#define MINFIELDS 4

/* len of the children vec, add one for null terminator ptr */
#define VECLEN(x) (x-MINFIELDS+1)

char *badtree = "%s:bad tree def at line %d";
char *nospace = "%s:nospace";

t_node *mktree();

t_node *bldtree(ioptr)
FILE *ioptr;
{
	return ( mktree(ioptr, "") );
}

t_node *mktree(ioptr, nxtstr)
FILE *ioptr;
char *nxtstr;
{
	register int nf, i;
	register t_node *tn;
	char buf[BUFSIZE], *bp[BUFPTRSIZE];
	char *strsave(), *calloc();

	nf = 0;
	while (nf == 0){ 		/* eat up blank lines */
		++line;
					/* recursive:never get EOF */
		if (!fgets(buf,BUFSIZE,ioptr))
			err("%s:read an EOF-bad tree", progname);
		nf=glnstr (buf, BUFSIZE, bp, BUFPTRSIZE);
	}

/* cmp incoming str with just read str if str !null. null case at levl 1 */
	if (*nxtstr)
		if (strcmp(nxtstr, bp[KEY]))
			err(badtree, progname, line);

	if(*bp[LBRACKET] != '>' || *bp[RBRACKET] != '<' || nf < MINFIELDS)
		err(badtree, progname, line);

/* mk new node */
	if(!(tn = (t_node *) calloc(1,sizeof(t_node))))
		err(nospace,progname);

/* save usr info */
	tn->key = strsave(bp[KEY]);			/* save key str */
	tn->retstr = strsave(bp[RETSTR]);		/* save return str */
	if(!tn->key || !tn->retstr)
		err(nospace,progname);

/*
   make offspring vector, get n offspring elements + 1 for terminal NULL ptr
   example: key returnstr > child.1 child.2 ... child.n <
*/
	if(!(tn->next_vec = (t_node **) calloc(sizeof(t_node **), VECLEN(nf))))
		err(nospace,progname);

/* null last vec element */

	(tn->next_vec)[VECLEN(nf)-1] = NULL;

	for (i=0; i < VECLEN(nf)-1; i++) {
		(tn->next_vec)[i] = mktree (ioptr,bp[i+FIRSTCHILD]);
	}
	return (tn);
} /* mktree */
