
/*	Copyright 1981 by David Zittin, Biosciences Data Centre.	 */
#include <stdio.h>
#include "treedef.h"
#define MAXFILES (10)

FILE *dumpf=NULL;
char TMPFILES[];	/* collective pathway to tmp files */
int tmpfiles;		/* num of tmp files */
int PID;

treedump(tree)
DTNODE *tree;
{
	FILE *mktemp();
	int dump();
	static int nfiles=0;

	if(++nfiles > MAXFILES)
		myerr(">%d tmpfiles", MAXFILES);
	dumpf = mktemp();
	scantree(dump);
	if (dumpf)
		fclose(dumpf);
	myfree();
	root=NULL;
}

dump(s,n)
char *s;
int n;
{
	fprintf(dumpf,"%d %s\n", n, s);
}

FILE *mktemp(){
	char buf[24], *myalloc();
	static int fnum = 1;
	int getpid();
	FILE *fopen(), *fp;

	if (fnum == 1){
		PID = getpid();
		sprintf(TMPFILES, "/tmp/*.%d", PID);
	}

	sprintf(buf,"/tmp/Dc%d.%d", fnum++, PID);
	if ((fp=fopen(buf,"w")) == NULL)
		myerr("can't open tmpfile");
	++tmpfiles;
	return(fp);
}
