
/*	Copyright 1981 by David Zittin, Biosciences Data Centre.	 */
#

	/* parse words, dump trees into tmp if too big */
	/* if grep, then parse usr pattrns and load into tree */

#include <stdio.h>
#include <ctype.h>
#include "treedef.h"
#include "bufdef.h"

#define EOS '\0'
char *failed = "failed mktree %d\n";
DTNODE *root = NULL,  *intree();
char *ixfind();

int tmpfiles;		/* no of tmpfiles opened */
int nfiles;		/* no of usr files */
char *filename;		/* name of curr usr file */


int parse(mode, wlen, grep, lnumber,fp)		/* usr supplies words */
int mode, wlen, grep;	
FILE *fp;
{
	register char *c, *wp, *minword;
	char *tmp;

	int pscanf();
	int line=0;

	minword = &buf[wlen];

nextline:
	while (getln(lnbuf,LNSIZ,fp) != EOF ){
		c = lnbuf;
		++line;

nextword:
		while ( *c ) {
			switch(mode){
				case USRCNT:
					tmp = c;
					if (pscanf(&tmp,"%d %s",&wcnt,buf) !=2)
						myerr("expect num.-wrd at \"%s\"",lnbuf);
					c = tmp;
					break;

				case USR:
					for(wp=buf; (*wp++ = *c++); ) /* cpy */
						;
					--c; 
					break;

				case MINE:
					wp = buf;
					while (*wp = *c++){
						if ( isalpha(*wp) ){
							do {
								if(isupper(*wp))
									*wp = tolower(*wp);
							}
							while(isalnum((*++wp = *c++)));
							--c;	/* backup */
				
							if (wp < minword)
								goto nextword;

							*wp = EOS;
							break;
		
						} 	/* isalpha */

					} 	/* while not EOS */


					if (wp == buf) 
						goto nextline;


					break;

			} /* sw */

		
			if (grep) {		/* word searching? */
				if (intree(root, buf)) {	/* found */

					if (nfiles){	/* > 1 text file ? */
						for(c=filename; *c; c++)
							putc(*c,stdout);
						putc(':',stdout);
					}

					if (lnumber)
						printf("%d:", line);

					for(c=lnbuf; *c; c++)
						putc(*c,stdout);

					putc('\n', stdout);
					goto nextline;
				}

			}

			else { 			/* or composing tree? */
				if (!(ixfind(&root)) ) {
					treedump(root);
					if (!(ixfind(&root)) ) 
						myerr(failed,tmpfiles);
				}
			}

		} /* while c */


	} /* while ! eof */

	if (tmpfiles && root)
		treedump(root);		/* dump partial tree before return */

	return(tmpfiles);

} /* routine */
