#include <stdio.h>
#include "bufdef.h"
#include "iodef.h"
#include <debug.h>

#ifdef DEBUG
#define DPRINT(x) if(debug) nprint(x)
#else
#define DPRINT(x) /* undefined */
#endif


#define true 1
#define false 0
#define EOS '\0'
#define NL '\n'
int endflag;		/* flag=true when an eof on dictf is encountered */


		/* ugly specialized dictionary reader.  reads in a buf
		 * from dict file and does string cmps directly from
		 * this buf using newlines as delimeters
		 */
int lookup(str,na)
register char *str;
int na;
{
	register char *iop = _dictiop;
	char *strbase=str, *tmp;
	int nbytes;
	static int eatline=0;
	static char *startwd;

	for(;;++str, ++iop) {
		if(iop >= endbuf) {
nextbuf:
			tmp = endbuf - 1; /* last elem in iobuf
					   * tmp==NULL before 1st read
					   */
			if(*tmp && *tmp != NL) { /* line across iobuf mv
						 * word to buf exention */
				iop=readbase;
				do {
					if(--iop < io_buf)
						err("dict word toobig");
					*iop = *tmp;
				}
				while(*--tmp != NL);
			}

			if(endflag||(nbytes=read(dictfd, readbase, IOBSIZ))<=0){
				endflag=true;
				treeprint(str,na);
				_dictiop = iop;
				return;
			}
			endbuf = readbase + nbytes;


			if (iop > readbase)	/* iop not used to wrap */
				iop = readbase;	/* last buf ended with NL */
		
			str=strbase;
			startwd = iop;
			eatline = false;	/* startwd at wrd after read */

			TRACEF(("just filled iobuf with %d butes",nbytes));
			TRACEF(("addr of io_buf=%d\tendbuf=%d\treadbase=%d",io_buf,endbuf,readbase));
			TRACEF(("leaving buf fill with iop="));
			DPRINT(iop);
			TRACEF((" and str="));
			DPRINT(str);
			TRACEF((" and startwd="));
			DPRINT((startwd));


				/* if prev strcmp was != and string occurs
				 * across the input buffer, then eat up
				 * chars in input buf up til newline
				 */
		}
		if(eatline) {
			while(iop < endbuf)
				if(*iop++ == NL)
					break;	

			if(iop >= endbuf)
				goto nextbuf;

			--eatline;	/* set back to false */
			startwd = iop;
			TRACEF(("leave eatwrd with startwd="));
			DPRINT(startwd);
			TRACEF(("and iop="));
			DPRINT(iop);
		}

		if(*str != *iop){
			if(!*str && *iop == NL) { 	/* strings are equal */
				_dictiop = ++iop;		/* save current iop */
				TRACEF(("strings equal set _dictiop to "));
				DPRINT(_dictiop);
				return;
			}

			if(*str - *iop > 0){	/* look further down dict */
				str=strbase-1;	/* reset str for next compare */
				TRACEF(("look further down dict. reset usr word="));
				DPRINT(str+1);
				if(*iop != NL)
					eatline=true; /* eat til newline */
			}

			else{ 			/* not in dictionary */
				treeprint(strbase, na);
				_dictiop = startwd;	/* go back to word start */
				TRACEF(("wrd not in dict. dictbuf wrd="));
				DPRINT(_dictiop);
				return;
			}
		} 	/* if strings not equal */
	}	/* indefinate for loop */
}

#ifdef DEBUG
		/* specialized ugly debug print statement that tells when it
		 * is printing a string which is in the io_buf. 
		 * strings can be null or newline terminated
		 */
nprint(s)
register char *s;
{
	if(s >= io_buf && s < endbuf){
		printf(" (->IN IO_BUF<-) ");
		while(s < endbuf && *s != '\n')
			putc(*s++,stdout);
		if(*s == '\n'){
			putc(*s,stdout);
			return;
		}
		if(s >= endbuf)
			printf(" (->JUST PRINTED UP TO END OF BUF<-)\n");
		return;
	}
	while(*s != '\0') {
		if(*s == '\n')
			break;
		putc(*s++,stdout);
	}
	putc('\n',stdout);
}
#endif
