
/*	Copyright 1981 by David Zittin, Biosciences Data Centre.	 */
#include <stdio.h>
#include "treedef.h"
#include "bufdef.h"
#include <assert.h>
		
int nnodes=0;

char *ixfind(tree)
DTNODE **tree;
{
	register DTNODE *p, *p1, *p2; 	/* p=fast root, p1&p2 are for avl bal */
	static char *treestr, *bufstr;		/* tmp str ptrs for strcmp */
	char *mystrsave();
	
	p = *tree;
	if (!p){			/* notfound, mk a data node */
		GSPACE (p,DTNODE);
		ht = true;
		nnodes++;
		if (!(p->skey = mystrsave(buf)))
			return(NULL);
		ASSERT(p->skey != 0);
		if (countflg)
			p->na += wcnt;
		else
			p->na = 1;
		p->rtd = p->ltd = NULL;	/* left & rigth ptrs */
		p->bal = 0;
		goto done;
	} /* if */
		

	for(treestr=p->skey,bufstr=buf;*treestr == *bufstr; treestr++, bufstr++)
		if(!*treestr) {	/* node found */
			ASSERT(p != 0);
			ht = false;
			if (countflg) 
				p->na += wcnt;
			else
				p->na++;
			goto done;
		}

	if (*treestr - *bufstr > 0) {
		if (!ixfind (&((*tree)->ltd)))
			return(NULL);
		if ( ht ) {	/* lft branch higher */
			switch ( p->bal ) {
				case 1 :
					p->bal = 0;
					ht = false;
					break;
				case 0 :
					p->bal = -1;
					break;
				case -1 : {
					p1 = p->ltd;
					ASSERT(p1 != 0);
					if( p1->bal == -1 ){	/* ll rotate */
						p->ltd = p1->rtd;
						p1->rtd = p;
						p->bal = 0;
						p = p1;
					}
					else {		/* doubl lr rotate */
						p2 = p1->rtd;
						ASSERT(p2 != 0);
						p1->rtd = p2->ltd;
						p2->ltd = p1;
						p->ltd = p2->rtd;
						p2->rtd = p;
						if (p2->bal == -1)
							p->bal = 1;
						else
							p->bal = 0;
						if ( p2->bal == 1)
							p1->bal = -1;
						else
							p1->bal = 0;
						p = p2;
					} /* else */
					p->bal = 0;
					ht = false;
					break;
				} /* case -1 */
			} /* switch */
		} /* if ht */
	} /* else */
						
	else {
		if(!ixfind (&((*tree)->rtd)))
			return(NULL);
		if ( ht ) {	/* rt branch higher */
			switch ( p->bal ) {
				case -1:
					p->bal = 0;
					ht = false;
					break;
				case 0:
					p->bal = 1;
					break;
				case 1: {
					p1 = p->rtd;
					ASSERT(p1 != 0);
					if ( p1->bal == 1) {
						p->rtd = p1->ltd;
						p1->ltd = p;
						p->bal = 0;
						p = p1;
					}
					else {
						p2 = p1->ltd;
						ASSERT(p2 != 0);
						p1->ltd = p2->rtd;
						p2->rtd = p1;
						p->rtd = p2->ltd;
						p2->ltd = p;
						if ( p2->bal == 1)
							p->bal = -1;
						else
							p->bal = 0;
						if ( p2->bal == -1 )
							p1->bal = 1;
						else
							p1->bal = 0;
						p = p2;
					} /* else */
					p->bal = 0;
					ht = false;
					break;
				} /* case +1 */
			} /* switch */
		} /* if rt higher */
	} /* else */

done:
	*tree = p;	/* set root to register tmp root */
	return(p->skey);
}
