
/*	Copyright 1981 by David Zittin, Biosciences Data Centre.	 */
#include <stdio.h>
#include "usrcmds.h"			/* usr switches */
#include "treedef.h"			/* dynamic data structs */

#define	TEST(x,a,b) ((x) ? a : b)

main(argc, argv)
int argc;
char *argv[];
{
	register DTNODE *d_root;	/* root of data tree */
	register int i;
	register char *argp;
	DTNODE *maketree();
	FILE *fopen(), *fp;
	int flag=0;
	
	usrinit();			/* dynamically init usr option struct */
	usrcmds.prog = argv[0]; 	/* save prog name */

	for(i=1; i < argc; ++i){
		argp = argv[i];
		if ( *argp == '@' || *argp == '-') {
			*argp = '@';
			usrcmd(argp);
		}

		else{
			++flag;
			usrcmds.fname = argp;	/* save file name */
			usrcmds.line = 0;	/* start at line 1 */
			if (!(fp=fopen(argp, "r")) ){
				errmsg("%s:can't open %s\n", usrcmds.prog,argp);
				exit(1);
			}

			d_root = maketree(fp);
		} /* else */
	} /* for */
	if ( !(flag) )
		d_root = maketree(stdin);

				/* print raw data & mk rank assgns */
	if (usrcmds.echo){
		printf("\n*** DATA ECHO:%s***\n", TEST(usrcmds.title==NULL," ",usrcmds.title) );
		pr_data(d_root);
	}

					/* print group stats */		
	pr_grpstat(d_root); 
}
