
/*	Copyright 1981 by David Zittin, Biosciences Data Centre.	 */
#include <stdio.h>

gamma (data, ngrp, g1, se_g1, g2, se_g2)
float *data, *g1, *g2, *se_g1, *se_g2;
int ngrp;
{
	register int i;
	double s1=0.0, s2=0.0, s3=0.0, s4=0.0;
	double sd, var, sqrt();
	double n, t1, t2, t3, nm1;

	for(i=0; i < ngrp; i++){
		t1 = *data++;
		s1 += t1;
		s2 += t1 * t1;
		s3 += t1 * t1 * t1;
		s4 += t1 * t1 * t1 * t1;
	}

	n = ngrp;
	nm1 = n - 1.0;

	var = (s2 - (s1 * s1) / n) / nm1;
	sd = sqrt( (double) var);	

	t1 = n * s3 - (3 * s1 * s2) + (2 * s1 * s1 * s1) / n;
	*g1 = t1 / ( nm1 * (n-2.0) * sd * sd * sd);

	t1 = (n+1) * (n * s4 
		- (4.0 * s1 * s3)
		+ (6.0 * s1 * s1 * s2 / n)
		- (3.0 * s1 * s1 * s1 * s1)/(n * n));
	t2 = nm1 * (n-2.0) * (n-3.0) * sd * sd * sd * sd;
	t3 = (3.0 * nm1 * nm1) 
		/ ( (n-2.0) * (n-3.0) );
	*g2 = (t1 / t2) - t3;
	*se_g1 = sqrt((6.0 * n * nm1) / ((n-2.0) * (n+1.0) * (n+3.0)));
	*se_g2 = sqrt((24.0 * n * nm1 * nm1)/((n-3.0)*(n-2.0)*(n+3.0)*(n+5.0)));
}
