

#include <stdio.h>
#include "usrcmds.h"
#include "table.h"

#define	SIG(s,e) ((s/e >= zval) ? "*" : "ns")

#define NL '\n'
char *L[] = {	"n", "min", "max", "mean", "95%ci(mean)",
		"var", "sd", "se", "g1", "g2" };

char *horizdec = "%s=%-8ld \t ";
char *horizfloat = "%s=%g \t ";

char *columndec = "%-8s\t%ld\n";
char *columnfloat = "%-8s\t%g\n";

char *gammacol = "%-8s\t%g%s\n";
char *gammahor = "%s=%g%s \t ";

char *cihoriz = "%s=%g %g \t ";
char *cicol = "%-8s\t%g\t%g\n";

char *cifmt, *decfmt, *floatfmt, *gammafmt;	/* tmp fmt ptrs */



float zval=1.96;		/* 95 % ci for std norm dist */


/* print the data. do an inorder traversal of the data tree. print the
group stats assoc with each data node */

fmt_setup()
{
	if (!(usrcmds.outfmt)) {	/* columnar */
		decfmt = columndec;
		floatfmt = columnfloat;
		gammafmt = gammacol;
		cifmt = cicol;
	}
	else {
		decfmt=horizdec; 		/* default fmt */
		floatfmt=horizfloat;
		gammafmt = gammahor;
		cifmt = cihoriz;
	}

}

pr_grpstat(tbl)
register TABLE *tbl;
{
	double mean, var, sd, se, low_95, high_95;
	double g1, g2, se_g1, se_g2;		/* skew and kurtosis */	
	register int i=0;

	if (tbl->na < 2)
		printf("\n>>> %s ==>NO STATS, N < 2!\n",tbl->hkey);

	else {
		statcalc(tbl, &mean, &var, &sd, &se, &low_95,&high_95);
		printf("\n\n>>> %s ==>\n\n", tbl->hkey);
		printf(decfmt, L[i++], tbl->na);
		printf(floatfmt, L[i++], tbl->min);
		printf(floatfmt, L[i++], tbl->max);
		printf(floatfmt, L[i++], mean);

		if (usrcmds.outfmt) 			 /* horiz */
			putc(NL,stdout);
		printf(cifmt, L[i++], low_95, high_95);
		printf(floatfmt, L[i++], var);

		if (usrcmds.outfmt) 			 /* horiz */
			putc(NL,stdout);
		printf(floatfmt, L[i++], sd);
		printf(floatfmt, L[i++], se);


		if (tbl->na >= 5 && var > 0.0){
			gamma(tbl->na, tbl->sum,tbl->sumsq,tbl->s3,tbl->s4, &g1, &se_g1, &g2, &se_g2);
			if (!(usrcmds.outfmt)) gammafmt[9] = NL;
			printf(gammafmt, "g1",g1,SIG(g1, se_g1));
			printf(gammafmt, "g2",g2,SIG(g2, se_g2));
			gammafmt[9] = '\t';
		}
		else
			printf("no gammas(N<5 or var=0)\n");
		printf("\n");
	} /* else */
}
