


#include <stdio.h>
#include "table.h"
#include "usrcmds.h"
#include <ctype.h>

#ifdef HASHCHK
#define COLLISION(x) x += 1.0;
#define ENTER(x) x += 1.0;
#define TABLENTRIES(x) x++;
#define HASHSUMMARY(x,y,z) hashchk(x,y,z)
double collision=0.0, enter=0.0;
int entries=0;
hashchk(x,y,z) double x,y;int z;{fprintf(stderr,"HASH:\n\t#collisions=%g\n\t#hashf calls=%g\n\tcolls/call=%g\n\ttblitems=%d\t\n",x,y,x/y,z);}

#else
#define COLLISION(x)
#define ENTER(x)
#define TABLENTRIES(x)
#define HASHSUMMARY(x,y,z)
#endif

#define	TEST(x,a,b) ((x) ? a : b)

#define LABELSIZE 120
char labelbuf[LABELSIZE];	/* buffer for usr label */

		/* a silly number which makes the hash table work better */
#define MAGIC 5

/* tabsiz is size of has table which keeps track of group strings and
 * ptr to link list of each group's data. tabsiz must always be a prime number. 
 * IMPORTANT NOTE: if TABSIZ is changed, THEN change MAXALLOWED. 
 * the value of MAXALLOWED is magic, but probably should be <= 90%
 * of TABSIZ. there are compile switched macros in this code to test hash table
 * performance.
 */
#define TABSIZ 263
			/* do not let hash table fill more than MAXALLOWED */
#define MAXALLOWED 236

TABLE table[TABSIZ];
TABLE *endtable=table+TABSIZ;
double tmp, x;

long ntotal;		/* total number of obsv */
double rm_sampvec();

ndstat(){
	register int i;
	register TABLE *t;
	int cmp();

	qsort(table, TABSIZ, sizeof(TABLE), cmp);

		/* eat up the leading empty hash table elements */
	for(i=0; i < TABSIZ && !(table[i].hkey); i++)
		;

	fmt_setup();

	printf("\n>>GROUP STATS (var. from n-1 df):%s<<\n",TEST(usrcmds.title==NULL," ",usrcmds.title));

	for(; i < TABSIZ; i++)  {
		TABLENTRIES(entries)		/* cc conditional */
		t = &table[i];
		ntotal += t->na;
		if (t->samp_vec)
			t->correct = rm_sampvec(t);
		pr_grpstats(t);
		printf("\n\n");
	}

	HASHSUMMARY(collision,enter,entries);	/* cc conditional */

	printf("\nTOTAL %ld\t\t\t(ns=not sig, p>0.05; *=sig, p<=0.05)\n",ntotal);
}


filltable(fp)
register FILE *fp;
{
	register char *bp;
	register int c;
	long pairno=0;
	int hashdata(), sscanf();
	int fscanf();

getanother:
	while ((c=getc(fp)) != EOF && isspace(c) )
		;
	if (c == EOF) return;
	ungetc(c, fp);
	for(bp=labelbuf; (c=getc(fp)) != EOF && !(isspace(c)); bp++)
		*bp = c;
	if (c == EOF)
		return;
	*bp = '\0';
	if (fscanf(fp, "%F", &x) == EOF)
		err("bad data pair:%ld \"%s\"\n",pairno,labelbuf);
	pairno++;
	hashdata(labelbuf);
	goto getanother;
}


			/* samplesiz=size of tmp data vector used to determine
			 * calc a sample mean. this sample mean is subtracted
			 * from incoming data to reduce the size of the
			 * gamma accumlations (3rd and 4th power sums) */
#define SAMPSIZ 12

char *strsave(), *malloc();
int strcmp();

int hashdata(str)
char *str;
{
	register int i=13;
	register char *c=str;
	register TABLE *tbl;
	int hval=0, displace=1;
	static char *nospace="hash:nospace";
	static int ntable=0;

	ENTER(enter)		/* cc conditional */

	while(*c) {
		hval += *c++ * i;
		i *= MAGIC;
	}

	if (hval < 0)
		hval = -hval;

	tbl = table + (hval % TABSIZ);

	if (tbl < table || tbl >= endtable)
		err("htab botch");


	for(;;){
		if ( !(tbl->hkey) ) {			/* at empty hole */
			if ( ++ntable > MAXALLOWED )
				err("htab full");
			if (!(tbl->hkey = strsave (str)))
				err(nospace);
			tbl->na = 1;
			tbl->min = tbl->max = x;
			if(!(tbl->samp_vec = (double *) malloc(sizeof(double) * SAMPSIZ)))
				err(nospace);
			tbl->samp_vec[0] = x;
			return;
		}

		if (!(strcmp(tbl->hkey,str))) {		/* found */
			if (x < tbl->min)
				tbl->min = x;
			if (x > tbl->max)
				tbl->max = x;
			i = tbl->na;
			if(i < SAMPSIZ) {
				tbl->samp_vec[tbl->na++] = x;
				return;
			}
			break;
		}

		else {				/* collision, quad srch */
			COLLISION(collision)		/* cc conditional */
			tbl += displace;
			displace += 2;
			if (tbl >= endtable) 
				tbl -= TABSIZ;
		}
	}

			/* data accumulations */
	if(i == SAMPSIZ)
		tbl->correct = rm_sampvec(tbl);

	tbl->na++;
	x /= tbl->correct;
	tbl->sum += x;	/* subtract the sample mean */
	tmp = x * x;
	tbl->sumsq += tmp;
	tbl->s3 += tmp * x;
	tbl->s4 += tmp * tmp;
}

double rm_sampvec(t)
register TABLE *t;
{
	register int i;
	register int n=t->na;
	double mean=0.0, x, tmp;

	for(i=0; i < n;)
		mean += t->samp_vec[i++];


	mean /= n;
	for(i=0; i < n; i++) {
		x = t->samp_vec[i] / mean;
		t->sum += x;
		tmp = x * x;
		t->sumsq += tmp;
		t->s3 += tmp * x;
		t->s4 += tmp * tmp;
	}
	free(t->samp_vec);
	t->samp_vec = (double *) 0;
	return(mean);
}
		
int cmp(arg1, arg2)
TABLE *arg1, *arg2;
{
	register int cmpval;
	int strcmp();

	if (!(cmpval = strcmp(arg1->hkey, arg2->hkey) ))
		return(0);	/* equality */

	return( (cmpval > 0) ? (1) : (-1) );
}
