#include <stdio.h>
#include <rank.h>
#include "usr.h"			/* usr switches */

typedef struct datanode {
	float data;
	struct datanode *next;
} DNODE;

typedef struct hashtable {
	char *hkey;
	int cnt;
	struct datanode *startlist, *endlist;
} TABLE;

		/* a silly number which makes the hash table work better */
#define MAGIC 5

int ntable=0;	/* number of entries in hash table */


/* tabsiz is size of has table which keeps track of group strings and
	ptr to link list of each group's data. tabsiz should always
	be a prime number */
#define TABSIZ 53
TABLE table[TABSIZ];


mwu()
{
	int cmp();

			/* sort the htable for alphabetical output */
	if(ntable == 1)
		err("%s:there must be >1 group", usr.prog);
	qsort(table, TABSIZ, sizeof(TABLE), cmp);
	pair_test();	 /* mwu test all combinations of pairs */
}

pair_test()
{
	register int j; 
	register DNODE *dnode;
	int i, n1, n2;
	RNODE *root=NULL;
	float calc_ties();
	double ties, ranksum, sumrank();
	double U, C;



		/* eat up the leading empty hash table elements */
	for(i=0; i < TABSIZ && !(table[i].startlist); i++)
		;

		/* now do all combinations of twos thru the hash table */
	for(; i < TABSIZ; i++) {
		for(j=i+1; j < TABSIZ; j++){

				/* construct a rank tree with the two groups */
			for(dnode=table[i].startlist; dnode; dnode=dnode->next)
				mkranks(&root, dnode->data);

			for(dnode=table[j].startlist; dnode; dnode=dnode->next)
				mkranks(&root, dnode->data);


				/* n2=smaller sample size, n1=larger */

			if (table[i].cnt <= table[j].cnt) {
				n1 = table[j].cnt;
				n2 = table[i].cnt;
			}
			else{
				n1 = table[i].cnt;
				n2 = table[j].cnt;
			}
		
			if (n1 > 20)
				ties = calc_ties(root);		/* correction */

				/* change root->ties to root->rank */
			rank(root);



/* sum ranks of both groups for usr, but
	return sum for smaller group */
			ranksum = sumrank(root, &table[i], &table[j]);


			C = n1 * n2 + n2 * (n2 + 1.0) / 2.0 - ranksum;

			U = (C > n1 * n2 - C ) ? (C) : (n1 * n2 - C);

			significant(table[i].hkey,table[j].hkey,n1,n2, U, ties);

			root = NULL;	/* set the root to null */

			myfree();	/* free the rank tree */
		}
	}
}



	/* sum ranks for both groups, but return the rank of the group
		with the smaller n value (n2). also do data and rank echoing */
double sumrank(root, t1, t2)
RNODE *root;
TABLE *t1, *t2;
{
	register DNODE *d1, *d2;
	static char *fmt="%20s (n = %d)%18s (n = %d)";
	static char *fmt1="\t\t%6.1f  %g";
	double sum1=0.0, sum2=0.0;
	double tmp;
	double get_rank();
	static int flg=1;
	if(flg)
		--flg;
	else
		printf("\n\n\n");

	printf("%s == %s vs %s ==>\n", usr.title, t1->hkey, t2->hkey);
	printf(fmt, t1->hkey, t1->cnt, t2->hkey, t2->cnt);
	if (usr.echo)
		printf("\n\t\t  rank  obs\t\t  rank  obs\n");


			/* data echo for both groups */

	for(d1=t1->startlist, d2=t2->startlist; d1 || d2; ) {
		if (d1) {
			tmp = get_rank(root, d1->data);
			sum1 += tmp;

			if(usr.echo)
				printf(fmt1, tmp, d1->data);

			d1 = d1->next;
		}
		else
			if (usr.echo)
				printf("\t\t\t");

		if (d2) {
			tmp = get_rank(root, d2->data);
			sum2 += tmp;

			if(usr.echo)
				printf(fmt1, tmp, d2->data);

			d2 = d2->next;
		}

		if(usr.echo)
			putc('\n', stdout);
	
	}

	printf("\n\tranksums:\n\t%14.1f\t\t%14.1f\n", sum1, sum2);
	return( (t1->cnt < t2->cnt) ? (sum1) : (sum2) );
}



filltable(fp)
register FILE *fp;
{
	char *alpha, *number;	/* ptrs to alpha & num strs in input */
	char *badeod = "unexpected end of data\n";
	double x;			/* usr datum after sscanf conv */
	int hashdata(), sscanf();

	while (getdata(&alpha,fp) != EOF){
		switch(usr.label){
			case ON:	if(getdata(&number,fp) == EOF)
						err(badeod);
					break;

			case OFF:	number = alpha;
					alpha = usr.group;
					break;

			case AUTO:	number = alpha;
					alpha = usr.fname;
					break;
		} /* switch */
		if (sscanf(number, "%F", &x) != 1)
			err("%s:bad data \"%s %s\"\n",usr.prog,alpha,number);

		hashdata(alpha, x, table, TABSIZ);
	} /* while reading data */
}


/* debug-development dump:
tabledump(){	
	register int i;
	register DNODE *dnode;

	printf("\n\nTABLEDUMP\n");
	for(i=0; i < TABSIZ; i++) {
		if (table[i].hkey){
			printf("hkey=%s cnt=%d ", table[i].hkey, table[i].cnt);
			for(dnode=table[i].startlist; dnode; dnode=dnode->next)
				printf("\t%g ", dnode->data);
		}
		printf("\n");
	}
	printf("\nENDDUMP\n\n");
}
*/

#define MAXALLOWED 4 / 5
int hashdata(str, x, table, tabsiz)
char *str;
double x;
TABLE *table;
int tabsiz;
{
	register int hval=0;
	register int displace=1;
	register TABLE *tbl;
	TABLE *endtable=table+tabsiz;
	int strcmp();
	char *c=str;
	char *strsave(), *malloc();
	static char *nospace="%s:hash:nospace";
	int i=13;

	while(*c) {
		hval += *c++ * i;
		i *= MAGIC;
	}

	if (hval < 0)
		hval = -hval;

	tbl = table + (hval % tabsiz);

	if (tbl < table || tbl >= endtable)
		err("%s:htab botch",usr.prog);


	for(;;){
		if ( !(tbl->hkey) ) {			/* at empty hole */
			if ( ++ntable > tabsiz * MAXALLOWED)
				err("%s:htab full",usr.prog);
			tbl->cnt = 1;
			if (!(tbl->hkey = strsave (str)))
				err(nospace,usr.prog);
			if(!(tbl->startlist=tbl->endlist=(DNODE *)malloc(sizeof(DNODE))))
				err(nospace,usr.prog);
			tbl->startlist->data = x; 
			break;
		}

		if (!(strcmp(tbl->hkey,str))) {		/* found */
			tbl->cnt++;	
			if(!(tbl->endlist->next=(DNODE *)malloc(sizeof(DNODE))))
				err(nospace,usr.prog);
			tbl->endlist = tbl->endlist->next;
			tbl->endlist->data = x;
			return;
		}

		else {				/* collision, quad srch */
			tbl += displace;
			displace += 2;
			if (tbl >= endtable) 
				tbl -= tabsiz;
		}
	}
}

int cmp(arg1, arg2)
TABLE *arg1, *arg2;
{
	register int cmpval;
	int strcmp();

	if (!(cmpval = strcmp(arg1->hkey, arg2->hkey) ))
		return(0);	/* equality */

	return( (cmpval > 0) ? (1) : (-1) );
}
