#include <stdio.h>

#ifdef DEBUG
char *tstr="\n+\t";
#define tracef(x) {printf(tstr);printf x;}

#else
#define tracef(x)
#endif

char *progname;
char *usage="usage:%s 'fieldno-transformtype[-fmt] file..'";
char *fgets();

#define BSIZ 512
#define NFIELDS 100
#define EOS '\0'

char buf[BSIZ], *field[NFIELDS];
char outbuf[64];
char *fmtdefault="%g";			/* default output fmt=%g */
char *fmt[NFIELDS];

double (*funclist[NFIELDS])();

double 
	sqrt(),
	exp(),
	log10(),
	log(),
	asinsqrt(),
	asin(),
	sin(),
	atan(),
	fabs(),
	tan(),
	cos(),
	acos();


struct fmap {		/* map usr string into a function */
	char *fname;	double (*funcptr)();
};

struct fmap flist[] = {
	"s*t",		sqrt,
	"exp*",		exp,
	"l*10",		log10,
	"log*",		log,
	"ln",		log,
	"a*s*t",	asinsqrt,
	"asin",		asin,
	"s*n",		sin,
	"at*n",		atan,
	"fabs",		fabs,
	"abs*",		fabs,
	"tan*",		tan,
	"t*n",		tan,
	"c*s",		cos,
	"a*c",		acos,
	"",		NULL
};

#define false 0
#define true 1

#define BLANK ' '
char fs=BLANK;			/* field separator for input data */
char ofs=BLANK;			/* field separator for output data */

main(argc,argv)
int argc;
char *argv[];
{
	register int i;
	register char *argp;
	FILE *fp=NULL, *myopen();
	int openflg=false, first=true, ofsset=false;;

	progname = argv[0];

	if (argc == 1)
		err(usage, progname);

	for(i=0; i < NFIELDS; i++)
		fmt[i] = fmtdefault;

	for(i=1; i < argc; i++) {
		argp = argv[i];
		switch(*argp) {
			case '-':
				switch(*++argp) {
					case 'F':fs = *++argp;
						 break;
					case 'O':ofs = *++argp;
						 ofsset=true;
						 break;
					default:
						err(usage, progname);
						break;
				} /* inner switch */
				break;
			default:
				if (first) {
					process_args(argp);
					first = false;
				}
				else {
					if (!(ofsset))
						ofs = fs;
					openflg=true;
					fp = myopen(fp,argp,"r");
					transform(fp);
				}
				break;
		} /* outer switch */
	} /* for arglist */

	if (!(openflg)){
		if (!(ofsset))
			ofs = fs;
		process_args(argv[i]);
		transform(stdin);
	}
}

transform(fp)
FILE *fp;
{
	register int i;
	register char *currfld, *c;
	int nf;
	char *lastfld;
	double x;

	while((nf=getdata(fp) ) != EOF) {
		lastfld = field[nf-1];

		for(i=0; i < nf; i++) {		/* go across the input flds */
			currfld = field[i];
			if(funclist[i] && sscanf(currfld, "%F", &x) == 1){
				sprintf(outbuf, fmt[i], (*funclist[i])(x));
				for(c=outbuf; *c; c++)	/* rm trailing blks */	
					;
				while(--c > outbuf) {
					tracef(("bactrack=%c\n",*c));
					if (*c >= '1' && *c <= '9')
						break;
					switch(*c) {
						case '.': *c = EOS;
							  goto done;
						case '0': *c = EOS;
							  break;
					}
				}
done:
				currfld = outbuf;
			}
			putstr(currfld);

			if(currfld != lastfld)
				putc(ofs, stdout);
		}
		putc('\n',stdout);
	}
}

putstr(c)
register char *c;
{
	while(*c)
		putc(*c++, stdout);
}
		

			/* get a usr line from file, parse into fields
			 * use cparse for non blank FS, bparse otherwise to
			 * handle blank FSs like awk does */
int getdata(fp)
register FILE *fp;
{
	if (getln(buf,BSIZ,fp) != EOF) 
		return((fs!=BLANK) ? (cparse(buf, BSIZ, field, fs, NFIELDS)) :
				     (bparse(buf, BSIZ, field, NFIELDS)));
	return(EOF);
}

#define FIELDNO 0
#define TRANSTYPE 1
#define FMT 2
#define MAXDASHFLDS 5

process_args(s)
register char *s;
{
	register int i, j;
	int nf, tfield, nparsed;
	char *dashfld[MAXDASHFLDS], *tmp;

	tracef(("process args=%s\tBSIZ=%d\tNFIELDS=%d\n", s, BSIZ, NFIELDS));
	tracef(("len of arg=%d\n", strlen(s)));
	nf = bparse(s, strlen(s), field, NFIELDS);
	tracef(("args parsed=%d\n", nf));

	for (i=0; i < nf; i++) {	/* parse usr arg with transf specs */

					/* parse a doublet-triplet? */
		tmp = field[i];
		nparsed=cparse(tmp, strlen(tmp), dashfld,'-', MAXDASHFLDS);

		if (nparsed <= 1 || nparsed > 3)
			err(usage, progname);

		if (sscanf(dashfld[FIELDNO], "%d", &tfield) != 1)
			err("bad field number:%s", dashfld[FIELDNO]);

		tfield--;	/* decr by 1, start funct arr at 0 */

		tmp = dashfld[TRANSTYPE];

		for(j=0; *(flist[j].fname); j++) {
			tracef(("cmp usrfunct=%s vs. flist=%s\n",tmp,flist[j].fname));
			if(match(tmp, flist[j].fname)) {
				funclist[tfield] = flist[j].funcptr;
				tracef(("funct %s found\n", tmp));
				goto found;
			}
		}

found:
		tracef(("tfield-1=%d\n",tfield));
		if(!(funclist[tfield]))
			err("%s:%s is a nonexistant function", progname,tmp);


		if(nparsed == 3)
			fmt[tfield] = dashfld[FMT];
	}
}


double asinsqrt(x)
double x;
{
	return( asin(sqrt(x)) );
}
