#include <stdio.h>
#include <stat.h>
#include <debug.h>

int MAXFILES=100;

#define MAXFLDS 120
#define BSIZ 512
char *bp[MAXFLDS];
char buf[BSIZ];
char sep = ' ';
char ofs = ' ';
char *badswitch = "invalid switch %s";
#define PSIZ 64
char prevbuf[PSIZ];
int vflg;
int cflg;		/* create the files */
int aflg;		/* force append to existing files only */
int Aflg;		/* if can't append write to stdout */
int cnt;		/* number of lines */
int file_appended;	/* if the file was appended to */
struct stat statb;

FILE *myopen();
char *strcpy(), *fgets();
FILE *outf=NULL;
int nfiles=0;

main(argc,argv)
int argc;
char *argv[];
{
	int fld = 1;
	FILE *dataf=NULL;
	register char *argp;
	register int i;

	prevbuf[0] = -1;		/* fiddle so different */
	if (argc < 2)
		err("usage: %s -n -[aAcv] -Fx -Ox file ...",argv[0]);
	for (i=1; i<argc; ++i)
		{
		argp = argv[i];
		if (*argp == '-')
			{
			++argp;
			switch(*argp++)
				{
			case 'A':
				++Aflg;		/* write to stdout if not present */
				/* fall thru */
			case 'd':
				++debug;
				break;
			case 'a':		/* force append */
				++aflg;
				break;
			case 'c':
				++cflg;
				break;
			case 'v':
				++vflg;
				break;
			case 'O':
				ofs = *argp++;
				break;
			case 'F':
				sep = *argp++;
				break;
			case 'N':
				MAXFILES = atoi(argp);
				if(MAXFILES <= 0)
					err(badswitch, argp);
				TRACEF(("MAXFILES=%d", MAXFILES));
				break;
			default:
				--argp;
				fld = atoi(argp);
				if (fld <= 0)
					err(badswitch, argp);
				break;
				}
			}
		else
			{
			dataf=myopen(dataf,argp,"r");
			lsplit(fld-1, dataf);
			}
		}
	if (dataf == (FILE *) NULL)
		{
		dataf = stdin;
		lsplit(fld-1, dataf);
		}
	prcnt();
}

prcnt()
{
	if (cnt && vflg)
		fprintf(stderr,"%s %s %d %srecord%s\n",prevbuf,
			outf == stdout ? "[nofile]" : "-",
			cnt, file_appended ? "more " : "",
			cnt == 1 ? "" : "s");
}

lsplit(fld, file)
int fld;
FILE *file;
{
	register int nf, i;
	register char *fp;

	while(fgets(buf, BSIZ, file)) {
		nf = gparse(buf,bp,MAXFLDS, sep);
		fp = bp[fld];
		if (nf < fld) {
			fputs("Not enough flds\n", stderr);
			putrec(nf,stdout);
			continue;
		}
		if (strcmp(fp, prevbuf)) {
			prcnt();
			file_appended = 0;
			if (aflg && (*fp == 0 || stat(fp,&statb) < 0))
				{
				if (Aflg)
					{
					if (outf != NULL && outf != stdout)
						fclose(outf);
					outf = stdout;
					if (vflg > 1)
						fprintf(stderr,"stdout %s\n",fp);
					}
				else
					err("%s - not found",fp);
				}
			else
				{
				file_appended = !cflg && (stat(fp,&statb) >= 0);

				outf = myopen(outf == stdout ? (FILE *) NULL : outf, fp, cflg ? "w" : "a");
				if (!file_appended && ++nfiles > MAXFILES)
					err("more than %d files created", MAXFILES);
				if (vflg > 1)
					fprintf(stderr,"opened %s\n",fp);
				}
			strcpy(prevbuf, fp);
			cnt = 0;
		}

		putrec(nf,outf);
		++cnt;
	}
}

putrec(nf,file) FILE *file;
{
	register int i;

	if (nf)
		fputs(bp[0], file);
	for(i=1; i < nf; i++) {
		putc(ofs,file);
		fputs(bp[i], file);
	}
	putc('\n',file);
}
