#include <stdio.h>
/*	Copyright 1981 by David Zittin, Biosciences Data Centre.	 */
#include "treedef.h"

/* MAXPRINT=no. of data */
#define MAXPRINT 10

/* print the data. do an inorder traversal of the data tree, going out
on a limb (i.e. the assoc limked list) for each data node */

pr_data(root, rank_root)
DTNODE *root;
RTNODE *rank_root;
{
	register DNODE *dp, *trail=NULL;	/* trailing ptr for cfree */
	register int n=1;			/* start n=1 for mod */
	float get_rank();
	extern float rank_sq;	/* rank(i) sqrd / n(i) */
	extern int a;		/* the number of grps */
	extern int echo;	/* data echo flag */

	if(root != NULL){	/* process case */
		a++;
		pr_data(root->ltd, rank_root);
		if (echo)
			printf("\n\n\n>>> %s MIN=%1.3f  MAX=%1.3f==>\n\t\t", root->dkey,root->min, root->max);
		for(dp=root->start; dp!=NULL; dp=dp->next){
			if (trail != NULL)
				cfree (trail);
			if (echo)	
				printf("%1.3f  ", dp->data);

		/* calc sum of ranks */
			root->ranksum += get_rank(rank_root, dp->data);

			if (echo && !(n % MAXPRINT))
				printf("\n\t\t");
			n++;
			trail = dp;
		}
		n--;			/* subtr init val of one */
		cfree (trail); 		/* fspace the last node */
		rank_sq += (root->ranksum * root->ranksum) / n;
		pr_data(root->rtd, rank_root);
	} /* if */
}
