#include <stdio.h>
/*	Copyright 1981 by David Zittin, Biosciences Data Centre.	 */
#include "treedef.h"
#define SMALL (-32000)
#define ON 1
#define	TEST(x,a,b) ((x) ? a : b)
#define BADDATA {fprintf(stderr,"%d:bad data \"%s %s\"\n",line,inputstr,number);exit(1);}

float count = 1.0;	/* n total */
int line=0;		/* location in input data */
char *chi_tab = "/usr/lib/tab/chi_table";	/* chisq table */
char *badeod = "unexpected end of data\n";

/* a and rank_sq are global to pr_data routine */
int a=0;		/* the number of cases */
float rank_sq = 0.0;	/* sum of ranks sqrd div n(i) */

/* the program flags and user msgs as set up by routine getdata */
char *casestr = NULL;	/* usr case/treatment string */
int echo = ON;

/* usr title, if supplied. see also getdata() */
char *title = NULL;

main(){
	float x;			/* usr datum after sscanf conv */
	float h, t=0.0, df, chi_val, lookup();	
	char *strsave(), *calloc();
	char *inputstr, *number;	/* ptrs into input buf */
	int maxties=SMALL;
	int sscanf();
	int *tie_vec;			/* tievec = tie bin vec */
	register int i;			/* general purpose index */
	RTNODE *r_root;	/* root of rank tree */
	DTNODE *d_root;	/* root of data tree */
	
	d_root = r_root = NULL;

	while (getdata(&inputstr) != EOF){
		if (casestr == NULL){		/* input str is the case */
			if(getdata(&number) == EOF){
				fprintf(stderr,"%s", badeod);
				exit(1);
			}
		}

		else{				/* auto repeat:usr cntrlcard */
			number = inputstr;
			inputstr = casestr;
		}

		if (sscanf(number,"%f", &x) != 1)
			BADDATA;

		mkdata(&d_root, inputstr, x);	/* bld data tree */
		mkranks(&r_root,x);		/* bld rank tree */
	} /* while reading data */

	get_maxties(r_root, &maxties);		/* find max tie val */
	GSPACE (tie_vec,int,maxties);		/* get a tie bin */
	for(i=0; i<maxties; i++)
		tie_vec[i] = 0;	

	bin_ranks(r_root, tie_vec);		/* bin the ties */
	for (i=0; i<maxties; i++)		/* calc D */
		if (tie_vec[i])
			t += tie_vec[i] * (i) * (i+1) * (i+2);

/* calc ranks */
	rank (r_root);
	
/* print raw data & mk rank assgns */
	if (echo)
		printf("\n*** DATA ECHO:%s***\n", TEST(title==NULL,"",title) );
	pr_data(d_root, r_root);

	count -= 1.0;
	h = 12.0/((count+1.0) * count) * rank_sq - 3.0 * (count+1.0);
	t =  1.0 - (t / ((count-1.0) * count * (count+1.0)));
	h = h / t;

/* get chi sq val for a-1 deg free */
	if((chi_val=lookup(a-1, chi_tab)) == EOF)
		printf("no table value for %d df\n", a-1);

/* print group stats */		
	pr_grpstat(d_root); 

/* print kw summary */
	printf("\n\n\t*** KRUSKAL-WALLIS TEST:%s***\n\n", TEST(title==NULL,"",title));
	printf("\t\tdf = %d\n", a-1);
	if (a == 3)
		printf("\nWARNING:3 groups, use Siegal, table O\n");
	if (a < 3){
		printf("\nERR:df must be >= 3\n");
		if (a == 2)
			printf("use Mann-Whitney U-test\n");
		exit(1);
	}
	printf("\t\tH (Kruskal-Wallis stat adjusted for ties) = %1.3f\n",h);
	printf("\tCONCLUSION:\n\t\tSince H is %s",TEST(h >= chi_val,"equal to or larger","smaller") );
	printf(" than the tabulated chi-sq stat\n");
	printf("\t\t[p=0.05,df=%d] of %1.3f, it is %slikely there are differences between groups.\n",a-1,chi_val, TEST(h >= chi_val,"","un") );
}

/*
echo (first, last)	
DNODE *first, *last; 
{
	do{
		printf("%f\n", first->data);
		first = first->next;
	} while (first != last);
}
*/
pr_ranks(root)
RTNODE *root;
{
	if (root != NULL){
		pr_ranks (root->lt);
		printf("\nprtree=%f\n", root->key);
		printf("ties=%f\n", root->ties);
		pr_ranks(root->rt);
	}
}
