	call p1130
	call ggr(0.0,100,0.0,50.0,10.0,10.0,6.0,6.0,'hithere','world')
	call psend
	stop
	end

	subroutine ggr(xs, xf, ys, yf, xgr, ygr, sclx, scly,
     #	               xaxis, yaxis)
	character*1 xaxis(1), yaxis(1), null
	parameter (titlew = .15, titleh = .2)
c	parameter (term1 = '&', term2 = '&')
	parameter (maxlen = 255)
	parameter (yskip = .65, xskip = 1.05)
	parameter (piby2 = 1.570797)
	data null/'\0'/
c
c  routine to draw, dimension, and label x and y axes.
c	xs,xf => max,min values on x-axis.
c	ys,yf =>  "   "    "    "  y-axis.
c	xgr,ygr=>user's units between x,y tic marks (-ve => no tic labels).
c	sclx,scly => length of x and y axes.
c	xaxis, yaxis => labels for x,y axes (terminated by '"term1""term2"')
c
c  set up scaling factors in
c	inches / user's units
c
      scx = sclx/(xf-xs)
      scy = scly/(yf-ys)
c
c  set up scaling.  note that xs - .25/scx is to allow for the
c  	y-axis label.
c
	call scalf(scx, scy, xs-.30/scx, ys)
c
c  x - a x i s    d r a w i n g
c
      xa = xs-.6/scx
      ya = ys-.25/scy
      xk = xs
      ngr = (xf-xs)/abs(xgr)+0.0001
	if ( xgr .lt. 0 ) go to 9
      j = ngr+1
c
c  put in tic labels.
c
      do 10 l = 1,j
      call fchar (xa,ya,0.1,0.1,0.0)
      if (xk) 1, 2, 2
1     xkk = xk-.0005
      go to 3
2     xkk = xk+.0005
3     if (abs(xgr).ge..01) go to 11
      write (7,700) xkk
      call pflag
700   format (f8.3)
      go to 14
11    if (abs(xgr).ge.0.1) go to 12
      write (7,701) xkk
      call pflag
701   format (f8.2)
      go to 14
12    if (abs(xgr).ge.1.) go to 13
      write (7,702) xkk
      call pflag
702   format (f8.1)
      go to 14
13    write (7,703) xkk
      call pflag
703   format (f8.0)
14    xk = xk+xgr
10    xa = xa+xgr
c
c  draw x-axis (note:  drawn backwards).
c
 9	continue
      call fgrid (2,xf,ys,abs(xgr),ngr)
      ngr = (yf-ys)/abs(ygr)+0.0001
c
c  y - a x i s    d r a w i n g
c
c  draw axis.
c
      call fgrid (1,xs,ys,abs(ygr),ngr)
	if ( ygr .lt. 0. ) go to 8
      ya = yf
      xa = xs-.85/scx
      j = ngr +1
      xk = yf+.0001
c
c  draw tic marks.
c
      do 20 l = 1,j
      call fchar (xa,ya,0.1,0.1,0.0)
      if (xk) 4, 5, 5
4     xkk = xk-.0005
      go to 6
5     xkk = xk+.0005
6     if (abs(ygr).ge..01) go to 21
      write (7,700) xkk
      call pflag
      go to 16
21    if (abs(ygr).ge.0.1) go to 22
      write (7,701) xkk
      call pflag
      go to 16
22    if (abs(ygr).ge.1.) go to 23
      write (7,702) xkk
      call pflag
      go to 16
23    write (7,703) xkk
      call pflag
16    xk = xk-ygr
20    ya = ya-ygr
 8	continue
c
c  do y-axis label.  first find it's length (<=255 chars).  if length=0,
c    go on to x-axis.  note: label must consist of at least '&&'.
c
	do 30 len = 1, maxlen
	if ( (yaxis(len) .eq. '&') .and. (yaxis(len+1) .eq. '&') )
     #	     go to 31
 30	continue
	write,'invalid y-axis label: no terminating string'
	go to 32
 31	continue
	if ( len .eq. 1 ) go to 32
	len = len - 1
	x = xs - xskip / scx
	y = ys + (scly - titlew * len) * .5 / scy
	call fchar(x, y, titlew, titleh, piby2)
	write(7,704) (yaxis(i),i=1,len)
 704	format(255a1)
	call pflag
 32	continue
c
c  do x-axis label.  same proceedure as for above.
c
	do 33 len = 1, maxlen
	if ( (xaxis(len) .eq. '&') .and. (xaxis(len+1) .eq. '&') )
     #	    go to 34
 33	continue
	write,'invalid x-axis label: no terminating string'
	go to 35
 34	continue
	if ( len .eq. 1 ) go to 35
	len = len - 1
	x = xs + (sclx - titlew * len) * .5 / scx
	y = ys - yskip / scy
	call fchar(x, y, titlew, titleh, 0.)
	write(7,704) (xaxis(i), i=1, len)
	call pflag
 35	continue
c
	call penup
	call psend
	call fplot(0, xs, ys)
      return
      end
