#include <stdio.h>
#include <ixh.h>

#define FIRSTROW 0
#define FISHEREXACT 0
#define THREEWAY 1
#define RC 2
#define true 1
#define false 0
#define OBS 1
#define PCT 2
#define EXP 3



struct usrcmds {
	char	test,
		label,
		*progname,
		*title,
		*filename;
} usroptions;

struct usrcmds *usr = &usroptions;
		
	

	/* if mat is redimensioned then redimension TABSIZ's below */
#define MATCOL 30
#define MATROW 30
float mat[MATROW][MATCOL];
float rowtot[MATROW];
float coltot[MATCOL];

char *rownames[MATROW];		/* a place to store ptrs to usr col-row names */
char *colnames[MATCOL];

float initval=(-1.0);		/* set each element of mat to init val */
int colcnt[MATCOL];


	/* TABSIZ must be at least 1.25 larger than the corresponding row/col
		dimension and should be a prime number */

#define COLTABSIZ 41
#define ROWTABSIZ 41

TABLE coltable[COLTABSIZ];
TABLE rowtable[ROWTABSIZ];

#define BUFSIZ 64
char rowbuf[BUFSIZ];
char colbuf[BUFSIZ];
char *toosmall = "%s:matrix toosmall";

int maxrow=(-1), maxcol=(-1), ntot=0;

main(argc,argv)
int argc;
char *argv[];
{
	register char *argp;
	register int i;
	int fileflg=0;
	int labels(), nolabels();
	char *strsave();
	FILE *datafile=NULL, *myopen();


	usr->progname = argv[0];
	usr->label = true;
	usr->test = RC;
	usr->filename = usr->title =  "";

	for(i=1; i < argc; i++) {
		argp = argv[i];
		if(*argp == '-' || *argp == '@') {
			switch(*++argp){
				case 'n': usr->label = false;
					  break;
				case 'h': usr->title = strsave(argv[++i]);
					  break;
				case 'F': usr->test = FISHEREXACT;
				case '3': usr->test = THREEWAY;
					  err("%s:3-way & Fisher exact not implemented",usr->progname);
					  break;
				default: err("%s:unknown switch",usr->progname);
					 break;
			}
				
		}	
		else {
			usr->filename = argp;
			datafile = myopen(datafile, argp, "r");
			++fileflg;
			if (usr->label)
				drive(labels, datafile);
			else
				drive(nolabels, datafile);
		}
	}

	if (!(fileflg)) {
		if (usr->label)	
			drive(labels,stdin);
		else
			drive(nolabels, stdin);
	}
				
}

drive(input, datafile)
int (*input)();
FILE *datafile;
{
	double x, chisq(), wc();

	init(mat, MATCOL * MATROW, initval);
	if (usr->test == RC) {		/* there will be other opts later */
		(*input)(datafile);
		chk_col(colcnt, maxcol);
		x = chisq(mat, ntot, rowtot, coltot, maxrow, maxcol);
		x /= wc(rowtot, coltot, maxrow, maxcol, ntot);
		usr_report(x, maxrow * maxcol);
	}
}

usr_report(chistat, df)
double chistat;
int df;
{
	double lookup();
	float tableval;
	char *lg, *likely;

	printf("\nA %d X %d TEST OF INDEPENDENCE USING THE G-STATISTIC\n",maxrow+1, maxcol+1);

	pc("\nCONTINGENCY TABLE SUMMARY");
	if (*usr->title)
		printf(" FOR %s", usr->title);
	if (*usr->filename)
		printf(" (data from file %s)", usr->filename);
	pc(":\n");
		
	table_summaries();

	tableval = lookup(df);

	printf("\nthe calculated G-stat (with Williams' correction)=%1.3f\n", chistat);

	if ( chistat >= tableval ) {
		lg = "greater/equal to";
		likely = "";
	}
	else {
		lg = "less than";
		likely = "un";
	}
	printf("\nCONCLUSION:\n");
	printf("\tsince the G-stat (%1.3f) is %s the tabulated chisq value\n", chistat, lg);
	printf("\tof %1.3f [p=0.05,df=%d], it is %slikely there are dependencies\n", tableval, df, likely);
	printf("\tbetween the row-column attributes.\n");
}

table_summaries(){
	register int i, j=true;
	int k, m;
	int expflg=false;
	int prflg=true;
	char *cfmt="%7c", *fmt0="%7.0f", *fmt1="%7.1f";
	char *sfmt = " %-5s";
	float xp;

	if (usr->label) {
		while (prflg) {
			pc("\n\t");
			prflg = false;
			if (j) {
				colnames[maxcol+1] = "sums";
				j = false;
			}
			for(i=0; colnames[i]; i++) {
				if (*colnames[i]) {
					++prflg;
					printf(cfmt, *colnames[i]++);
				}
				else
					printf(cfmt, ' ');
			}
				
		} /* while */
	}

	pc("\n");
	for(k=0; k <= maxrow; k++) {
		if (rownames[k])
			printf("%s:\n", rownames[k]);
		else
			printf("row %d:\n", k+1);

		for(i=OBS; i <= EXP; i++) {
			switch(i) {
				case OBS: printf(sfmt, "obs");
					  break;
				case PCT: printf(sfmt, "%obs");
					  break;
				case EXP: printf(sfmt, "expct");
					  break;
			} /* sw */

			printf("|\t");
			for(j=0; j <= maxcol; j++) {
				switch(i){
				case OBS: printf(fmt0,  mat[k][j]);
					if (j == maxcol) {
						pc(" |");
						printf(fmt0, rowtot[k]);
					}
					break;
				case PCT: printf(fmt1,100.0 * mat[k][j]/ntot);
					if (j == maxcol) {
						pc(" |");
						printf(fmt1, 100.0 * rowtot[k]/ntot);
						pc("%");
					}
					break;
				case EXP: xp = rowtot[k] * coltot[j] / ntot;
					printf(fmt1, xp);
					if ( j == maxcol )
						pc(" |");
					if ( xp < 5.0 )
						expflg = true;
					break;
				} /* sw */

			}
			pc("\n");
		}
	}
	pc("      |");
	for(i=0; i <= maxcol+4; i++)
		pc("------");
	pc("\n");
	printf(sfmt,"sums");
	pc("  ");
	for(i=0; i <= maxcol; i++)
		printf(fmt1, coltot[i]);
	printf("\tN = %d %s\n", ntot, "(100%)" );
	printf(sfmt,"%obs");
	pc("  ");
	for(i=0; i <= maxcol; i++)
		printf(fmt1, 100.0 * coltot[i] / ntot);
	pc("%\n\n");

	if (expflg)
		printf("\nWARNING:some expecteds < 5!\n\n");
}

pc(s)
register char *s;
{
	while (*s)
		putc(*s++,stdout);
}

nolabel(datafile)
FILE *datafile;
{

	register int col=0;
	int strcmp(), sscanf(), fscanf();
	float x;


	maxrow = maxcol = 0;
	while(fscanf(datafile,"%s", rowbuf) != EOF){
		if (!(strcmp(rowbuf,"end"))){
			maxrow++;
			if (col > maxcol)
				maxcol = col;
			if (maxrow >= MATROW)
				err(toosmall,usr->progname);
			col = 0;
		}

		else if(!(strcmp(rowbuf, "stop"))){
			--maxcol;
			return;
		}

		else {
			if(sscanf(rowbuf,"%f", &x) != 1)
				err("%s:bad conversion \"%s\"", usr->progname,rowbuf);
			if (x < 0.0)
				err("%s:val < 0.0 \"%s\"",usr->progname,rowbuf);
			mat[maxrow][col] = x;
			if (col > maxcol)
				maxcol = col;
			rowtot[maxrow] += x;
			coltot[col] += x;
			colcnt[col]++;
			ntot += x;
			if (++col >= MATCOL)
				err(toosmall, usr->progname);
		}
	}
}

labels(datafile)
FILE *datafile;
{
	register int col, row;
	char *strptr;
	int x, nctable=0, nrtable=0;
	int ixh();
	int conv, fscanf();


			/* reuse global rowbuf as a general buffer */
	while((conv=fscanf(datafile,"%s %s %d", rowbuf, colbuf, &x)) != EOF){
		if (conv != 3)
			err("%s:bad conversion \"%s %s\"", usr->progname, rowbuf,colbuf);

		row = ixh(rowbuf, &rowtable, ROWTABSIZ, &nrtable, &strptr);
		if ( !(rownames[row] ))
			rownames[row] = strptr;

		col = ixh(colbuf, &coltable, COLTABSIZ, &nctable, &strptr);
		if(!(colnames[col]))
			colnames[col] = strptr;


		if ( x < 0.0 )
			err("%s:val < 0.0", usr->progname);
		if ( mat[row][col] > initval )
			err("%s:attempt to reuse cell %s %s", usr->progname,rowbuf,colbuf);
		mat[row][col] = x;
		rowtot[row] += x;
		coltot[col] += x;
		colcnt[col]++;
		ntot += x;
		if (row > maxrow) maxrow = row;
		if (col > maxcol) maxcol = col;
	}
}



	/* williams correction */
double wc(rowsum, colsum, nrows, ncols, ntot)
float rowsum[MATROW], colsum[MATCOL];
int nrows, ncols;
{
	register int i;
	double tmp1=0.0, tmp2=0.0;

	for(i=0; i <= nrows; i++)
		tmp1 += ntot / rowsum[i];

	for(i=0; i <= ncols; i++) 
		tmp2 += ntot / colsum[i];
	
	tmp1 -= 1.0;
	tmp2 -= 1.0;
	return (1.0 + (tmp1 * tmp2) / (6.0 * ntot * nrows * ncols) );
}



double chisq(mat, n, rowtot, coltot, row, col)
float mat[MATROW][MATCOL];
int n;
float rowtot[MATROW];
float coltot[MATCOL];
int row, col;
{
	register int i, j;
	double log(), tmp;
	float row_col_tot = 0.0;
	float celltot = 0.0;

	for(i=0; i <= col; i++)
		row_col_tot += coltot[i] * log(coltot[i]);
	for(i=0; i <= row; i++) {
		row_col_tot += rowtot[i] * log(rowtot[i]);
		for(j=0; j <= col; j++)
			celltot += mat[i][j] * log(mat[i][j]);
	}
	tmp = n;

	return(2.0 * (celltot - row_col_tot + tmp * log (tmp)));
}

			




chk_col(colcnt, maxcol)
register int *colcnt, maxcol;
{
	register int i;
	int prev;
	for(i=0; i <= maxcol; i++) {
		if (i != 0 && *colcnt != prev)
			err("%s:nonrectangular data matix", usr->progname);
		prev = *colcnt++;
	}
}
	
init(mat, n, initval)
register float *mat;
register int n;
float initval;
{
	while(n){
		*mat = initval;
		++mat;
		--n;
	}
}


double lookup(a)
int a;
{
	FILE *fp=NULL, *myopen();
	double stat;
	int savedf=a;

	fp = myopen(fp, "/usr/lib/tab/chi_table", "r");

	while ( a-- )
		if(fscanf(fp, "%f", &stat) == EOF)
			err("no chsq table entry for %d df", savedf);
	return(stat);
}
