      subroutine fandc(irray,len,ichar,num,ist,ifin,icf,iret)
c
c     routine fandc finds in the string "irray(ist...len)" an
c     occurrance of any character in "ichar(1...num)"
c     iret    result
c
c     1       character "ichar(icf)" found at "irray(ifin)"
c     2       not found
c     3       error in initial conditions
c
      logical*1 irray(len), ichar(num)
      logical*1 temp
      logical eqc
      iret = 1
      if (ist .le. 0) go to 98
      if (ist .gt. len) go to 98
      if (num .le. 0) go to 98
c
c     initial conditions ok, proceed with actual scanning
c
      do 10 i = ist, len
      temp=irray(i)
      do 10 j = 1, num
      if(eqc(temp,ichar(j))) go to 11
   10 continue
c
c     not found
c
      iret = 2
      go to 99
c
c     error in initial conditions
c
   98 iret = 3
      go to 99
c
c     found - return position
c
   11 ifin = i
      icf = j
   99 return
      end
      subroutine trnz(numb,irray,ioldc,inewc,numbl,iret)
c
c     trnz will scan string "irray(1...numb)" for each character in
c     the string "ioldc(1...numbl)" and translate it into the
c     corresponding character in the string "inewc(1...numbl)".
c
c     if a character appears more than once in "ioldc" only the first
c     is used.
c
c     iret=1 normally, =2 if initial conditions bad
c
      logical*1 irray(numb), ioldc(numbl), inewc(numbl)
      logical eqc
      iret = 1
      if (numb .le. 0) go to 98
      if (numbl .le. 0) go to 98
      do 10 i = 1, numb
      do 20 j = 1, numbl
      if(eqc(irray(i),ioldc(j))) go to 21
   20 continue
      go to 10
   21 irray(i) = inewc(j)
   10 continue
      return
   98 iret = 2
      return
      end
      subroutine dzb(ifrom,int,nc,nsd,ifil,iret)
      logical*1 ifil(2), idel(2), ifrom(2)
      dimension lwds(2,10)
      data idel / ' ',' ' /
      iret = 1
      call mavec(1,ifil,idel(2),iretx)
      call scset(idel,2)
      call scan(ifrom,nc,lwds,nwds)
      is = lwds(1,1)
      if = lwds(2,1)
      call fget(ifrom,is,if,x,ierr)
      ierr = ierr + 1
      go to (11,98), ierr
   11 int = x
      nl = if
   99 return
   98 iret = 2
      go to 99
      end
      subroutine fandst(irray,len,istr,numb,is,if,iret)
      logical*1 irray(len), istr(numb)
      logical eqcmp
      iret = 1
      if (is .le. 0) go to 98
      if (is .gt. len) go to 98
      if (numb .le. 0) go to 98
      do 10 i = is, len
      if(eqcmp(numb,irray(i),istr)) go to 11
   10 continue
      iret = 2
      go to 99
   11 if = i
   99 return
   98 iret = 3
      go to 99
      end
      subroutine mavec(length,if,it,iret)
      logical*1 if(length), it(length)
      iret =1
      if (length .le. 0) go to 98
      if (length .gt. 32767) go to 98
      do 10 i = 1, length
      it(i) = if(i)
   10 continue
   99 return
   98 iret = 2
      go to 99
      end
      subroutine setc(num,buff,char)
      logical*1 buff(num), char
      do 10 i = 1, num
      buff(i) = char
   10 continue
      return
      end
      subroutine fget (icard, i1, i2, x, ierr)
c   converts characters in array icard from i1 to i2 from a1 format to t
c   real number that they represent.
c   ierr is normally = 0, if a non-numeric character is encountered it i
c   returned = 1.
c     program by jeff stander
      logical*1 ic(10),num
      logical*1 icard(i2)
      logical*1 ibar,iblnk,idot,e
      logical eqc
      logical*1 iplus
      data iplus/'+'/
      data ibar,iblnk,idot,e/'-',' ','.','e'/
      data ic/'0','1','2','3','4','5','6','7','8','9'/
      sine =1.
      mark = i2
      ierr = 0
      x = 0.
      if(i2.lt.i1) go to 99
      do 50 i = i1,i2
      num=icard(i)
      if(eqc(num,ibar)) go to 5
      if(eqc(num,iblnk)) go to 50
      if(eqc(num,iplus)) go to 50
      if(eqc(num,e)) go to 60
      if(.not.eqc(num,idot)) go to 30
c
c     got decimal point - test if more than 1
c
   45 if(mark.ne.i2) go to 99
      mark = i
      go to 50
    5 sine = -1.
c
      go to 50
c
c     not special character - test if digit
c
   30 do 35 j=1,10
      if(eqc(num,ic(j))) go to 38
   35 continue
      go to 99
   38 continue
c
c     digit - add into number
c
   48 x = x*10. + float(j-1)
   50 continue
   55 x = x *  10. ** (mark-i2)
      x = sign(x,sine)
      return
   99 ierr = 1
      return
c
c     exponent specified - get rest of number
c
   60 continue
      exp=0
      isign=1
      k=i+1
      if(k.gt.i2) go to 99
      do 70 i=k,i2
c
      num=icard(i)
      do 80 j=1,10
      if(eqc(num,ic(j))) go to 90
   80 continue
      if(eqc(num,iblnk)) go to 70
      if(eqc(num,iplus)) go to 70
      if(.not.eqc(num,ibar)) go to 99
      isign=-1
      go to 70
   90 exp=exp*10+j-1
   70 continue
      mark=mark+exp*isign
      go to 55
      end
      function lsizeb(buff,len)
      logical eqc
      logical*1 buff(len)
      logical*1 blank
      data blank/' '/
c
c     scan backwards in buff for last non-blank character
c     returning its possition in buff. if all blank
c     then just return a 1.
c
      k=len+1
      do 10 i=1,len
      k=k-1
      if(.not.eqc(buff(k),blank)) go to 20
   10 continue
   20 lsizeb=k
      return
      end
      subroutine ignore(buff,len,chars,lchar,inptr,last,iret)
      integer lchar
      logical*1 char
      logical eqc
      logical*1 buff(len), chars(lchar)
      if(inptr.gt.len) go to 299
      do 5 last = inptr, len
      char = buff(last)
      do 7 i=1,lchar
      if(eqc(char,chars(i))) go to 5
    7 continue
      iret = 1
      return
    5 continue
      last = len + 1
c
c     ran out of input buffer
c
  199 iret = 2
      return
  299 iret = 3
      return
      end
	subroutine scan(buff,len,lwds,nwds)
	call nscan(buff,len,lwds,10,nwds)
	return
	end
      subroutine nscan(buff,len,lwds,kwds,nwds)
c
c     scan buffer "buff" of length "len" for delimeters in "idel"
c     of length "ndel". the locations of the symbols found are
c     stored into lwds. "nwds" returns the number of symbols
c     found.
c
      logical*1 buff(len), idel(10)
      common /sccom/ ndel, idel
      dimension lwds(2,kwds)
      nwds = 0
c
c     l = 0 means looking for delimiter
c     l = 1 means looking for word
c
      l = 1
      do 10 i = 1, len
      call fandc(buff(i),1,idel,ndel,1,if,icf,iret)
      go to (11,12,99), iret
   11 if (l .eq. 1) go to  10
      lwds(2,nwds) = i - 1
      l = 1
      go to 10
   12 if (l .eq. 0) go to 10
      nwds = nwds + 1
      lwds(1,nwds) = i
      l =  0
   10 continue
      if (l .eq. 0) lwds(2,nwds) = len
   99 return
      end
      subroutine scset(id,nd)
c
c     set delimiters for subsequent call to scan.
c
      logical*1 idel(10), id(nd)
      common /sccom/ ndel, idel
      ndel = nd
      call mavec(ndel,id,idel,irt)
      return
      end
      logical function eqcmp(len,s1,s2)
c
c     compare string s1(1...len) with s2(1...len)
c     and return .true. if equal and .false. if not
c
      logical*1 s1(len), s2(len)
      logical eqc
      do 10 i=1,len
      if(.not. eqc(s1(i),s2(i))) go to 20
   10 continue
      eqcmp = .true.
      return
   20 eqcmp = .false.
      return
      end
      subroutine trst(buff,length,old,new,l,iret)
c
c     translate string "old" in buff(ipos...length) to "new"
c     both old and new are "l" characters long
c
      logical*1 buff(length), old(l), new(l)
      call fandst(buff,length,old,l,1,iend,iret)
      if(iret.gt.1) return
      call mavec(l,new,buff(iend),id)
      return
      end
      subroutine valfnd(buff,ln,string,len,value,irtt)
      logical*1 buff(ln), string(len)
      logical*1 blank
      data blank/' '/
c
c     this subroutine finds the vaue of a variable occuring
c     after a specified string in a buffer.
c     for instance if one wanted to read an number after a string
c     like 'age=25', you would speccify 'age=' and this routine
c     would return the 25.
c     a return1 indicates the specified string as not found
c     a return2 indicates a error return while reading the value
c
c     find the specified string
      irtt = 1
      call fandst(buff,ln,string,len,1,ifin,irt)
      if(irt .ne. 1) go to 199
      ifin = ifin + len - 1
c
      lnn = ln - ifin
      call fget(buff(ifin+1),1,lnn,value,irt)
      if (irt .ne. 0) go to 299
c
      return
  199 irtt = 2
      return
  299 irtt = 3
      return
      end
      subroutine strfnd(buff,ln,string,len,strval,lng,irtt)
      logical*1 buff(4), string(1)
      logical*1 strval(8)
      logical*1 blank
      data blank/' '/
c
c     this subroutine finds the vaue of a variable occuring
c     after a specified string in a buffer.
c     for instance if one wanted to read an integer after a string
c     like 'age=25', you would speccify 'age=' and this routine
c     would return the 25.
c     the string is returned in "strval" and its length in "lng".
c     a return1 indicates the specified string as not found
c     a return2 indicates a error return while reading the value
c
c     find the specified string
      irtt = 1
      call fandst(buff,ln,string,len,1,ifin,irt)
      if(irt.ne.1) go to 199
      ifin = ifin + len - 1
c
      lnn = ln - ifin
      lng = 20
      call fandc(buff,ln,blank,1,ifin+1,if,ic,irt)
      if (irt .eq. 2) go to 299
      nln = if - (ifin+1)
      call mavec(nln,buff(ifin+1),strval,irt)
      lng = nln
c
      return
  199 irtt = 2
      return
  299 irtt = 3
      return
      end
