#
#define IMASK 060000
#define IDIR 040000

rfp(pathname,proc,pattern)
char *pathname;
int (*proc)();
char *pattern;
{
/* recursive file processor - given a path name it calls
   (*proc)(pathname,fildes,statbuff);
   for all files on the tree that match pattern.
 */
int fildes;
register char *p;
register char *s;
register char *q;
char *oldp;
struct {
	int ino;
	char name[16]; /* leave space for nulls */
	} entry;

static struct {
	char minor;
	char major;
	int inumber;
	int flags;
	char nlinks;
	char uid;
	char gid;
	char size0;
	int size1;
	int addr[8];
	int actime[8];
	int modtime[8];
	} statbuff;

/*
printf("rfp(%s,%o,%s)\n",pathname,proc,pattern ? pattern : "");
 */
p = pathname; /* pointer tothe name */
if (pattern && match(p,pattern))
	pattern = 0;
fildes = open(p,0); /* open for reading */ 
if (fildes<0)
	return(0); /* file not found error */

fstat(fildes,&statbuff); /* find out about it */
if ((statbuff.flags&IMASK)!=IDIR) /* simple file */
	{
	return((*proc)(p,fildes,&statbuff));
	};

/* directory */ 

if (*p=='.' && *++p==0)	/* current directory */
	pathname = p+1;
if (*p=='/' && *++p==0) /* top level */
	pathname = p;
while (*p++) ; /* find end of name */ 
--p; /* back up to point to the null */
oldp=p; /* keep track of it */
*p++ = '/'; /* build rest of path name */

while ((read(fildes,&entry,16))==16)
{
if (entry.ino==0 || entry.name[0]=='.')
	continue;
s = p; /* copy pathname pointer */ 
q = &entry.name[0]; /* point to rest of name */ 
entry.name[14]='\0'; /* insure followed by a null */
while (*s++ = *q++) ; /* copy the name */ 
if (!pattern || match(pathname,pattern))
	rfp(pathname,proc,0);
};
close(fildes);
*oldp = '\0'; /* restore path name */
return(1);
}
