#ifndef v6

#include <sys/param.h>
#include <sys/types.h>
#include <stat.h>

time_t modtime(file) char *file;
{
struct stat statb;

if (file >= (char *)NOFILE)
	{
	if (stat(file,&statb) < 0)
		return(-1);
	}
else
	{
	if (fstat(file,&statb) < 0)
		return(-1);
	}
return(statb.st_mtime);
}
#else

#define	NOFILE	20
#define	IALLOC	0100000
#define	IFMT	060000
#define		IFDIR	040000
#define	IFCHR	020000
#define	IFBLK	060000

struct stat
{
char s_minor;
char s_major;
int s_inumber;
int s_flags;
char s_nlinks;
char s_uid, s_gid;
char s_size0;
int s_size1;
int s_addr[8];
int s_actime[2];
int s_modtime[2];
} ;

struct {
int s_dev;
int s_inumber;
int s_flags;
char s_nlinks;
char s_uid, s_gid;
char s_size0;
int s_size1;
int s_addr[8];
long s_atime;
long s_mtime;
};

long modtime(file) char *file;
{
struct stat statb;

if (file >= NOFILE)
	{
	if (stat(file,&statb) < 0)
		return(-1);
	}
else
	{
	if (fstat(file,&statb) < 0)
		return(-1);
	}
return(statb.s_mtime);
}
#endif
