#include <time.h>

#define	gmdadd(m,n) timbuf = timbuf * m + n
#define	gdadd(n) timbuf += n

int	dmsize[];

long gtime(tm) struct tm *tm;
{
	register int i;
	register int y, t;
	int d, h, m;
	long timbuf;

	t = tm->tm_mon+1;
	if(t<1 || t>12)
		goto bad;
	d = tm->tm_mday;
	if(d<1 || d>31)
		goto bad;
	h = tm->tm_hour;
	if(h == 24) {
		h = 0;
		d++;
	}
	if (h < 0 || h > 24)
		goto bad;
	m = tm->tm_min;
	if(m<0 || m>59)
		goto bad;
	y = tm->tm_year;
	timbuf = 0;
	y =+ 1900;
	for(i=1970; i<y; i++)
		gdadd(dysize(i));
	/* Leap year */
	if (dysize(y)==366 && t >= 3)
		gdadd(1);
	while(--t)
		gdadd(dmsize[t-1]);
	gdadd(d-1);
	gmdadd(24, h);
	gmdadd(60, m);
	gmdadd(60, 0);
	timbuf += tm->tm_sec;
	return(timbuf);

bad:
	return(-1l);
}

long ltime(tm) register struct tm *tm;
{
long timbuf = gtime(tm);
extern int timezone;

if (timbuf < 0)
	return(timbuf);
/* fix up time zone */
timbuf += timezone;
/* Now fix up to local daylight time. */
if (localtime(&timbuf)->tm_isdst)
	timbuf -= 1*60*60;
return(timbuf);
}

#ifdef DEBUG
main()
{
long now,new;
register struct tm *tm;

time(&now);
tm = localtime(&now);
new = ltime(tm);
printf("%D :: %D\n",new,now);
printf("%s",ctime(&new));
printf("%s",ctime(&now));
}
#endif
