
struct fsdir
{
int d_magic;
int d_no;
char d_name[58];
char d_ids[2];
int d_sdate[2];
int d_vers;
int d_mdate[2];
int d_flags;
long d_size;
} fsdir;
long size;

int tflg, xflg;
int sflg;
int wflg;
int dflg;		/* suppress date */
char buff[4096];
char *tapename;
int tape;
char file[64];
main(argc,argv)
char **argv;
{
register int l;
register int out;
register char *argp;

--argc; ++argv;
tapename = "/dev/rmt0";
while (argc > 0 && (argp = argv[0])[0] == '-')
	{
	++argp;
	while (*argp)
		{
		switch(*argp)
			{
		case 's':		/* not system files */
			++sflg;
			break;
		case 'x':
			++xflg;
			break;
		case 'd':
			++dflg;
			break;
		case 't':
			++tflg;
			break;
		default:
			if (*argp >= '0' && *argp <= '7')
				tapename[8] = *argp;
			else
				err("bad option %c",*argp);
			}
		++argp;
		}
	--argc; ++argv;
	}
if (!xflg)
	++tflg;
tape = open(tapename,0);
if (tape < 0)
	err("can't open %s",tapename);
while (tpread(tape,buff,sizeof buff) > 0)
	{
	move(sizeof fsdir,buff,&fsdir);
	copy(fsdir.d_name,file);
	out = 0;
	if (select(file,argc,argv))
		{
		if (tflg)
			printf("%s\n",file);
		if (xflg && wanted())
			{
			if ((out = create(file,fsdir.d_flags)) < 0)
				err("can't creat %s",file);
			printf("x %s\n",file);
			}
		}
	size = fsdir.d_size;
	while ((l=tpread(tape,buff,sizeof buff)) > 0)
		{
		if (out > 0 && size > 0)
			{
			if (l > size)
				l = size;
			if (write(out,buff,l) < 0)
				err("while writing %s",file);
			size =- l;
			}
		}
	if (out > 1)
		{
		close(out);
		if (!dflg)
			mdate(file,fsdir.d_mdate);
		}
	}
}

tpread(des,bf,length)
char *bf;
{
register int l;

l = read(des,bf,length);
if (l < 0)
	l = 0;
return(l);
}

select(name,argc,argv) char *name, **argv;
{
register int i;

if (name[0] == ' ')
	return(0);
if (argc == 0)
	return(1);
for (i=0; i<argc; ++i)
	if (match(name,argv[i]))
		return(1);
return(0);
}

err(fmt,d1,d2) char *fmt;
{
printf("error: ");
printf(fmt,d1,d2);
perror("");
flush();
exit(1);
}

copy(s1,s2) char *s1, *s2;
{
while (*s2++ = *s1++)
	;
}

move(l,s1,s2) char *s1, *s2;
{
while (--l >= 0)
	*s2++ = *s1++;
}

wanted()
{
if (!wflg)
	return(1);
printf("%s?",file);
if (read(0,buff,80) <= 0)
	exit(0);
return(buff[0] == 'y');
}

create(name,flags) char *name;
{
register int i;

if (sflg)
	{
	if (name[0] == '/')
		++name;
	}
if ((i = creat(name,flags)) >= 0)
	return(i);
return(i);
}
