#include <stdio.h>
#include <utmp.h>

#define BOOTFILE "/etc/boot"	/* file changed on system boot */

struct times
{
char *name;
int factor;
long dur;
} times[]
{
	{"second", 60, 0l},
	{"minute", 60, 0l},
	{"hour", 24, 0l},
	{"day", 7, 0l},
	{"week", 52, 0l},
	{"year", 100, 0l},
	{"century", 0, 0l}
};

main(argc,argv) char **argv;
{
long now, then, modtime(), dur;
register struct times *t;
register int i;
register char *p;
register int n = users();

time(&now);
p = ctime(&now);
printf("%.16s, %d user%s, uptime", p, n, n ==1 ? "" : "s");
then = modtime(BOOTFILE);
dur = now-then;
times[0].dur = dur;
for (t = times; t->factor; ++t)
	{
	if (t->dur == 0)
		break;
	(t+1)->dur = t->dur/t->factor;
	t->dur -= (t+1)->dur*t->factor;
	}
for (i=0; ++i <= 2 && --t >= times; )
	{
	if (t->dur)
		printf(" %D %s%s",t->dur,t->name,t->dur == 1 ? "" : "s");
	}
printf(".\n");
}

users()
{
struct utmp utmp;
register FILE *f = fopen("/etc/utmp","r");
register int cnt = 0;

if (f != NULL)
	{
	for (cnt=0; fread(&utmp,sizeof utmp,1,f); )
		if (utmp.ut_name[0])
			++cnt;
	fclose(f);
	}
return(cnt);
}
