#
/*
 * UBC shell interface.
 * this program sits in /bin/sh and depending upon the entries
 * in the file /etc/shelltable it will select one of a number of
 * different shells.
 */
#define	SHTABLE "/etc/shelltable"
char *old_login "-";
char *new_login "-sh";

#define	ROOT	0

#define	V7	5
#define	CSH	3


char *shnames[] {
"default", "bell", "yale", "csh" , "test", "v7", "limit", 0 };

int uid;		/* the original uid */

#define	WRITE	2

char *sh[] {
"/bin/sh.default", "/bin/sh.bell", "/bin/sh.yale", "/bin/csh" ,
"/bin/sh.test" , "/bin/sh.v7" , "/bin/sh.limit" };

char info[256];
main(argc,argv) char **argv;
{
register int f, flag;
register char *argp;
int i;

uid = getuid()&0377;

if (argc >= 2 && *(argp = argv[1]) == '-')
	{
	for (flag=0; shnames[flag]; ++flag)
		if (equal(argp+1,shnames[flag])) 
			{
			if (argc > 2  && (i = atoi(argv[2]))
				&& access(SHTABLE,WRITE) >= 0)
			setflag(flag);
			puts("Your new shell will take effect when you next login\n");
			puts("or you may invoke the shell explicitly via 'sh'\n");
			exit(0);
			}
	}
flag = 0;
if ((f = open(SHTABLE,0)) >= 0)
	{
	if (read(f,info,256) >= uid)
		flag = info[uid];
	close(f);
	}
argv[argc] = 0;
if ((flag == V7  || flag == CSH) && equal(argv[0],old_login))
	{
	if ((i = dup(1)) != 2)
		close(i);
	if (flag == V7)
		argv[0] = new_login;
	signal(2,0);
	signal(3,0);
	}
/*
if (flag == CSH && argc == 2 && *(argp = argv[1]) != '-' &&
		isV7(argp))
 */
if (flag == CSH && isV7(argp))
	flag = V7;
setgrp();
execv(argp = sh[flag],argv);
write(2,"no shell ",9);
write(2,argp,length(argp));
write(2,"\n",1);
exit(1);
}

setflag(flag)
{
register int f;
register int old;
char *p;

f = open(SHTABLE,2);
if (f < 0)
	{
	puts("no ");
	puts(SHTABLE);
	puts("\n");
	return;
	}
read(f,info,sizeof info);
old = info[uid];

info[uid] = flag;
seek(f,uid,0);
write(f,info+uid,1);
close(f);

puts("was ");
p = shnames[old];
puts(p);
puts(" (");
p = sh[old];
puts(p);
puts(")\n");
}

puts(str) char *str;
{
write(2,str,length(str));
}

isV7(name) char *name;
{
/*
 * Test if the given shell script file is in Version 7 format.
 * (1) it must be a file and (2) look like V7 commands.
 * The asumption is that most V7 shell scripts start with
 * or could be modified to start with a shell variable assignment
 * of the form: var=string
 * therefore the first delimeter found will be "=".
 *
 */ 
register int f, l, result;
char *p;
char buff[128+1];
int sbuff[18];
#define	IFMT	060000

result = 0;
if ((f = open(name,0)) >= 0)
	{
	if (fstat(f,&sbuff) >= 0 && (sbuff[0] & IFMT) == 0)
		{
		while ((l = read(f,buff,(sizeof buff)-1)) > 0)
			{
			buff[l] = 0;
			if (p = any(buff,"=:() \t\n"))
				{
				result = *p == '=';
				break;
				}
			}
		}
	close(f);
	}
return(result);
}

setgrp()
{
setgid(getgid());	/* set gid back to invoker */
}
