#include <stdio.h>
#include <stty.h>
#include <debug.h>
#include <signal.h>

/*
 * program to drive a printer attatched to a tty line.
 * mostly arrange to handle form feeds in a reasonable
 * way:
 *	1	remove leading FF's
 *	2	add trailing FF if none present
 *	3	clean up on various interrupts
 */

#define	TTY	"/dev/tty3"	/* the default tty name */

int flags = CRMOD + EVENP + ODDP + XTABS ;
int speed = B300;
char *save();


#define	FF	014
#define	OUT_FF	0214
#define	CR	'\r'
#define	NL	'\n'

#define	MAXTTY	64
char ttyname[MAXTTY] = TTY;
FILE *ttyf;
int setup;

int ffcnt;
int lastc;
char lockfile[MAXTTY];
int locked;			/* if we locked it */
int lines;
int maxlines = 60;
int v[3];
char *initstr = "";		/* string to send to start */
char *endstr = "";		/* string to send to end */
int oldv[3];
int wflg;
int wcnt;
#define	WDELAY	10		/* how many seconds to delay */
#define	WCOUNT	6		/* print message every WCOUNT WDELAY's. */

main(argc,argv) char **argv;
{
register int i;
register char *argp;


for (i=1; i<argc; ++i)
	{
	if (* (argp = argv[i]) == '-')
		doswitch(argp+1);
	else
		{
		if (!setup)
			init();
		if (freopen(argp,"r",stdin) == NULL)
			err("can't open %s",argp);
		dofile();
		}
	}
if (!setup)
	{
	init();
	dofile();
	}
done(0);
}


init()
{
register int i;

++setup;
if ((signal(SIGHUP,SIG_IGN)) != SIG_IGN)
	signal(SIGHUP,&done);

if ((signal(SIGTERM,SIG_IGN)) != SIG_IGN)
	signal(SIGTERM,&done);

if ((signal(SIGINT,SIG_IGN)) != SIG_IGN)
	signal(SIGINT,&done);

if ((signal(SIGQUIT,SIG_IGN)) != SIG_IGN)
	signal(SIGQUIT,&done);

if ((signal(SIGPIPE,SIG_IGN)) != SIG_IGN)
	signal(SIGPIPE,&done);

if (lockfile[0])
	{
	TRACEF(("locking %s\n",lockfile));
	while ((i = creat(lockfile,0)) < 0)
		{
		if (wflg)
			{
			if ((wcnt % WCOUNT) == 0)
				fprintf(stderr,"mwlpr: %swaiting for %s\n",
					wcnt ? "still ": "", ttyname);
			sleep(WDELAY);
			++wcnt;
			}
		else
			err("tty already in use %s",ttyname);
		}
	++locked;	/* we locked it */
	close(i);
	}
TRACEF(("opening %s\n",ttyname));
if (ttyname[0] == 0 || ttyname[0] == '-')
	ttyf = fdopen(dup(1),"w");
else if ((ttyf = fopen(ttyname,"w")) == NULL)
	err("can't open tty %s",ttyname);

gtty(fileno(ttyf),oldv);
if (speed == 0)
	move(sizeof v, oldv,v);
else
	{
	v[0] = speed * 256 + speed;
	v[1] = 0;
	}
v[2] = flags;
stty(fileno(ttyf),v);
fputs(initstr,ttyf);		/* send init string */
fflush(ttyf);
}

dofile()
{
register int c;

while ((c = getchar()) != EOF)
	{
	TTRACEF((" <%o",c));
	switch(c)
		{
	case '\n':
		++lines;
		if (!(maxlines && lines >= maxlines))
			break;
		TTRACEF((" >%o",c));
		putc(c,ttyf);
		c = OUT_FF;
	case FF:
	case OUT_FF:
		if (lines == 0)
			continue;
		lines = 0;
		c = OUT_FF;
		break;
		}
	if (c)
		{
		TTRACEF((" >%o",c));
		putc(c,ttyf);
		lastc = c;
		}
	}
page();
}

page()
{
TRACEF(("page: lines=%d lastc=%o\n",lines,lastc));
if (lines != 0 && lastc)
	{
	lines = 0;
	lastc = OUT_FF;
	TTRACEF((" >%o",lastc));
	putc(OUT_FF,ttyf);
	}
}

doswitch(argp) char *argp;
{
switch(*argp++)
	{
case 'w':
	++wflg;
	break;
case 'L':
	copy(lockfile,argp);
	TRACEF(("lockfile=%s",lockfile));
	break;
case 'l':
	copy(ttyname,argp);
	TRACEF(("tty=%s",ttyname));
	break;
case 's':
	speed = cvtspeed(atoi(argp));
	break;
case 'n':
	maxlines = atoi(argp);
	TRACEF(("maxlines=%d\n",maxlines));
	break;
case 'i':
	initstr = save(argp);
	TRACEF(("initstr = '%s'",initstr));
	break;
case 'e':
	endstr = save(argp);
	TRACEF(("endstr = '%s'",endstr));
	break;
case 'd':
	++debug;
	break;
default:
	err("invalid switch %s",argp-1);
	}
}

cvtspeed(n)
{
switch(n)
	{
case 0:	n = 0;	break;
case 110: n = B110; break;
case 150: n = B150; break;
case 200: n = B200; break;
case 300: n = B300; break;
case 600: n = B600; break;
case 1200: n = B1200; break;
case 2400: n = B2400; break;
case 4800: n = B4800; break;
case 9600: n = B9600; break;
default:
	err("invalid speed %d",n);
	}
return(n);
}

done(n)
{
if (ttyf != (FILE *) NULL)
	{
	page();
	fputs(endstr,ttyf);		/* terminate output */
	fflush(ttyf);
	stty(fileno(ttyf),oldv);
	fclose(ttyf);
	ttyf = (FILE *) NULL;
	}
if (locked)
	{
	unlink(lockfile);
	TRACEF(("unlink %s\n",lockfile));
	locked = 0;
	}
exit(n);
}

