#

#include "/usr/include/signal.h"

#define	TIOCLPUT	(('l'<<8)|4)
#define	DELAY	10

#define	XON	'Q'&037
#define	XOFF	'S'&037
#define	STOPWRITE	023	/* control-s */
#define	STOPBWRITE	024	/* control-t */
#define	RESET	032	/* control-z  resets techtran */
#define	ECHO	010	/* echo characters */
#define	ESCAPE		033	/* escape */
#define	RAW	040
#define	RARE	01
#define	ANYP	0300
#define	MAXCOL	72
#define	MAXDIR	200
#define	MAXSPACE	(MAXDIR*7)

int arg[3];
char space[MAXSPACE];
char *dir[MAXDIR];
char *spacep &space;
char *strp;
char **dirp &dir;
int dircnt;
int status, pid;
int oldv[3], newv[3];
int done();
int inbuff[518/2];
int cnt;
int outbuff[518/2];
int bflg;		/* binary mode */
int cflg 1;		/* output cr's , ignore cr on input */
int mflg;		/* map cr into nl */
int nflg;		/* no echo mode */
int qflg;		/* use control-q to read next file */
int rflg;		/* read floppy */
int hflg;		/* use rare mode */
int wflg;		/* write floppy */
int debug 0;		/* debug mode */
int outdup;		/* dup(1) */
char ttfile[32];
extern fout;
int clock();
int ccount;

main(argc,argv) char **argv;
{
register int c;
register int i;

++argv;
--argc;
outdup = dup(1);
signal(SIGHUP,&done);
signal(SIGINT,&done);
signal(SIGALRM,&clock);
signal(SIGQUIT,1);
while (argc > 0)
	{
	if (**argv == '-')
		{
		switch(argv[0][1])
			{
		case 'q':
			++qflg;		/* use control-q to read file */
			break;
		case 'm':	/* map cr into nl on input */
			++mflg;
			break;
		case 'h':	/* rare mode */
			++hflg;
			break;
		case 'n':	/* no echo */
			++nflg;
			break;
		case 'd':	/* disk directory */
			getdir();
			prdir();
			break;
		case 'e':	/* erase the disk */
			gtty(0,oldv);
			move(6,oldv,newv);
			newv[2] = RAW;	/* put into raw mode */
			stty(0,newv);
			cmdf(".d d\r");
			sleep(1);
			cmdchar(ESCAPE);
			stty(0,oldv);
			sleep(1);
			printf("\n");
			break;
		case 'w':
			++wflg;
			break;
		case 'r':
			++rflg;
			break;
		case 'b':
			++bflg;
			break;
		case 'c':		/* output cr's */
			cflg = !cflg;
			break;
		case 't':		/* tape file name */
			++argv;
			--argc;
			copy(ttfile,*argv);
			break;
		case 'x':
			++debug;
			break;
		default:
			err("bad option:'%s'", *argv);
			}
		}
	else
		{
		if (wflg && rflg)
			err("bad usage");
		if (wflg==0 && rflg==0)
			++wflg;
		if (rflg)
			{
			if (any(*argv,"*[?"))
				{
				getdir();
				for (i=0; i<dircnt; ++i)
					if (match(dir[i],*argv))
						ttread(dir[i]);
				}
			else
				ttread(*argv);
			}
		if (wflg)
			ttwrite(*argv);
		}
	--argc;
	++argv;
	}
}

ttwrite(file) char *file;
{
register int c;

if (fopen(file,&inbuff) < 0)
	err("can't open %s",file);
gtty(0,oldv);
move(6,oldv,newv);
newv[2] = 0;	/* output normally */
cmdchar(STOPWRITE);	/* terminate and pending write */
sleep(1);
if (ttfile[0] == 0)
	cvtname(file,ttfile);
printf("\n");
cmdf(".w %s\n",ttfile);
sleep(1);
stty(0,newv);
fout = outdup;
cnt = 0;
while ((c = getc(&inbuff)) >= 0)
	{
	if (bflg)
		{
		puthex(c>>4);
		puthex(c);
		if (++cnt >= MAXCOL/2)
			{
			putnl();
			}
		}
	else
		{
		if (c == '\n' && cflg)
			cmdchar('\r');
		cmdchar(c);
		}
	}
if (cnt)
	putnl();
flush();
fout = 1;
flush();
newv[2] = RAW;		/* raw mode for eot character */
stty(0,newv);		/* output in raw mode */
cmdchar(04);	/* terminate read */
cmdchar(04);	/* terminate read */
cmdchar(STOPWRITE);	/* terminate write */
flush();
stty(0,oldv);
close(inbuff[0]);
sleep(2);
ttfile[0] = 0;
}

puthex(c) char c;
{
c =& 017;
if (c > 9)
	c =+ 'A'-10;
else
	c =+ '0';
cmdchar(c);
}

cvtname(file,outfile) char *file, *outfile;
{
register char *f, *o;
register int c;

f = file; o = outfile;
while (c = *f++)
	{
	if (c != '.')
		*o++ = c;
	else
		*o++ = '_';
	if (c == '/')
		o = outfile;
	}
*o++ = 0;
outfile[5] = 0;
}

putnl()
{
cnt = 0;
if (cflg)
	cmdchar('\r');
cmdchar('\n');
}

ttread(file) char *file;
{
register int c;

if (fcreat(file,&outbuff) < 0)
	err("can't open %s",file);
gtty(0,oldv);
move(6,oldv,newv);
if (hflg)
	newv[2] =| RARE;
else
	newv[2] = 0;
if (nflg)
	newv[2] =& ~ECHO;
else
	newv[2] =| ECHO;
if (qflg)
	{
	stty(0,newv);
	cmdchar('Q'&037);
	}
else
	{
	cmdchar(STOPBWRITE);	/* terminate and pending write */
	cmdchar(RESET);		/* terminate any pending read */
	sleep(1);
	if (ttfile[0] == 0)
		cvtname(file,ttfile);
	printf("\n");
	stty(0,newv);
	cmdf(".r %s\r\n",ttfile);
	}
cnt = 0;
fout = 1;
if (bflg)
	bincopy();
else
	incopy();
/* cmdchar(RESET);		/* no more input */
xon();
alarm(0);			/* reset it */
flush();
fflush(&outbuff);
stty(0,oldv);
sleep(2);
close(outbuff[0]);
ttfile[0] = 0;
xon();
}

incopy()
{
register int c;

alarm(60);
while ((c = getchar()) > 0)
	{
	c =& 0177;
	if ( debug ) printf("'%o' ", c);
	if (c == '\r')
		{
		if (mflg)
			c = '\n';	/* map into newline */
		else if(cflg)
			continue;
		}
	if (c == 04)
		break;
	else
		putc(c,&outbuff);
	if (c == '\n')
		{
		alarm(DELAY);		/* set time out delay */
		if (nflg)
			cmdchar('*');
		}
	}
if ( debug ) printf("'%o' \n", c);
}

bincopy()
{
register int c1, c2;

for (;;)
	{
	if ((c1 = nibble()) < 0)
		return;
	if ((c2 = nibble()) < 0)
		return;
	putc((c1<<4)+c2,&outbuff);
	}
}

nibble()
{
register int c;

do
	{
	c = getchar()&0177;
	}
while (c == '\n' || c == '\r');
if (c == 04 || c <= 0)
	return(-1);
if (c >= '0' && c <= '9')
	return(c-'0');
if (c >= 'a' && c <= 'f')
	return(c-'a'+10);
if (c >= 'A' && c <= 'f')
	return(c-'A'+10);
err("bad nibble %c",c);
}

err(msg,d1) char *msg;
{
flush();
fout = 1;
flush();
printf(msg,d1);
printf(" - ");
perror("");
done();
}

done()
{
if (oldv[2])
	stty(0,oldv);
cmdchar(STOPWRITE);	/* terminate output if any */
/* cmdchar(RESET);	/* and reset */
exit(1);
}

ttmode(mode)
{
gtty(0,oldv);
move(6,oldv,newv);
newv[2] = mode;
stty(0,newv);
}

getdir()
{
register int c;

if (dircnt)
	return;
strp = 0;
ttmode(RAW|ECHO);	/* so we don't issue XOFF */
cmdf(".d r\r\n");	/* ask for it */
while ((c = getchar()&0177) > 0)
	putdir(c);
putdir(' ');
sleep(1);
stty(0,oldv);
}

putdir(c)
{
switch(c)
	{
case '\r':
case '\n':
case ' ':
	if (strp)
		{
		*strp++ = 0;
		spacep = strp+1;
		if (spacep >= space+MAXSPACE)
			err("out of directory space");
		strp = 0;
		}
	break;
default:
	if (strp == 0)
		{
		strp = spacep;
		*dirp++ = strp;
		if (++dircnt >= MAXDIR)
			err("more than %d directory entries",MAXDIR);
		}
	*strp++ = c;
	}
}

prdir()
{
register int i;
for (i=0; i<dircnt; )
	{
	printf("%s",dir[i]);
	++i;
	if (i&07)
		putchar('\t');
	else
		putchar('\n');
	}
putchar('\n');
}

cmdf(fmt,d1,d2,d3)
char *fmt;
{
extern fout;
register int save;

flush();
save = fout;
fout = 2;
printf(fmt,d1,d2,d3);
flush();
fout = save;
}

cmdchar(c)
{
cmdf("%c",c);
}

clock()
{
xon();
printf("\r\nNo input for %d seconds - file assumed complete\r\n",DELAY);
++ccount;		/* count it for fun */
xon();
}

xon()
{
arg[0] = XON;			/* turn on input again */
ioctl(0,TIOCLPUT,arg);
}
