#
#include <stdio.h>
#

/*
 * Note: this routine uses the "stty" entry into the tape driver
 * in order to rewind the tape. If your tape driver does not have
 * this feature set "pflg" to 1. This causes ts to work from its
 * current position rather than attempting to rewind the tape first.
 * TS also expects "normal" behaviour out of the tape driver, namely
 * (1) deliver 0 on EOF
 * (2) deliver -1 on error (e.g. I/O errors)
 * this may be too much to expect from many tape drivers.
 * Note that ts can be a bit of a dog (e.g. tie up the system).
 * this isn't ts's fault .. its the tape driver. 
 * that's why there is a "setpri()" in the UBC tm.c
 * Bill Webb UBC.
 */

#define	DIGIT(c) '0' <= (c) && (c) <= '7'
#define	SIGATTN	2

#define	WTM	0
#define	FSF	1
#define	BSF	2
#define	FSR	3
#define	BSR	4
#define	REW	5
#define	OFF	6

#define	NONE	0

#define	OS	1
#define	ANSI	2
#define	DOS	3
#define	FS	4
#define	FSMAGIC	0123456
#define	FSDIRLEN	80		/* length of fs header record */

#define	IRG	0.5	/* inches */
#define	TM	1.0

struct { int integ; };

float density 1600.0;	/* default density */
int status;
int label = NONE;
int prfile;		/* 0 == file info not yet printed */
int skiptm;		/* skip tape marks */
char buff[32766];
int tapeerr;		/* if caused by tape error */
char filename[64];
char date[20];
int tape, rec, cnt, file, eof;
int maxeof 2;
int maxlen;
int minlen;
double size;
double tsize;
double avg;
double feet;
double tfeet;
char *tapename "/dev/rmt0";
int tflg, vflg, xflg;
int aflg;
int pflg;
int iflg;
int qflg;
int wflg;
int nflg;
int Nflg;		/* use numeric labels */
int Eflg;		/* translate to ascii */
int rtflg;		/* if rt-11 funny ansi labels */
int lflg;
int out;

int flag;
int finish();
int reread;		/* to read header again */
char temp[5];		/* temp string location */
char *recsep;		/* output record separator */

main(argc,argv) char **argv;
{
register int l;
register int c;
int k;
int targc;
char **targv;
register char *argp;

--argc;
++argv;
while (argc > 0 && *(argp = *argv) == '-')
	{
	--argc;
	++argv;
	++argp;
	while (*argp)
		{
		switch(c = *argp++)
			{
		case 'L':
			if (isdigit(*argp))
				label = *argp++ - '0';
			break;
		case 'a':		/* ascii output (remove CR's) */
			++aflg;
			break;
		case 'd':
			density = density == 800.0 ? 1600.0 : 800.0;
			break;
		case 'f':
			tapename = *argv++;
			--argc;
			break;
		case 'q':
			++qflg;
			break;
		case 'w':
			++wflg;
			break;
		case 'l':		/* lengths requested */
			++lflg;
			break;
		case 'e':
			maxeof = *argp++-'0';
			if (maxeof < 0 || maxeof > 10)
				err("bad eof cnt");
			break;
		case 'x':
			++xflg;
			break;
		case 'r':
			++rtflg;
			break;
		case 't':
			++tflg;
			break;
		case 'v':
			++vflg;
			break;
		case 'E':		/* ebc asc translate */
			++Eflg;
			break;
		case 'R':
			recsep = *argv++;
			--argc;
			break;
		case 'N':		/* use numeric labels */
			++Nflg;
			break;
		case 'n':		/* not labelled */
			++nflg;
			break;
		case 'p':
			++pflg;
			break;		/* use position commands not rewind */
		case 'i':
			++iflg;		/* ignore tape read errors */
			break;
		default:
			if (DIGIT(c))
				tapename[8] = c;
			else
				err("bad option %s",argp-1);
			break;
			}
		}
	}
if (!xflg)
	++tflg;
tape = open(tapename,0);
if (tape < 0)
	err("can't open %s",tapename);
if (!pflg)
	tcon(REW,0);
if (!nflg)
	{
	l=tpread(tape,buff,sizeof buff);
	if (l >= 0)
		reread = l;		/* read the vol header again */
	if (l == FSDIRLEN && buff->integ == FSMAGIC)
		label = FS;
	else if (l == 80 || l==514 || rtflg)
		{
		move(4,buff,temp);
		if (equal(temp,"VOL1"))
			{
			skiptm = 1;
			label = ANSI;
			if (l == 514)
				++rtflg;
			}
		else
			{
			ebcasc(4,buff,filename);
			if (equal(filename,"VOL1"))
				{
				skiptm = 1;
				label = OS;
				}
			}
		}
	else if (l == 14)
		label = DOS;
	else if (l < 0)
		{
		++tapeerr;
		err("reading volume header");
		}
	}
eof = 0;
setout();
if (skiptm)
	lread("VOL1");
if (tflg)
	{
	printf("%.0f BPI ",density);
	switch(label)
		{
	case OS:
		printf("OS volume label = %.6s",buff+4);
		printf(" owner = %.10s\n",buff+41);
		title(1);
		break;
	case ANSI:
		if (rtflg)
			printf("funny RT-11 ");
		printf("ANSI volume label = %.20s\n",buff+4);
		title(1);
		break;
	case FS:
		printf("UNIX FS directory = %s\n",buff+22);
		title(1);
		break;
	case DOS:
		printf("PDP 11 DOS tape\n");
		title(1);
		break;
	default:
		printf("unlabelled tape\n");
		title(0);
		break;
		}
	}
flush();
if ((signal(SIGATTN,1)&1) == 0)
	signal(SIGATTN,&finish);
for (file=1; eof < maxeof; ++file)
	{
	rec=0; size = 0;
	maxlen = 0;
	minlen = 32767;
	if (!lread("HDR1") && !qflg)
		break;
	if (!Nflg)
	switch(label)
		{
	case FS:
		if (!fslabel())
			goto badlab;
		move(58,buff+4,filename);
		break;
	case DOS:
		if (!doslabel())
			{
		badlab:
			if (!qflg)
				goto done;
			else
				{
				++eof;
				continue;
				}
			}
		cvtname(16,buff+4,filename);
		break;
	case ANSI:
		cvtname(16,buff+4,filename);
		break;
	case OS:
		move(6,buff+41,date);
		cvtname(17,buff+4,filename);
		break;
	default:
		sprintf(filename,"file%d",file);
		}
	else
		sprintf(filename,"file%d",file);
	geteof();
	out = 0;
	flag = select(argc,argv);
	if (flag && xflg && wanted())
		{
		if (filename[0] == '!')
			out = pipeout("/bin/sh","sh","-c",filename+1,0);
		else
			out = creat(filename,0666);
		if (out < 0)
			err("can't create %s",filename);
		}
	while ((l=tpread(tape,buff,sizeof buff)) > 0)
		{
		if (out)
			{
			if (Eflg)
				ebcasc(l,buff,buff);
			if (aflg)
				ascwrite(out,buff,l);
			else {
				if (recsep)
					{
					move(k = length(recsep),recsep,buff+l);
					l += k;
					}
				if (write(out,buff,l) < 0)
					err("write error on %s",filename);
				}
			}
		eof=0;
		if (l > maxlen)
			maxlen = l;
		if (l < minlen)
			minlen = l;
		++rec;
		size =+ l;
		if (lflg)
			{
			printf("%d",l);
			if (rec&07)
				printf("\t");
			else
				{
				printf("\n");
				flush();
				}
			}
		}
	if (l < 0)
		{
		filestats();
		++tapeerr;
		err("tape read");
		}
	if (lflg)
		printf("\n");
	if (out)
		{
		close(out);
		if (filename[0] == '!')
			while (wait(&status) != -1)
				;
		if (vflg)
			{
			printf("x %s\n",filename);
			flush();
			}
		}
	filestats();
	++eof;
	lread("EOF1");
	geteof();
	}
done:
finish();
}

finish()
{
if (rec)		/* non-zero if entered due to error or interrupt */
	{
	++file;
	if ((rec&07) && lflg)
		printf("\n");
	filestats();
	}
tstats();
flush();
exit(0);
}

lread(strptr) char *strptr;
{
/*
 * read a label from the tape.
 * skip a tape mark if "skiptm" set.
 */
register int l;
register char *p;
register char *str;

prfile = 0;			/* not printed yet */
str = strptr;
if (!skiptm)
	return(1);
if ((l=tpread(tape,buff,sizeof buff)) < 0)
	err("tape read error");
if (l == 0)
	return(0);
if (l!=80 && l!=514 && !rtflg)
	err("label missing");
if (label == OS)
	ebcasc(l,buff,buff);		/* translate to ascii */
for (p=buff; *str; )
	if (*p++ != *str++)
		{
		err("expecting %s label; got %s",strptr,buff);
		break;
		}
return(1);
}

geteof()
{
if (!skiptm)
	return;
while ((tpread(tape,buff,sizeof buff)) > 0)
	;
feet =+ TM;
}

err(fmt,d1,d2,d3) char *fmt;
{
extern errno;

flush();
fprintf(stderr,"ts: ");
fprintf(stderr,fmt,d1,d2,d3);
fprintf(stderr," ");
if (errno)
	perror("");
else
	fprintf(stderr,"\n");
if (!iflg)
	tstats();
if (tapeerr)
	tapestatus(tape);
flush();
if (!iflg)
	exit(1);
tapeerr = 0;
}

cvtname(length,ins,outs) char *ins, *outs;
{
register int l;
register int c;

for (l=length; l > 0; --l)
	{
	c = *ins++;
	if (c == ' ')
		continue;
	if (c >= 'A' && c <= 'Z')
		c =- 'A'-'a';
	*outs++ = c;
	}
*outs = 0;
}

select(argc,argv) char **argv;
{
register int i;

if (argc <= 0)
	return(1);
for (i=0; i<argc; ++i)
	if (match(filename,argv[i]))
		return(1);
return(0);
}

ebcasc(len,in,outs) char *in, *outs;
{
extern char etoa[];
register int l;

for (l=len; l>0; --l)
	*outs++ = etoa[*in++ & 0377];
}

tcon(fn,n)
{
int info[3];

info[0] = fn;
info[1] = n;
info[2] = 0;
if (stty(tape,info) < 0)
	err("bad return from stty");
}

title(flg)
{
printf("file	");
if (flg)
	printf("name		");
printf("records	  avg	max len	min len	tp length\n");
printf(" #	");
if (flg)
	printf("		");
printf("	(bytes)	(bytes) (bytes) (feet)\n\n");
}

fslabel()
{
register int l;
register int *p;

p = buff;
if ((l=tpread(tape,buff,sizeof buff)) == 0)
	return(0);
if (l != FSDIRLEN || *p != FSMAGIC)
	err("invalid unix fs file label");
}

doslabel()
{
register int l;
register int *p;
char temp[12];

clear(temp,sizeof temp);
p = buff;
if ((l=tpread(tape,buff,sizeof buff)) == 0)
	return(0);
if (l != 14)
	err("invalid dos file label");
rad50(*p++,temp);
rad50(*p++,temp+3);
temp[6]='.';
rad50(*p++,temp+7);
move(11,temp,buff+4);
}

filestats()
{
register int i;

if (prfile++)
	return;
tsize =+ size;
feet = (TM + rec*IRG + size/density)/12.0;
tfeet =+ feet;
if (rec > 0)
	avg = size/rec;
else
	avg = 0.0;
if (flag && tflg)
	{
	printf("%5d	",file);
	if (label)
		{
		printf("%-13s ",filename);
		}
	if (minlen == 32767)
		minlen = 0;
	printf("%5d	%7.0f	%5d	%5d	%7.2f",
		rec,avg,maxlen,minlen,feet);
	printf(" %s",date);
	i = differrs();
	if (i > rec/50)
		printf(" %5d",i);	/* print if more than 2 percent */
	printf("\n");
	flush();
	}
rec = 0;
}

tstats()
{
if (file  && tflg)
	{
	printf("\ntotals: %d files %.0f bytes %.1f feet",
		file-1,tsize,tfeet);
	perrcnt();
	printf("\n");
	}
}

wanted()
{
register int l;

if (!wflg)
	return(1);
printf("x %s?",filename);
flush();
if ((l = read(0,buff,80)) <= 0)
	exit(0);
buff[--l] = 0;
if (equal(buff,"y"))
	return(1);
if (l == 0 || equal(buff,"n"))
	return(0);
copy(filename,buff);
return(1);
}

char *tmerrs[]
{ "ready", "rewinding", "write-lock", "settling", "7-track",
"bot", "on-line", "no-memory", "bad-tape", "length-error",
"end-of-tape", "grant-late", "parity-error", "CRC-error",
"EOF-detected", "illegal-command" };

tapestatus(fil)
{
	int arg[3];
	register int i;

	arg[0] = arg[1] = arg[2] = 0;
	gtty(fil,arg);
/*
	if (arg[1])
		printf("residual=%d\n");
 */
	if (arg[0] == 0)
		return;
	printf(" tmerr=%o ",arg[0]);
	for (i=0; i<16; ++i)
		if (arg[0] & (1<<i))
			printf(" %s",tmerrs[i]);
	if (arg[2])
		printf(" errcnt=%d",arg[2]);
	printf("\n");
}

ascwrite(des,b,len) char *b;
{
register int l;
register char *p, *q;

p = q = b;
l = len;
do
	if ((*p = *q++) != 0 && *p != '\r')
		++p;
while (--l);
l = p-b;
if (l)
	if (write(des,b,l) < 0)
		err("write error");
}

differrs()
{
/*
 * return the soft error count for this file by taking the 
 * difference between the current count the and previous one.
 */
	int arg[3];
	register int i,j;
	static basecnt;			/* starting error count */

	arg[0] = arg[1] = arg[2] = 0;
	if (gtty(tape,arg) < 0)
		return(0);
	i = arg[2]-basecnt;
	basecnt = arg[2];
	return(i);
}

perrcnt()
{
	int arg[3];

	arg[0] = arg[1] = arg[2] = 0;
	if (gtty(tape,arg) < 0)
		return;
	if (arg[2])
		printf(" errcnt=%d",arg[2]);
}

tpread(des,buffer,length) char *buffer;
{
/*
 * tape read function.
 * sole purpose is to arrange that we can remember a record
 * by setting the "reread" flag.
 * this saves having to rewind the tape after reading the 
 * (supposed) volume label.
 */
register int l;

if (reread)
	l = reread;
else
	l = read(des,buffer,length);
reread = 0;
return(l);
}

char	etoa[]
{
	0000,0001,0002,0003,0234,0011,0206,0177,
	0227,0215,0216,0013,0014,0015,0016,0017,
	0020,0021,0022,0023,0235,0205,0010,0207,
	0030,0031,0222,0217,0034,0035,0036,0037,
	0200,0201,0202,0203,0204,0012,0027,0033,
	0210,0211,0212,0213,0214,0005,0006,0007,
	0220,0221,0026,0223,0224,0225,0226,0004,
	0230,0231,0232,0233,0024,0025,0236,0032,
	0040,0240,0241,0242,0243,0244,0245,0246,
	0247,0250,0133,0056,0074,0050,0053,0041,
	0046,0251,0252,0253,0254,0255,0256,0257,
	0260,0261,0135,0044,0052,0051,0073,0136,
	0055,0057,0262,0263,0264,0265,0266,0267,
	0270,0271,0174,0054,0045,0137,0076,0077,
	0272,0273,0274,0275,0276,0277,0300,0301,
	0302,0140,0072,0043,0100,0047,0075,0042,
	0303,0141,0142,0143,0144,0145,0146,0147,
	0150,0151,0304,0305,0306,0307,0310,0311,
	0312,0152,0153,0154,0155,0156,0157,0160,
	0161,0162,0313,0314,0315,0316,0317,0320,
	0321,0176,0163,0164,0165,0166,0167,0170,
	0171,0172,0322,0323,0324,0325,0326,0327,
	0330,0331,0332,0333,0334,0335,0336,0337,
	0340,0341,0342,0343,0344,0345,0346,0347,
	0173,0101,0102,0103,0104,0105,0106,0107,
	0110,0111,0350,0351,0352,0353,0354,0355,
	0175,0112,0113,0114,0115,0116,0117,0120,
	0121,0122,0356,0357,0360,0361,0362,0363,
	0134,0237,0123,0124,0125,0126,0127,0130,
	0131,0132,0364,0365,0366,0367,0370,0371,
	0060,0061,0062,0063,0064,0065,0066,0067,
	0070,0071,0372,0373,0374,0375,0376,0377,
};
