#include <stdio.h>

/*
 * read kernal memory to find the relevent words containing
 * the tape error counts
 * this will only work with the UBC mt driver; you would be advised 
 * not to run it on any other system.
 */
int cnt;
int kmem;
char *addr;
int values[10];
struct nlist {
char name[8];
int type;
int value;
} nl[10];
char *names[] {
"_t_errcnt",
"_t_nxrec",
"_t_blkno", 0};

main(argc,argv) char **argv;
{
register char *p;
register int i;

if ((kmem = open("/dev/kmem",0)) < 0)
	err("no /dev/kmem");
for (i=0; p = names[i];++i)
	strncpy(nl[i].name,p,8);
getnlist("/etc/tperr.symtab","/unix",nl,sizeof nl);
for (i=0; names[i]; ++i)
	{
	addr = nl[i].value;
	if (addr == 0)
		err("no %.8s",nl[i].name);
	seek(kmem,addr,0);
	read(kmem,values+i,2);
	}
if (argc <= 1 || values[0])
	{
	setout();
	printf("%s: errcnt=%d record=%d\n",argv[0],values[0],values[1]);
	}
exit(values[0] != 0);
}

getnlist(symfile,file,nl,size) struct nlist *nl;
{
register int i;
long modtime();
long sdate = modtime(symfile),
	fdate = modtime(file);
if (sdate >= fdate && (i = open(symfile,0)) >= 0)
	{	/* if symfile exists and is current use it */
	read(i,nl,size);
	close(i);
	return;
	}
nlist(file,nl);
if ((i = creat(symfile,0666)) > 0)
	{
	write(i,nl,size);
	close(i);
	}
}

