#include <stdio.h>

#include <tape.h>

#define	tracef	if (tflg) printf
char *dirfile "tape_dir";
char *datafile "tape_data";
#define	MAXREC	32766
char tapebuff[MAXREC];
FILE *dir;
FILE *data;
char *tapefile "/dev/rmt0";	/* the raw tape */
FILE *tape;			/* tape file */
int tperr;			/* count tape read errors */
int tflg;
int iflg;
int oflg;
int filecnt = 32767;

main(argc,argv) char **argv;
{
register int i;
char *argp;

for (i=1; i<argc; ++i)
	{
	argp = argv[i];
	if (*argp == '-')
		{
		switch(argp[1])
			{
		case 'T':
			++tflg;		/* trace (debug) info */
			break;
		case 'i':		/* input from tape */
			++iflg;
			break;
		case 'o':		/* output to tape */
			++oflg;
			break;
		case 'n':		/* limit to n files */
			filecnt = cvtint(&argp);
			break;
		case 'd':		/* directory file */
			dirfile = argv[++i];
			break;
		case 'f':		/* data file */
			datafile = argv[++i];
			break;
		case 't':		/* tape file (/dev/rmt?) */
			tapefile = argv[++i];
			break;
		default:
			err("invalid switch %s",argp);
			}
		}
	else
		tapefile = argp;
	}

if (iflg+oflg != 1)
	err("exactly one of -i and -o may be specified");
if (iflg)
	{
	tape = myopen(tapefile,"r");
	dir = myopen(dirfile,"w");
	data = myopen(datafile,"w");
	tapein(filecnt);
	}
if (oflg)
	{
	tape = myopen(tapefile,"w");
	dir = myopen(dirfile,"r");
	data = myopen(datafile,"r");
	tapeout(filecnt);
	}
}

tapein(filecnt)
{
/*
 * copy an entire tape to the output file.
 */
register int n;
register int file;

for (file=0; (n = intpfile()) && ++file < filecnt; )
	fprintf(dir,"0\n");
return(file);
}

intpfile()
{
/*
 * copy a file from a tape to the output file.
 */
register int l;
register int n;

for (n=0; (l = read(fileno(tape),tapebuff,sizeof tapebuff)) > 0; ++n)
	{
	fprintf(dir,"%d\n",l);
	if (data)
		write(fileno(data),tapebuff,l);
	}
if (l < 0)
	++tperr;
return(n);
}

tapeout(cnt)
{
/*
 * copy "cnt" files onto the tape.
 */
char *ptr;
register int n;
char line[80];

while (fgets(line,sizeof line,dir))
	{
	ptr = line;
	n = cvtint(&ptr);
	if (*ptr != '\n')
		err("bad directory line %s",line);
	if (n)
		{
		tracef("write %d bytes\n",n);
		if (read(fileno(data),tapebuff,n) != n)
			err("bad data file");
		write(fileno(tape),tapebuff,n);
		}
	else
		{
		tracef("write tm\n");
		wtm(1);
		if (--cnt <= 0)
			break;
		}
	}
wtm(3);
}

cvtint(ptr) char **ptr;
{
register char *p = *ptr;
register int n;

for (n=0; isdigit(*p); )
	n = n * 10 + *p++ - '0';
*ptr = p;
return(n);
}

FILE *myopen(file,how) char *file, *how;
{
register FILE *f;

if (strcmp(file,"-") == 0)
	{
	if (*how == 'r')
		f = fdopen(0,how);
	else
		f = fdopen(1,how);
	}
else if ((f = fopen(file,how)) == NULL)
	err("can't open %s",file);
return(f);
}

wtm(n)
{
int arg[3];

arg[TAPE_FN] = WTM;
arg[TAPE_CNT] = n;
arg[2] = 0;
if (stty(fileno(tape),arg) < 0)
	{
	printf("wtm failed\n");
	tapestatus(fileno(tape));
	err("fatal control error");
	}
}

tapestatus(fil)
{
	static char *tmerrs[]
		{ "ready", "rewinding", "write-lock", "settling", "7-track",
		"bot", "on-line", "no-memory", "bad-tape", "length-error",
		"end-of-tape", "grant-late", "parity-error", "CRC-error",
		"EOF-detected", "illegal-command" };
	int arg[3];
	register int i;

	gtty(fil,arg);
	if (arg[1])
		printf("residual=%d\n");
	if (arg[0] == 0)
		return;
	printf(" tmerr=%o ",arg[0]);
	for (i=0; i<16; ++i)
		if (arg[0] & (1<<i))
			printf(" %s",tmerrs[i]);
	printf("\n");
}
