#
#include <stdio.h>

#define	T_NEW	1
#define	T_EMPTY	2
#define	T_FILE	4
#define	T_END	010

#define	ALLDIR	d = dir+5; d->d_type != T_END; d =+ dir->h_extra/2 + 7

struct hdr
{
int h_segments;
int h_next;
int h_last;
int h_extra;
int h_block;
};

struct dir
{
char d_status;
char d_type;
int d_name[2];
int d_ext;
int d_length;
char d_chan;
char d_job;
int d_date;
};

int dir[512];
#define	maxarg	256
char used[maxarg];
int addr;			/* current file address */
int lastdir;
int in, out;
int freecnt;
#define	DIRBLK	6
#define	dirlen	1024
int eflg;			/* ignore errors */
int aflg;			/* ascii file - strip CR and NUL */
int dflg;
int iflg;
int sflg;
int tflg;
int errflg;
int zflg;
int oflg;
int vflg;

char *tapename "/dev/tap0";
int rflg;

int tape;
int buff[256];
char filename[16];
char *pgname;
char **argv;
int argc;

int restore();
int delete();
char date[20];

main(argcx,argvx)
char *argvx[];
{
register int i;
register int c;
register char *argp;

argc = argcx;
argv = argvx;


pgname = *argv++;
--argc;
if(argc>0 && *(argp = *argv) == '-')
	{
	++argv;
	--argc;
	++argp;
	while (*argp)
		{
		switch(c = *argp++)
			{
		case 'a':
			++aflg;		/* remove non-ascii chars */
			break;
		case 'e':
			++eflg;
			break;
		case 't':
			++tflg;
			break;

		case	'd':
			++dflg;
			break;

		case 'f':
			--argc;
			tapename = *argv++;
			break;
		case 'r':
		case 'x':
			++rflg;
			break;

		case 'z':
			++zflg;
			break;

		case	'v':
			++vflg;
			break;

		case	'o':		/* output to standard output */
			++oflg;
			break;

		case	's':
			++sflg;
			break;

		case	'i':
			++iflg;
			break;

		default:

			if(c>='0' && c<='7')
				{
				tapename[8] = c;
				break;
				}
			err("invalid switch %c",c);
			}
		}
	}

if(dflg + sflg + rflg > 1)
	err("conflicting options specified");


tape = open(tapename,2);
if(tape<0)
	{
	printf("%s: %s -",pgname,tapename);
	perror();
	}

go();
}

go()
{
register int *d;
register int sum;
register int seg;


sum = 0;

seg = 1;
do
	{
	seek(tape,DIRBLK+(seg-1)*2,3);
	if(read(tape,dir,dirlen) != dirlen)
		err("tape read error");
	for (ALLDIR)
		{
		switch(d->d_type)
			{
		case T_FILE:
			++lastdir;
			sum =+ d->d_length;
			break;
		case T_NEW:
		case T_EMPTY:
			freecnt =+ d->d_length;
			break;
		default:
			err("not rt-11 tape - type=%d",d->d_type);
			}
		}
	if(tflg)
		{
		if (vflg)
			printf("total # of files = %d\n",lastdir);
	
		addr = dir->h_block;
		for (ALLDIR)
			{
			if(vflg || d->d_type == T_FILE)
				prdir(d);
			addr =+ d->d_length;
			}
		if (vflg)
			printf("total blocks used %d\n",sum);
		}
	
	if(rflg)
		rdcmd(&restore);
	if(dflg)
		rdcmd(&delete);
	if(sflg)
		savecmd();
	if(errflg)
		exit(1);
	seg = dir->h_next;
	}
while (seg);
}

restore(d,file) struct dir *d; char *file;
{
register int block;
int l;
int output;
register int length;
register int i;

if(oflg)
	output = dup(1);
else
	if((output=creat(file,0664))<0)
		err("can't creat");

length = d->d_length;
block = addr;
seek(tape,block,3);
for (i=0; i<length; ++i)
	{
	l=read(tape,buff,512);
	if(l<0)
		{
		if (eflg)
			printf("read error block %d - ignored\n",block);
		else
			err("read error");
		l = 512;
		}
	writebf(output,buff,l);
	}
close(output);
if(vflg)
	printf("%s restored\n",file);
}


writebf(outdes,bf,l)
int *bf;
int outdes;
int l;
{

/*
 * routine to write a bfer out onto a file. if the -z option
 * is on then only write non-zero blocks.
 * if aflg is on then strip out CR and NULL.
 */

register int *p;
register int n;

if(zflg)
	{
	p = bf;
	n = l >> 1;
	do
		if( *p++ )
			goto put;
	while (--n);
	seek(outdes,l,1);		/* to end off file + l */
	return;
	}

put:
if (aflg)
	l = fixasc(bf,l);		/* remove non-ascii chars */

if (write(outdes,bf,l) < 0)
	err("write error");
}


fixasc(buf,length) char *buf;
{
register char *p, *q;

for (p = q = buf; --length >= 0; )
	if ((*p = *q++) != 0 && *p != '\r')
		++p;
return(p-buf);
}

rdcmd(cmd)
int (*cmd)();
{

register int i;
register int j;
register int *d;

addr = dir->h_block;

for (ALLDIR)
	{
	if(d->d_type == T_FILE)
		{
		cvtname(d->d_name,filename);
		if (select(filename))
			(*cmd)(d,filename);
		}
	addr =+ d->d_length;
	}
if (dir->h_next == 0)		/* last segment, check if ok */
	for (i=0; i<argc; ++i)
		if(used[i]==0)
			{
			printf("rtdt: %s not found\n",argv[i]);
			++errflg;
			}
}

select(filename) char *filename;
{
register int j;

if (argc == 0)
	return(1);
for (j=0; j<argc; ++j)
	{
	if(match(filename,argv[j]))
		{
		++used[j];
		return(1);
		}
	}
return(0);
}

delete(d,file)
char *file;
struct dir *d;
{
register int i;

/*
 * delete file "n" from the tape. 
 */

d->d_type = T_EMPTY;
update();
if(vflg)
	printf("%s deleted\n",file);
}



savecmd()
{
register int i;
register int *d;

for (i=0; i<argc; ++i)
	{
	addr = dir->h_block;
	for (ALLDIR)
		{
		if(d->d_type != T_FILE)
			continue;
		cvtname(d->d_name,filename);
		if(equal(argv[i],filename))
			delete(d,argv[i]);
		}
	addr = dir->h_block;
	for (ALLDIR)
		{
		if(d->d_type == T_EMPTY || d->d_type == T_NEW)
			goto gotit;
		addr += d->d_length;
		}
	err("directory full file %s",argv[i]);

	gotit:
		save(argv[i],d);
	}

}

save(name,d) struct dir *d; char *name;
{
register int block, last;
register int l;
struct dir *r = d + 1;
int n;
int oldsize = d->d_length;

in = iflg ? dup(0) : open(name,0);
if(in < 0)
	err("no %s",name);
n = size(in);
if (n > oldsize)
	err("rtdt: %s is %d blocks; only %d available",name,n,oldsize);
switch(r->d_type)
	{
case T_END:
	move(sizeof (struct dir),r,r+1);	/* move the end */
	clear(r,sizeof (struct dir));
	r->d_type = T_EMPTY;
	break;
case T_NEW:
case T_EMPTY:
	break;
default:
	err("next slot not empty");
	}
doscvt(name,d->d_name);
d->d_type = T_FILE;
last = 0;
block = addr;
seek(tape,block,3);
r->d_length += oldsize;		/* add into next slot */
d->d_length = 0;		/* reset the length */
while ((l=readbf(buff,512)) > 0)
	{
	d->d_length++;
	r->d_length--;
	if(l < 512)
		clear(buff+l,512-l);
	if (vflg > 1)
		printf("write block %d - %d bytes\n",block,l);
	if(write(tape,buff,512) < 0)
		err("RT-11 device: write error");
	++block;
	}
close(in);
update();
if(vflg)
	printf("rtdt: %s saved\n",name);
}



readbf(buffer,len)
char *buffer;
{

register int l,n;
register char *p;

p = buffer;
l = len;

while ( (n = read(in,p,l)) > 0)
	{
	if( (l =- n) == 0)
		return(len);
	p =+ n;
	}
if(n < 0)
	err("input read error");
return(len-l);
}


prdir(d)
struct dir *d;
{
register char *type;

if(d->d_type == T_FILE)
	cvtname(d->d_name,filename);
else
	copy(filename,"<unused>");
cvtdate(d->d_date);
switch(d->d_type)
	{
case T_NEW:
	type = "-";
	break;
case T_EMPTY:
	type = "*";
	break;
default:
	type = "";
	break;
	}
if (vflg)
	printf("%-10.10s %3d %-9s %4d%s\n",
		filename,d->d_length,date,addr,type);
else
	printf("%.10s\n",filename);
}

update()
{
/*
 * update the directory on the tape.
 */

seek(tape,DIRBLK,3);
if(write(tape, dir, dirlen) != dirlen)
	err("updating the directory");
}

#


/* general utility routines */ 

cvtname(name,str)
char *str;
int *name;
{
register char *p;
register char *q;
register int *n;

n = name;
p = str;

if(*n == 0)
	err("bad name");

rad50(*n++,p);
p=+ 3;
rad50(*n++,p);
p=+ 3;
if (*n!=0)
	*p++ = '.';
rad50(*n,p);
p=+ 3;
*p++ = 0;
q = p = str;
do 
	if (*p!=' ')
		*q++ = *p;
while (*p++);
}

radpk(ptr) 
char *ptr;
{
register int w;
register char *p;

w = 0;
p = ptr;
w = radch(*p++);
w=* 40;
w=+ radch(*p++);
w=* 40;
w=+ radch(*p++);
return(w);
}

radch(c) 
{
register int ch;
ch=c;
if(ch == ' ')
	return(0);
if(ch=='$')
	return(033);
if(ch=='.') 
	return(034);
if(ch>='a' && ch<= 'z')
	return(ch-'a'+1);
if(ch>='A' && ch<='Z')
	return(ch-'A'+1);
if(ch>='0' && ch<='9')
	return(ch-'0'+036);
return(0);
}

doscvt(file,outp)
char *file;
int *outp;
{
/*
 * convert the unix name in "file" to a dos rad50 
 * name in "outp". 
 */
register char *p, *q;
register int *o;
char name[10];
char ext[6];

clear(name,10);
clear(ext,6);

q = name;
o = outp;
p = file;

while (*p)
	{
	if(*p == '.')
		{
		q = ext;
		++p;
		}
	else
		*q++ = *p++;
	}
*o++ = radpk(name);
*o++ = radpk(name+3);
*o++ = radpk(ext);
#ifdef	debug
printf("doscvt: %s ==> %o %o %o\n",name,outp[0],outp[1],outp[2]);
#endif
}

int days[12]
{ 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };

char *months[] 
{ "JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT",
"NOV", "DEC" , "bad" };

cvtdate(dt)
{
register int year, month, day;
if (dt == 0)
	date[0] = 0;
else
	{
	year = 72 + dt%32;
	day = dt/32;
	month = day/32 - 1;
	if (month < 0 || month > 12)
		month = 12;
	day = day%32;
	sprintf(date,"%02d-%s-%02d",day,months[month],year);
	}
}

size(des)
{
register int l;
extern int ldivr;

#

#define	IALLOC	0100000
#define	IFMT	060000
#define		IFDIR	040000
#define	IFCHR	020000
#define	IFBLK	060000

struct stat
{
char s_minor;
char s_major;
int s_inumber;
int s_flags;
char s_nlinks;
char s_uid, s_gid;
char s_size0;
int s_size1;
int s_addr[8];
int s_actime[2];
int s_modtime[2];
} ;

struct {
int s_dev;
int s_inumber;
int s_flags;
char s_nlinks;
char s_uid, s_gid;
char s_size0;
int s_size1;
int s_addr[8];
long s_atime;
long s_mtime;
};
struct stat stat;

if (fstat(des,&stat) < 0)
	return(0);
l = ldiv(stat.s_size0&0377,stat.s_size1,512);
if (ldivr)
	++l;
return(l);
}
