#
#include <stdio.h>

#define	IS	=

#
#define	IALLOC	0100000
#define	IFMT	060000
#define		IFDIR	040000
#define	IFCHR	020000
#define	IFBLK	060000

struct stat
{
char s_minor;
char s_major;
int s_inumber;
int s_flags;
char s_nlinks;
char s_uid, s_gid;
char s_size0;
int s_size1;
int s_addr[8];
int s_actime[2];
int s_modtime[2];
} statbuff;

struct {
int s_dev;
int s_inumber;
int s_flags;
char s_nlinks;
char s_uid, s_gid;
char s_size0;
int s_size1;
int s_addr[8];
long s_atime;
long s_mtime;
};

char *base;		/* base for space allocation */
char printing[40];	/* 1 if printable */
char *pgname;		/* program name (pr) */
int lastline;
int pagenum;
FILE *fd;		/* the input file */
int ncols IS 1;		/* default number of columns */
int pagecol;		/* column on the page */
int length IS 66;		/* the page length */
int line;
int stline IS 2;		/* start line for text */
char *colptr;
char *colstart;
int curpp;		/* current print position */
int width IS 132;
int lines IS 60;
int colwidth IS 132;
char *heading IS "";
#define	MAXHEAD	10
char *head[MAXHEAD];	/* additional headings */
int headcnt;		/* number of heading lines */
char *file;
int pflg;
int hflg;
int nflg;
int dflg;
int	tflg	IS 0;
char *pageptr;
char *pageend;
int pagesize;		/* size of page (in bytes) */

#define	NL	'\n'

main(argc,argv) char **argv;
{
register char *argp;
register int i;

printing['\t']=printing['\n']=printing['\r']=printing['\b']=printing[014]=1;
pgname = argv[0];
setout();
lines = lplines();
for (i=1; i<argc; ++i)
	{
	argp = argv[i];
	if (*argp == '-')
		{
		++argp;
		switch(*argp++)
			{
		case 'd':
			++dflg;		/* no date in header */
			break;
		case 'n':		/* begin at page n */
			++nflg;
			break;
		case 'm':		/* multiple files/page */
			err("-m not implemented");
		case 'h':		/* heading */
			heading = argv[++i];
			++hflg;
			break;
		case 'H':
			if (headcnt >= MAXHEAD-1)
				err("too many heading lines");
			head[headcnt++] = argv[++i];
			++stline;
			break;
		case 't':		/* no header */
			if (!tflg)
				stline -= 2;
			++tflg;
			break;
		case 'w':		/* width of page */
			width = cvtint(argp);
			break;
		case 'l':		/* length of page */
			lines = cvtint(argp);
			break;
		case 'p':		/* print all characters */
			++pflg;
			break;
		default:
			--argp;
			if (*argp >= '0' && *argp <= '9')
				ncols = cvtint(argp);
			else
				err("bad option %s",argp);
			break;
			}
		}
	else
		{
		fd = fopen(argp,"r");
		file = argp;
		stat(file,&statbuff);
		if (fd == NULL)
			err("can't open %s",argp);
		if (!hflg)
			heading = argp;
		dofile(fd);
		fclose(fd);
		}
	}
if (file == 0)
	dofile(stdin);
flush();
if (ferror(stdout))
	err("writing");
exit(0);
}

initcol()
{
line = 0;
curpp = 0;
pagecol = 0;
if (ncols == 1)
	return;
colwidth = width/ncols;
pagesize = width*lines;
if (base == NULL || pageend < base + pagesize)
	{
	if (base != NULL)
		free(base);
	pageptr = base = malloc(pagesize);
	pageend = base+pagesize;
	}
set(pageptr,pagesize,' ');
setptr();
}

dofile(f) FILE *f;
{
register int c;

pagenum = 0;
initcol();
if (ncols == 1)
	doheader();
else
	{
	line = stline;
	setptr();
	}
while ((c = getc(f)) >= 0)
	{
	if (!pflg)
		{
		if (c >= 0177)
			err("%s contains non-printing characters",
				file ? file : "input");
 		if (c < 040 && !printing[c])
			c = '?';
		}
	if (ncols == 1)
		{
		switch(c)
			{
		case '\n':
			putchar(c);
			if (++line >= lines)
				{
				doheader();
				}
			break;
		case 014:
			doheader();
			c = getc(f);
			if (c != NL)
				ungetc(c,f);
			break;
		default:
			putchar(c);
			}
		}
	else
		{
		if (c == 014)
			{
			newpage();
			c = getc(f);
			if (c != NL)
				ungetc(c,f);	/* throw back NL after FF */
			}
		else
			store(c);
		}
	if (ferror(stdout))
		err("writing");
	}
if (ncols > 1)
	newpage();
flush();
if (ferror(stdout))
	err("writing");
}

store(c) register int c;
{
if (c == '\n')
	newline();
else if (c == '\t')
	{
	curpp = (curpp+8) & ~07;
	colptr = colstart+curpp;
	}
else
	if (++curpp < colwidth)
		*colptr++ = c;
}

newline()
{
/*
 * go to a new line in multi-column mode.
 * if we go past the number of lines/page then
 * start next column.
 */
curpp = 0;
if (++line >= lines)
	newcol();
setptr();
}

setptr()
{
curpp = 0;
colstart = colptr = base + line*width + colwidth * pagecol;
if (line > lastline)
	lastline = line;
}

newcol()
{
/*
 * start a new column.
 * if all columns full then start a new page.
 */
if (++pagecol >= ncols)
	{
	doheader();
	pageprint();
	}
line = stline;
setptr();			/* start next column in right place */
}

pageprint()
{
/*
 * print out accumulated page of text in multi-column
 * mode.
 * also trim trailing blanks off the output lines.
 */
register char *p;
register int c;
register int j;
int cnt;
int i;

if (lastline < lines)
	lastline++;
for (i=stline; i<lastline; ++i)
	{
	p = pageptr + i*width;
	cnt = 0;
	for (j=0; j<width; ++j)
		{
		c = *p++;
		if (c == ' ')
			++cnt;
		else
			{
			while (cnt > 0)
				{
				putchar(' ');
				--cnt;
				}
			putchar(c);
			}
		}
	putchar('\n');
	if (ferror(stdout))
		err("writing");
	}
set(pageptr,pagesize,' ');
lastline = 0;
}

doheader()
{
long tvec;
register char *p;
register int i;

putchar(014);
if ( nflg ) putchar(016);
pagecol = 0;
++pagenum;
if (!tflg)
	{
	if (!dflg)
		{
		if (file)
			tvec = statbuff.s_mtime;
		else
			time(&tvec);
		p = ctime(&tvec);
		printf("%.12s %.4s ",p+4,p+20);
		}
	printf("%s Page %d\n",heading,pagenum);
	putchar('\n');
	}
for (i=0; i<headcnt; ++i)
	printf("%s\n",head[i]);
line = stline;
}

cvtint(ptr) char *ptr;
{
register int n;
register int c;

for (n=0; c = *ptr; ++ptr)
	{
	if ((c =- '0') < 0 || c > 9)
		err("bad number");
	n = n * 10 + c;
	}
return(n);
}

newpage()
{
if (pagecol == 0 && curpp == 0 && line == stline)
	return;
doheader();
pageprint();
setptr();
}

err(msg,p1,p2) char *msg;
{
extern errno;

flush();
fprintf(stderr,"%s: ",pgname);
fprintf(stderr,msg,p1,p2);
if (errno)
	{
	fprintf(stderr," - ");
	flush();
	perror("");
	}
else
	putchar('\n');
flush();
exit(1);
}
