#

/*
 * online/offline
 * under V6, take a terminal offline or put it online by changing the 
 * 0/1 flag byte of the line in /etc/ttys and then notifying init
 * via a "kill -1 1".
 * in order to change the appropriate files and do the kill the program
 * must be SETUID to ROOT
 * under V7 and VAX the format of /etc/ttys, /etc/utmp are a little
 * different but the same principle can be used.
 */
#include <stdio.h>
#include <utmp.h>
#include <pwd.h>
#include <stat.h>

struct stat statb;
#define	TTYS	"/etc/ttys"
struct utmp utmp;

char dev[20];
char temp[32];	/* temp name of tty */
#ifdef V6
#define	STATUS	0	/* first byte of line */
#define	TTY	1	/* the tty name */
#define	SPEED	2	/* where the speed is */
#define	TTYCMP(a,b) (*(a) == *(b))
#define	CONSOLE	"tty8"
#else
#define	STATUS	0
#define	SPEED	1
#define	TTY	2	/* name follows in v7 */
#define	TTYCMP(a,b) (strncmp(a,b,strlen(b)) == 0)
#define	CONSOLE	"console"
#endif
char ttys[32];	/* buffer to read tty name, status and speed. */
int rflg;
int lflg;
int sflg;
char *tty;
char *ttyname;	/* the full tty name */

main(argc,argv) char **argv;
{
register int l;
int posn;
int status;
FILE *in;
FILE *f;
int out;
char **oldargv = argv;
register char *argp;

++argv;
--argc;
status = any(oldargv[0],"f") ? '0' : '1';
if (argc == 2 && *(argp = *argv) == '-')
	{
	++argv;
	--argc;
	++argp;
	while (*argp)
		switch(*argp++)
			{
		case 's':
			++sflg;		/* do it silently */
			break;
		case 'l':
			++lflg;		/* local mode */
			break;
		case 'r':
			++rflg;		/* remote */
			break;
		case '0':		/* offline */
		case '1':		/* online */
			status = argp[-1];
			break;
		default:
			argc = 0;
			break;
			}
	}
if (argc != 1 || strncmp(argv[0],"tty",3))
	xerr("usage: %s [-01lrs] ttyx",oldargv[0]);
if (strcmp(argv[0],CONSOLE) == 0)
	err("Can't %s the console",oldargv[0]);
tty = ttyname = argv[0];
#ifdef V6
tty =+ 3;	/* point to last part of name */
#endif
if ((in = fopen(TTYS,"r")) == 0)
	xerr("can't open %s",TTYS);
if ((out = open(TTYS,2)) < 0)
	xerr("can't open %s for update",TTYS);
if ((f = fopen("/etc/utmp","r")) == NULL)
	xerr("can't open /etc/utmp");
while (fread(&utmp,sizeof utmp,1,f))
	{
#ifdef V6
	if (utmp.ut_tty == *tty)
#else
	if (strcmp(utmp.ut_line,tty))
#endif
		xerr("%-8.8s is logged in on %s",utmp.ut_name,ttyname);
	}
fclose(f);
for (posn=0; fgets(ttys,sizeof ttys,in); posn += l)
	{
	l = strlen(ttys);
	ttys[l-1] = 0;		/* kill the nl character */
#ifdef V6
	if (l != 4)
		err("%s - bad format",TTYS);
#endif
	if (TTYCMP(ttys+TTY,tty))
		{
		if (ttys[STATUS] == status)
			xerr("%s already %s",ttyname,status == '1' ? "online" : "offline");
		ttys[STATUS] = status;
		seek(out,posn+STATUS,0);
		if (write(out,&status,1) < 0)
			xerr("write error on %s",TTYS);
		if (kill(1,1) < 0)
			xerr("can't kill -1 1");
		sprintf(dev,"/dev/%s",ttyname);
		if (chmod(dev,0666) < 0)
			xerr("can't chmod %s",dev);
		if (!sflg)
			printf("%s now %s\n",ttyname,status == '1' ? "online" : "offline");
		if (f = fopen("/etc/ttys.log","a"))
			{
			long now;
			register struct passwd *pw = getpwuid(getuid()&0377);
			time(&now);
			fprintf(f,"%s:%s %s %s",pw->pw_name,
				oldargv[0],argv[0],ctime(&now));
			}
		sprintf(temp,"/etc/tty.init/%s.auto",ttyname);
		if (stat(temp,&statb) >= 0)
			{
			if (status == '0')
				++lflg;
			else
				++rflg;
			}
		if (lflg || rflg)
			{
			if (sflg)
				execl("/etc/local",oldargv[0],"-s",lflg ? "-l" : "-r",argv[0],(char *) NULL);
			else
				execl("/etc/local",oldargv[0],lflg ? "-l" : "-r",argv[0],(char *) NULL);
			xerr("no /etc/local found");
			}
		exit(0);
		}
	}
xerr("%s not found",ttyname);
}

xerr(fmt,d1,d2,d3,d4) char *fmt;
{
if (sflg)
	exit(1);
err(fmt,d1,d2,d3,d4);
}
