#

#include "/usr/include/errnos.h"

#define	MAXNAME	256
#define	READ	04
#define	WRITE	02
#define	EXEC	01
#define	STICKY	01000

struct stat
{
char s_minor;
char s_major;
int s_inumber;
int s_flags;
char s_nlinks;
char s_uid, s_gid;
char s_size0;
int s_size1;
int s_addr[8];
int s_actime[2];
int s_modtime[2];
} statb;
int mkdir();

int uid, gid;
int rc;

main(argc,argv) char **argv;
{
register int i;

uid = getuid()&0377;
gid = getgid()&0377;

for (i=1; i<argc; ++i)
	enter(&mkdir,argv[i]);
exit(rc);
}

char dot[MAXNAME];
char parent[MAXNAME];

mkdir(name) char *name;
{
register char *p, *pp;
register char *s;
char *ptr;
int c;
int mode;
extern int errno;

errno = 0;
p = dot;
pp = parent;

/*
 * copy the name into dot,
 * and the parent into "parent"
 * keeping track of last '/' of parent in s
 */
for (ptr=name; c = *ptr++; )
	{
	*p++ = c;
	if (p > dot+MAXNAME-5)
		err(name," too many characters");
	*pp++ = c;
	if (c == '/')
		s = pp;
	}
*p++ = '/';
*p++ = '.';
*p = 0;
if (s == 0)			/* if no '/' in name must be in '.' */
	{
	s = parent;
	*s++ = '.';
	*s = 0;
	}
else
	{
	*s = 0;
	if (s != parent+1)	/* if not /xxx */
		*--s = 0;
	}
if (access(parent,WRITE) == -1)
	err(name,": cannot write ",parent,0);
mode = (statb.s_flags & 0777) | 0140700;
if (mknod(name,mode,0) < 0)		/* make a directory */
	err(name,": cannot make node",0);
if (chown(name,(gid<<8)+uid) < 0)	/* make user owner */
	err(name,": cannot change owner",0);
if (link(name,dot) < 0)		/* link . to name */
	err("cannot link ",name," ",dot,0);
*p++ = '.';
*p = 0;					/* build .. */
if (link(parent,dot)<0)			/* link name/.. to parent parent */
	err("cannot link ",parent," ",dot,0);
/*
 * if "..." exists in parent directory then use it's mode.
 */
append(parent,"/...");
if (stat(parent,&statb) >= 0)
	chmod(name,statb.s_flags & 0777);

}

access(name,h) char *name;
{
register int flags;
extern int errno;
register int how;
/*
 * check if we have "how" access to "name".
 */
how = h;
if (stat(name,&statb) < 0)
	return(-1);
flags = statb.s_flags;
if (uid == 0 || (statb.s_uid&0377) == uid)
	how =<< 6;			/* check owner access */
else if ((statb.s_gid&0377) == gid)
	how =<< 3;			/* check group access */
else if (flags & STICKY)
	how = -1;			/* no "other" access if sticky */
if ((how & flags) == how)
	return(0);
errno = EACCES;			/* permission denied */
return(-1);
}

err(msg) char *msg;
{
extern int errno;
register char **p;

for (p = &msg; *p; ++p)
	puts(*p);
if (errno)
	{
	puts(" - ");
	perror("");
	}
else
	puts("\n");
rc++;
leave(msg);
}

puts(str) char *str;
{
write(1,str,length(str));
}
