#include <stdio.h>
#include <ctype.h>

char digits[] "0123456789ABCDEF";
int ndelay 0;
int len 32;
int cnt;
char *argp;
int	iflg;		/* input is in hex */
int	nflg;		/* send name along with file */
FILE *f;
FILE *outf = stdout;
char name[256];

main(argc,argv) char **argv;
{
register int c;
register int i;

setout();
--argc;
++argv;
for (; --argc >= 0; )
	{
	if (*(argp = *argv++) == '-')
		{
		++argp;
		while (*argp)
			{
			switch(*argp++)
				{
			case 'n':
				++nflg;
				break;
			case 'h':
			case 'r':
				++iflg;
				break;
			case 'd':
				ndelay = getint();
				break;
			case 'l':
				len = getint() >> 1;
				break;
			default:
				err("invalid switch %s",argp-1);
				}
			}
		}
	else
		{
		if ((f = fopen(argp,"r")) == 0)
			err("can't open %s",argp);
		if (nflg)
			printf("\n=%s\n",argp);	/* send the name */
		dofile(f);
		fclose(f);
		}
	}

if (f == NULL)
	dofile(stdin);
exit(0);
}

dofile(f) FILE *f;
{
if (iflg)
	doin(f);
else
	doout(f);
}

doout(f) FILE *f;
{
register int c;

while ((c = getc(f)) != EOF)
	{
	putdig(c>>4);
	putdig(c);
	if (++cnt == len)
		endline();
	}
if (cnt)
	endline();
fflush(outf);
}

endline()
{
register int i;

cnt = 0;
putc('\n',outf);
for (i=0; i<ndelay; ++i)
	putc(026,outf);		/* sync it */
}

putdig(c)
{
c =& 017;
putc(digits[c],outf);
}

getint()
{
register int n;
register char *s;
register int c;

n = 0;
for (s=argp; c = *s; ++s)
	{
	if (c >= '0' && c <= '9')
		n = n * 10 + c - '0';
	else
		err("bad integer offset");
	}
argp = s;
return(n);
}

doin(f) register FILE *f;
{
register int n1, n2;

while ((n1 = nibble(f)) >= 0 && (n2 = nibble(f)) >= 0)
	putchar((n1<<4) + n2);
}

nibble(f) register FILE *f;
{
register int c;
register char *p;

while ((c = getc(f)) >= 0)
	{
	if (isdigit(c))
		return(c-'0');
	if ('A' <= c && c <= 'F')
		return(c-'A'+10);
	if ('a' <= c && c <= 'f')
		return(c-'a'+10);
	if (isspace(c))
		continue;
	if (c == '=')
		{
		if (fgets(name,sizeof name,f) && nflg)
			{
			if (p = any(name,"\n"))
				*p = 0;
			if (outf != stdout)
				fclose(outf);
			if ((outf = fopen(name,"w")) == NULL)
				err("can't open %s",name);
			fprintf(stderr,"=%s\n",name);
			}
		continue;
		}
	err("bad hex digit '%c'",c);
	}
return(c);
}
