#
#include <stdio.h>
/*
 * filecp: program to copy a UNIX Version 7 filessystem and
 * output the files found or requested.
 * this may be used under RT-11 (with UNIX emulation) or
 * possibly under UNIX Version 7.
 * synopsis: filecp /dev/filesys [-t] [-r] [-l] [-c] [-o] file1 file2 ...
 * -t	trace actions
 * -m	make directories as needed
 * -v	verbose, say what we are doing
 * -d	don't set date (via mdate)
 * -r	recurse thru directories
 * -l	list (a la ls -l -i)
 * -c	copy into same name in current directory
 * -o	output into file with the same last name
 * -w	ask user interactively
 * file1 etc. are files to look for (or directories if -r specified)
 * note that unless the super user runs this program (or it is setuid to ROOT)
 * the group and user id's of the resulting files will be those of the user
 * running the program.
 *
 * to make it: cc filecp.c -lw
 */
#define	ROOT	2

#define	BUFFSIZE	512
#define	MAXNAME	64
#define	DIRSIZE	16

typedef	long       	daddr_t;  	/* disk address */
typedef	char *     	caddr_t;  	/* core address */
typedef	unsigned int	ino_t;     	/* i-node number */
typedef	long       	time_t;   	/* a time */
typedef	int        	label_t[6]; 	/* program status */
typedef	int        	dev_t;    	/* device code */
typedef	long       	off_t;    	/* offset in file */
	/* selectors and constructor for device code */
#define	major(x)  	(int)(((unsigned)x>>8))
#define	minor(x)  	(int)(x&0377)
#define	makedev(x,y)	(dev_t)((x)<<8|(y))

#define	NICFREE	50
#define	NICINOD	100
/*
 * Structure of the super-block
 */
struct	filsys {
	unsigned short s_isize;	/* size in blocks of i-list */
	daddr_t	s_fsize;   	/* size in blocks of entire volume */
	short  	s_nfree;   	/* number of addresses in s_free */
	daddr_t	s_free[NICFREE];/* free block list */
	short  	s_ninode;  	/* number of i-nodes in s_inode */
	ino_t  	s_inode[NICINOD];/* free i-node list */
	char   	s_flock;   	/* lock during free list manipulation */
	char   	s_ilock;   	/* lock during i-list manipulation */
	char   	s_fmod;    	/* super block modified flag */
	char   	s_ronly;   	/* mounted read-only flag */
	time_t 	s_time;    	/* last super block update */
	/* remainder not maintained by this version of the system */
	daddr_t	s_tfree;   	/* total free blocks*/
	ino_t  	s_tinode;  	/* total free inodes */
	short  	s_m;       	/* interleave factor */
	short  	s_n;       	/* " " */
	char   	s_fname[6];	/* file system name */
	char   	s_fpack[6];	/* file system pack name */
};

/*
 * Inode structure as it appears on
 * a disk block.
 */
struct dinode
{
	unsigned short	di_mode;     	/* mode and type of file */
	short	di_nlink;    	/* number of links to file */
	short	di_uid;      	/* owner's user id */
	short	di_gid;      	/* owner's group id */
	off_t	di_size;     	/* number of bytes in file */
	char  	di_addr[40];	/* disk block addresses */
	time_t	di_atime;   	/* time last accessed */
	time_t	di_mtime;   	/* time last modified */
	time_t	di_ctime;   	/* time created */
};
#define	INOPB	8	/* 8 inodes per block */
/*
 * the 40 address bytes:
 *	39 used; 13 addresses
 *	of 3 bytes each.
 */

struct v6stat
{
char s_minor;
char s_major;
int s_inumber;
int s_flags;
char s_nlinks;
char s_uid, s_gid;
char s_size0;
int s_size1;
int s_addr[8];
long s_atime;
long s_mtime;
} statb;

struct	inode		/* inode as it appears in memory */
{
	dev_t	st_dev;
	ino_t	st_ino;
	unsigned short st_mode;
	short	st_nlink;
	short  	st_uid;
	short  	st_gid;
	dev_t	st_rdev;
	off_t	st_size;
	time_t	st_atime;
	time_t	st_mtime;
	time_t	st_ctime;
	daddr_t	st_addr[13];
};

#define	S_IFMT	0170000		/* type of file */
#define		S_IFDIR	0040000	/* directory */
#define		S_IFCHR	0020000	/* character special */
#define		S_IFBLK	0060000	/* block special */
#define		S_IFREG	0100000	/* regular */
#define		S_IFMPC	0030000	/* multiplexed char special */
#define		S_IFMPB	0070000	/* multiplexed block special */
#define	S_ISUID	0004000		/* set user id on execution */
#define	S_ISGID	0002000		/* set group id on execution */
#define	S_ISVTX	0001000		/* save swapped text even after use */
#define	S_IREAD	0000400		/* read permission, owner */
#define	S_IWRITE	0000200		/* write permission, owner */
#define	S_IEXEC	0000100		/* execute/search permission, owner */

struct dir
{
int d_inode;
char d_name[14];
};

#define	I_TYPE	0170000
#define		I_FILE	0100000
#define		I_DIR	0040000
#define		I_CHAR	0020000
#define		I_BLOCK	0060000
#define	I_SETUID	04000
#define	I_SETGID	02000
#define	I_STICKY	01000
#define	I_MODES	0777
#define	CR_MASK	(I_SETUID|I_SETGID|I_STICKY|I_MODES)


int outfile 1;
int wflg;			/* if we should ask user */
int uflg;			/* update mode - only restore if need to
*/
int oflg;			/* output to short name of file */
int vflg;			/* verbose */
int mflg;			/* make directories as needed */
int dflg;			/* suppress setting of modification time */
int cflg;			/* copy the file into same name */
int rflg;			/* recursive decent */
int tflg;			/* tracing */
int lflg;			/* list directory */
int fflg;			/* restore directory into a file */
int fsdes;
char *filesys, *namep;
char buff[512];
int curdir ROOT;
long itol();

struct buf
{
daddr_t b_block;
daddr_t b_buf[128];
} *ind1, *ind2;

main(argc,argv) char **argv;
{
struct inode inode;
register int i;
char *name;

--argc;
++argv;

if (argc < 2)
	err("usage: filecp filesys files");
filesys = *argv++;
--argc;
if ((fsdes = open(filesys,0)) < 0)
	err("can't open %s",filesys);
while (argc > 0)
	{
	name = *argv++;
	--argc;
	if (*name == '-')
		{
		switch(*++name)
			{
		case 'u':
			++uflg;		/* update mode */
			break;
		case 'w':
			++wflg;		/* ask before copying */
			break;
		case 'f':
			++fflg;
			break;
		case 'v':
			++vflg;		/* verbose */
		case 'm':		/* make directories */
			++mflg;
			break;
		case 'd':		/* suppress date setting via mdate */
			++dflg;
			break;
		case 'r':		/* recurse thru directories */
			++rflg;
			break;
		case 't':		/* table of contents (like ls) */
			++tflg;
			break;
		case 'l':		/* long form (like ls -l) */
			++lflg;
			printf(
"inode  access   links  uid  gid    len  date       name\n");
			break;
		case 'o':	/* output to file (last part of path name) */
			++oflg;
			++cflg;		/* copy mode */
			break;
		case 'c':		/* copy files into same name */
			++cflg;
			break;
			}
		continue;
		}
	if (!(cflg || lflg))
		++lflg;			/* default to lflg */
	namep = name;
	if (*namep == '/')
		{
		++namep;
		i = ROOT;
		}
	else
		i = curdir;
	if (( i = locate(i,namep)) == 0)
		err("no %s",name);
	getinode(i,&inode);
	if (lflg)
		{
		list(i,&inode,0,name);
		continue;
		}
	if (cflg)
		cpfile(i,&inode,namep);
	}
}

cpfile(inumber,inode,name) struct inode *inode;
{
register int l, blk;
register int i;
int mode;
char *p;

if (tflg)
	printf("cpfile %s\n",name);
if ((inode->st_mode&I_TYPE) == I_DIR)
	{
	if (rflg)
		{
		cpdir(inumber,inode,name);
		return;
		}
	else if (!fflg)
		err("%s is a directory",name);
	}
if (wflg > 1 && !ask("%s? ",name))
	return;
p = name;
if (oflg)
	p = last(p);
else
	if (*p == '/')
		++p;	/* always create in current directory */
if (uflg && stat(p,&statb) >= 0 && statb.s_mtime == inode->st_mtime)
	{
	if (vflg || tflg)
		printf("%s: already done\n",p);
	return;
	}
mode = (inode->st_mode&CR_MASK);
if (vflg || tflg)
	printf("creat %s @ %o\n",p,mode);
if ((outfile = creat(p,mode)) < 0)
	err("can't creat %s",p);
for (blk = 0; (l = readfile(inode,blk,&buff)) > 0; ++blk)
	{
	if (write(outfile,&buff,l) != l)
		err("write error");
	}
if (cflg)
	{
	close(outfile);
	chown(p,(inode->st_uid<<8) | (inode->st_gid&0377));
	if (!dflg)
		mdate(p,&inode->st_mtime);
	}
}

cpdir(inumber,inode,name) struct inode *inode;
{
register int i;
int l;
int blk;
int mode;
register char *p;
register char *d;
struct inode newinode;
char *buffp;
char newname[MAXNAME];

if (tflg)
	printf("cpdir %s\n",name);
if (wflg && !ask("%s? ",name))
	return;
buffp = getbuff();
if (mflg && !oflg && stat(name,&statb) < 0)
	{
	if (vflg || tflg)
		printf("mkdir %s\n",name);
	mkdir(name);
	}
for (blk = 0; (l = readfile(inode,blk,buffp)) > 0; ++blk)
	{
	for (i=0; i<l; i =+ DIRSIZE)
		{
		d = buffp+i;
		if (d->d_inode == 0 || d->d_name[0] == '.')
			continue;
		copy(newname,name);
		p = endstr(newname);
		if (p[-1] != '/')
			*p++ = '/';
		move(14,d->d_name,p);
		p[14] = 0;
		getinode(d->d_inode,&newinode);
		cpfile(d->d_inode,&newinode,newname);
		}
	}
freebuff(buffp);
}

getbuff()
{
return(alloc(BUFFSIZE));
}

freebuff(ptr) char *ptr;
{
free(ptr);
}

readfile(inode,block,buffer) char *buffer; struct inode *inode;
{
/*
 * from file corresponding to inode "inode" read logical
 * block "block" into "buffer"
 * return 512 unless last block is being read.
 */
long bsize, size;
register int l;

bsize = itol(block>>(16-9),block<<9);
size = inode->st_size;
if (bsize >= size)
	return(0);
readmapped(inode,block,buffer);
if (bsize >= size-512)
	l = size-bsize;
else
	l = 512;
return(l);
}



long readind();
readmapped(inode,block,buffer) struct inode *inode;
int *buffer;
{
/*
 * read logical block "block" from file corresponding to "inode"
 * mapping logical to physical blocks.
 * result is returned into "buffer".
 */
register int indir, off;
register struct inode *i;
extern int ldivr;
int old;

old = block;
i = inode;
if (block < 10)
	block = i->st_addr[block];
else
	{
	block =- 10;
	if (block < 128)
		block = readind(&ind1,i->st_addr[10],block%128);
	else
		{
		block =- 128;
		indir = block/128;
		off = block%128;
		if (indir < 128)
			block = readind(&ind2,readind(&ind1,i->st_addr[11],indir),
				off);
		else
			err("triple indirect not implemented");

		}

	}
if (tflg)
	printf("block %d mapped to %d\n",old,block);
if (block != 0)
	readblock(block,buffer);
else
	clear(buffer, sizeof buffer);

return(512);
}

long readind(ptr,block,off) struct buf **ptr; long block;
{
register struct buf *p;

if ((p = *ptr) == NULL)
	{
	p = *ptr = alloc(sizeof (struct buf));
	clear(p,sizeof (struct buf));
	if (tflg)
		printf("indirect buffer allocated %o\n",p);
	}
if (p->b_block != block)
	{
	if (tflg)
		printf("read indirect block %D ",block);
	readblock((int) block,p->b_buf);
	}
p->b_block = block;
if (tflg)
	printf("indir block %D[%d] = %D\n",block,off,p->b_buf[off]);
return(p->b_buf[off]);
}

readblock(block,buffer)
char *buffer;
{
/*
 * read block "block" into "buffer" from the file system.
 */
if (tflg)
	printf("read block %u\n",block);
seek(fsdes,block,3);
if (read(fsdes,buffer,512) != 512)
	err("error reading block %u",block);
return(512);
}

getinode(inumber,inode) register struct inode *inode;
{
int blk;
int off;
register char *i;

if (tflg)
	printf("get inode %d\n",inumber);
blk = (inumber - 1 + 2 * INOPB)/INOPB;
off = (inumber - 1 + 2 * INOPB)%INOPB * (512/INOPB);
readblock(blk,buff);
i = buff+off;
inode->st_mode = i->di_mode;
inode->st_nlink = i->di_nlink;
inode->st_uid = i->di_uid;
inode->st_gid = i->di_gid;
inode->st_size = i->di_size;
inode->st_atime = i->di_atime;
inode->st_mtime = i->di_mtime;
inode->st_ctime = i->di_ctime;
unpack(13,i->di_addr,inode->st_addr);

if ((inode->st_mode&I_TYPE) == 0)
	err("i-node %d not allocated",inumber);
}

locate(inumber,path) char *path;
{
/*
 * locate is given a path and an inode number to search for that
 * path name. 
 * it first locates the inode from the inumber.
 * it then reads the directory and searches for the given
 * partial path name (via scan).
 * if there is a slash in the path it then recursively calls
 * itself to parse the next level in the path.
 * it returns when there are no more slashes in the path it is
 * passed or if it cannot find a partial path entry in a directory.
 * it returns the inode number when it finds the proper entry.
 * it doesn't check that all partial paths before slashes are
 * directories but then neither does glob. try ls /unix/*junk* sometime.
 */
register char *p;
register char *b;
register int l;
struct inode inode;
int i;
int block;

if (tflg)
	printf("locate path %s in inode %d\n",path,inumber);
while (*path == '/')
	++path;
if (*path == 0)
	return(inumber);
p = any(path,"/");
getinode(inumber,&inode);
for  (block=0; (l = readfile(&inode,block,&buff)) >= 0; ++block)
	{
	b = &buff;
	for (i=0; i<l; i=+ 16)
		{
		if (b->d_inode && scan(path,b->d_name))
			{
			if (p)
				return(locate(b->d_inode,p+1));
			return(b->d_inode);
			}
		b =+ 16;
		}
	}
return(0);
}

last(path)
char *path;
{
/*
 * return the last part of the file path after the last "/".
 */
register char *p, *q;

for (p=path; q = any(p,"/"); p = q+1)
	;
return(p);
}

scan(path,dir) char *path, *dir;
{
register int i;
register int p, d;

for (i=0; i<14; ++i)
	{
	p = *path++;
	d = *dir++;
	if ((p == '/' || p == 0) && d == 0)
		return(1);
	else if (p != d)
		return(0);
	}
return(1);
}

char listbuff[512];
char listblk;
list(inumber,inode,level,nm) struct inode *inode; char *nm;
{
/*
 * do a ls style output of the information in an inode "inode".
 * "inumber" is the inode's number.
 * "level" is the depth into list we have gone.
 * "nm" is the name of the file we are ls'ing.
 */
register int block;
struct inode lnode;
register int i, l;
char *b;

printf("%5d %-11s %3d %4d %4d %6D %s %s\n",inumber,prmode(inode->st_mode),
	inode->st_nlinks,inode->st_uid,inode->st_gid,inode->st_size,
	prdate(inode->st_mtime),nm);
if (rflg && (inode->st_mode&I_TYPE) == I_DIR)
	{
	printf("\n");
	for (block = 0; (l = readfile(inode,block,listbuff)) > 0; ++block)
		{
		listblk = block;
		b = listbuff;
		for (i=0; i<l; i =+ 16)
			{
			if (listblk != block)
				readfile(inode,listblk = block,listbuff);
			if (b->d_inode && b->d_name[0] != '.')
				{
				getinode(b->d_inode,&lnode);
				list(b->d_inode,&lnode,1+level,b->d_name);
				}
			b =+ 16;
			}
		}
	listblk = -1;
	}
if (tflg)
	printf("%d return from list\n",level);
}

unpack(n,chars,longs)
register int n; register char *chars, *longs;
{
do
	{
	*longs++ = 0;
	*longs++ = *chars++;
	*longs++ = *chars++;
	*longs++ = *chars++;
	}
while (--n);
}

char fdate[20];
prdate(date) long date;
{
/*
 * print out the date in ls format.
 */
long now;
register char *p;

time(&now);
now =- (long) 180 * 24 * 60 * 60;
p = ctime(&date);
if (date < now)
	sprintf(fdate,"%.6s %.4s",p+4,p+20);
else
	sprintf(fdate,"%.11s",p+4);
return(fdate);
}

ask(fmt,d1,d2,d3) char *fmt;
{
char resp[10];

printf(fmt,d1,d2,d3);
fgets(resp,sizeof resp,stdin);
return(resp[0] == 'y');
}
