#
#define	MAXLINE	512
#define	FLAG	';'
#define	MAXKEY	64		/* how much key to use */

int fdes;
int pipea[2], pipeb[2];
int status;
int fbuf[518/2];
long location;
char buff[MAXLINE];
long posn;
int len;
char *file;
char *sortvec[20];
int nsort;
int keyrec;		/* record containing key */
double atof();
char *endflag;		/* end of item flag */
int maxrec;

main(argc,argv) char **argv;
{
int i;
register int l;
long n;
register char *p;
extern fout;
extern fin[];
char *argp;

sortvec[nsort++] = "sort";
if (argc < 2)
	err("usage: fmtsort file");
for (i=1; i<argc; ++i)
	{
	argp = argv[i];
	if (*argp == '-')
		{
		++argp;
		switch(*argp)
			{
		case 's':
			sortvec[nsort++] = ++argp;
			break;
		case 'n':
			maxrec = atoi(++argp)-1;
			break;
		case 'e':
			endflag = ++argp;
			break;
		case 'l':
			++argp;
		default:
			keyrec = atoi(argp)-1;
			if (keyrec < 0)
				err("bad option %s",argv[i]);
			}
		}
	else if (*argp == '+')
		sortvec[nsort++] = argp;
	else
		file = argp;
	}
if (file == 0)
	err("usage: fmtsort -n +i file ");
fdes = open(file,0);
if (fdes < 0)
	err("can't open %s",file);
fin[0] = fdes;
fout = dup(1);
if (pipe(pipea) < 0 || pipe(pipeb) < 0)
	err("no pipes");
if (fork() == 0)
	{
	close(0);
	close(1);
	dup(pipea[0]);
	dup(pipeb[1]);
	closeall();
	execv("/bin/sort",sortvec);
	err("no /bin/sort");
	exit(1);
	}
fout = pipea[1];
close(pipea[0]);

posn = 0;
for (;;)
	{
	for (i=0;  ((l = readline(buff,fin)) >= 0); ++i)
		{
		if (l > MAXKEY)
			buff[MAXKEY] = 0;	/* use only first MAXKEY cols */
		if (i == keyrec)
			printf("%s%c%.0f\n",buff,FLAG,posn+0.0);
		if (empty(buff))
			break;
		}
	if (i == 0)
		break;
	if (--maxrec == 0)
		break;
	posn = location;
	}
flush();
close(fout);
fout = dup(1);
fbuf[0] = pipeb[0];
close(pipeb[1]);
location = 0;
while ((l=readline(buff,fbuf)) > 0)
	{
	for (p=buff+l; *--p != FLAG; )
		;
	++p;
	n = atof(p);
	lseek(fin[0],n,0);
	fin[1] = 0;
	while ((l=readline(buff,fin)) >= 0)
		{
		printf("%s\n",buff);
		if (empty(buff))
			break;
		}
	}
flush();
closeall();
while (wait(&status) >= 0)
	;
}

empty(str) char *str;
{
register char *p, *s;


if (endflag)
	{
	for (p=str,s = endflag; *p && *s; )
		{
		if (*p++ != *s++)
			return(0);
		}
	return(*s == 0);
	}
for (p=str; *p; ++p)
	if (*p != ' ')
		return(0);
return(1);
}

readline(str,buffer) char *str; int *buffer;
{
register char *p;
register int c;
extern int fin[];

for (p=str; (c = getc(buffer)) > 0; )
	{
	if (buffer == fin)
		{
		++location;
		if (location == 0)
			err("file too big for fmtsort");
		}
	if (c == '\n')
		{
		*p = 0;
		return(p-str);
		}
	*p++ = c;
	}
return(-1);
}
