#
/*
 * filecp: program to copy a UNIX Version 6 filessystem and
 * output the files found or requested.
 * this may be used under RT-11 (with UNIX emulation) or
 * possibly under UNIX Version 7.
 * synopsis: filecp /dev/filesys [-t] [-r] [-l] [-c] [-o] file1 file2 ...
 * -t	trace actions
 * -m	make directories as needed
 * -v	verbose, say what we are doing
 * -d	don't set date (via mdate)
 * -r	recurse thru directories
 * -l	list (a la ls -l -i)
 * -c	copy into same name in current directory
 * -o	output into file with the same last name
 * file1 etc. are files to look for (or directories if -r specified)
 * note that unless the super user runs this program (or it is setuid to ROOT)
 * the group and user id's of the resulting files will be those of the user
 * running the program.
 *
 * to make it: cc filecp.c -lw
 */
#define	ROOT	1

#define	BUFFSIZE	512
#define	MAXNAME	64
#define	DIRSIZE	16

struct stat
{
char s_minor;
char s_major;
int s_inumber;
int s_flags;
char s_nlinks;
char s_uid, s_gid;
char s_size0;
int s_size1;
int s_addr[8];
int s_actime[2];
int s_modtime[2];
} statb;

struct dir
{
int d_inode;
char d_name[14];
};

struct inode
{
int i_flags;
char i_nlinks;
char i_uid, i_gid;
char i_size0;
int i_size1;
int i_addr[8];
int i_actime[2];
int i_modtime[2];
} ;
#define	I_ALLOC	0100000
#define	I_TYPE	060000
#define		I_FILE	000000
#define		I_DIR	040000
#define		I_CHAR	020000
#define		I_BLOCK	060000
#define	I_LARGE	010000
#define	I_SETUID	04000
#define	I_SETGID	02000
#define	I_STICKY	01000
#define	I_MODES	0777
#define	CR_MASK	(I_SETUID|I_SETGID|I_STICKY|I_MODES)


int indirblk;
int indirbuff[256];
int outfile 1;
int oflg;			/* output to short name of file */
int vflg;			/* verbose */
int mflg;			/* make directories as needed */
int dflg;			/* suppress setting of modification time */
int cflg;			/* copy the file into same name */
int rflg;			/* recursive decent */
int tflg;			/* tracing */
int lflg;			/* list directory */
int fsdes;
char *filesys, *namep;
char buff[512];
int curdir ROOT;
long itol();


main(argc,argv) char **argv;
{
struct inode inode;
register int i;
char *name;

--argc;
++argv;

if (argc < 2)
	err("usage: filecp filesys files");
filesys = *argv++;
--argc;
if ((fsdes = open(filesys,0)) < 0)
	err("can't open %s",filesys);
while (argc > 0)
	{
	name = *argv++;
	--argc;
	if (*name == '-')
		{
		switch(*++name)
			{
		case 'v':
			++vflg;		/* verbose */
		case 'm':		/* make directories */
			++mflg;
			break;
		case 'd':		/* suppress date setting via mdate */
			++dflg;
			break;
		case 'r':		/* recurse thru directories */
			++rflg;
			break;
		case 't':		/* table of contents (like ls) */
			++tflg;
			break;
		case 'l':		/* long form (like ls -l) */
			++lflg;
			printf(
"inode  access  links  uid  gid    len  name\n");
			break;
		case 'o':	/* output to file (last part of path name) */
			++oflg;
			++cflg;		/* copy mode */
			break;
		case 'c':		/* copy files into same name */
			++cflg;
			break;
			}
		continue;
		}
	if (!(cflg || lflg))
		++lflg;			/* default to lflg */
	namep = name;
	if (*namep == '/')
		{
		++namep;
		i = ROOT;
		}
	else
		i = curdir;
	if (( i = locate(i,namep)) == 0)
		err("no %s",name);
	getinode(i,&inode);
	if (lflg)
		{
		list(i,&inode,0,name);
		continue;
		}
	if (cflg)
		cpfile(i,&inode,namep);
	}
}

cpfile(inumber,inode,name) struct inode *inode;
{
register int l, blk;
register int i;
int mode;
char *p;

if (tflg)
	printf("cpfile %s\n",name);
if ((inode->i_flags&I_TYPE) == I_DIR)
	{
	if (rflg)
		cpdir(inumber,inode,name);
	else
		err("%s is a directory",name);
	return;
	}
p = name;
if (oflg)
	p = last(p);
else
	if (*p == '/')
		++p;	/* create in current directory */
mode = (inode->i_flags&CR_MASK);
if (vflg || tflg)
	printf("creat %s @ %o\n",p,mode);
if ((outfile = creat(p,mode)) < 0)
	err("can't creat %s",p);
for (blk = 0; (l = readfile(inode,blk,&buff)) > 0; ++blk)
	{
	if (write(outfile,&buff,l) != l)
		err("write error");
	}
if (cflg)
	{
	close(outfile);
	chown(p,(inode->i_uid<<8) | (inode->i_gid&0377));
	if (!dflg)
		mdate(p,inode->i_modtime);
	}
}

cpdir(inumber,inode,name) struct inode *inode;
{
register int i;
int l;
int blk;
int mode;
register char *p;
register char *d;
struct inode newinode;
char *buffp;
char newname[MAXNAME];

if (tflg)
	printf("cpdir %s\n",name);
buffp = getbuff();
if (mflg && !oflg && stat(name,&statb) < 0)
	{
	if (vflg || tflg)
		printf("mkdir %s\n",name);
	mkdir(name);
	}
for (blk = 0; (l = readfile(inode,blk,buffp)) > 0; ++blk)
	{
	for (i=0; i<l; i =+ DIRSIZE)
		{
		d = buffp+i;
		if (d->d_inode == 0 || d->d_name[0] == '.')
			continue;
		copy(newname,name);
		p = endstr(newname);
		if (p[-1] != '/')
			*p++ = '/';
		move(14,d->d_name,p);
		p[14] = 0;
		getinode(d->d_inode,&newinode);
		cpfile(d->d_inode,&newinode,newname);
		}
	}
freebuff(buffp);
}

getbuff()
{
return(alloc(BUFFSIZE));
}

freebuff(ptr) char *ptr;
{
free(ptr);
}
readfile(inode,block,buffer) char *buffer; struct inode *inode;
{
/*
 * from file corresponding to inode "inode" read logical
 * block "block" into "buffer"
 * return 512 unless last block is being read.
 */
long bsize, size;
register int l;

bsize = itol(block>>(16-9),block<<9);
size = itol(inode->i_size0&0377,inode->i_size1);
if (bsize >= size)
	return(0);
readmapped(inode,block,buffer);
if (bsize >= size-512)
	l = size-bsize;
else
	l = 512;
return(l);
}



readmapped(inode,block,buffer) struct inode *inode;
int *buffer;
{
/*
 * read logical block "block" from file corresponding to "inode"
 * mapping logical to physical blocks.
 * result is returned into "buffer".
 * note that HUGE files are not supported.
 */
register int indir, off;
register struct inode *i;
extern int ldivr;
int old;

old = block;
i = inode;
if (i->i_flags & I_LARGE)
	{
	off = ldiv(0,block,256);
	if (off >= 7)
		err("HUGE files not implemented");
	indir = i->i_addr[off];
	off = ldivr;
	if (indir != indirblk)
		{
		if (tflg)
			printf("indirect block ");
		readblock(indir,indirbuff);
		indirblk = indir;
		}
	block = indirbuff[off];
	}
else
	{
	if (block >= 8)
		err("invalid small block number %d",block);
	block = i->i_addr[block];
	}
if (tflg)
	printf("block %d mapped to %d\n",old,block);
return(readblock(block,buffer));
}

readblock(block,buffer)
char *buffer;
{
/*
 * read block "block" into "buffer" from the file system.
 */
if (tflg)
	printf("read block %d\n",block);
seek(fsdes,block,3);
if (read(fsdes,buffer,512) != 512)
	err("error reading block %d",block);
return(512);
}

getinode(inumber,inode) struct inode *inode;
{
register int blk;
register int off;

if (tflg)
	printf("get inode %d\n",inumber);
blk = (inumber+31)/16;
off = ((inumber+31)%16) *32;
readblock(blk,buff);
move(32,buff+off,inode);
if ((inode->i_flags&I_ALLOC) == 0)
	err("i-node %d not allocated",inumber);
}

locate(inumber,path) char *path;
{
/*
 * locate is given a path and an inode number to search for that
 * path name. 
 * it first locates the inode from the inumber.
 * it then reads the directory and searches for the given
 * partial path name (via scan).
 * if there is a slash in the path it then recursively calls
 * itself to parse the next level in the path.
 * it returns when there are no more slashes in the path it is
 * passed or if it cannot find a partial path entry in a directory.
 * it returns the inode number when it finds the proper entry.
 * it doesn't check that all partial paths before slashes are
 * directories but then neither does glob. try ls /unix/*junk* sometime.
 */
register char *p;
register char *b;
register int l;
struct inode inode;
int i;
int block;

if (tflg)
	printf("locate path %s in inode %d\n",path,inumber);
while (*path == '/')
	++path;
if (*path == 0)
	return(inumber);
p = any(path,"/");
getinode(inumber,&inode);
for  (block=0; (l = readfile(&inode,block,&buff)) >= 0; ++block)
	{
	b = &buff;
	for (i=0; i<l; i=+ 16)
		{
		if (b->d_inode && scan(path,b->d_name))
			{
			if (p)
				return(locate(b->d_inode,p+1));
			return(b->d_inode);
			}
		b =+ 16;
		}
	}
return(0);
}

last(path)
char *path;
{
/*
 * return the last part of the file path after the last "/".
 */
register char *p, *q;

for (p=path; q = any(p,"/"); p = q+1)
	;
return(p);
}

scan(path,dir) char *path, *dir;
{
register int i;
register int p, d;

for (i=0; i<14; ++i)
	{
	p = *path++;
	d = *dir++;
	if ((p == '/' || p == 0) && d == 0)
		return(1);
	else if (p != d)
		return(0);
	}
return(1);
}

char listbuff[512];
char listblk;
list(inumber,inode,level,nm) struct inode *inode; char *nm;
{
/*
 * do a ls style output of the information in an inode "inode".
 * "inumber" is the inode's number.
 * "level" is the depth into list we have gone.
 * "nm" is the name of the file we are ls'ing.
 */
register int block;
struct inode lnode;
register int i, l;
char *b;

printf("%5d %s %3d %4d %4d %6l  %s\n",inumber,prmode(inode->i_flags),
	inode->i_nlinks&0377,inode->i_uid&0377,inode->i_gid&0377,inode->i_size1,nm);
if (rflg && (inode->i_flags&I_TYPE) == I_DIR)
	{
	printf("\n");
	for (block = 0; (l = readfile(inode,block,listbuff)) > 0; ++block)
		{
		listblk = block;
		b = listbuff;
		for (i=0; i<l; i =+ 16)
			{
			if (listblk != block)
				readfile(inode,listblk = block,listbuff);
			if (b->d_inode && b->d_name[0] != '.')
				{
				getinode(b->d_inode,&lnode);
				list(b->d_inode,&lnode,1+level,b->d_name);
				}
			b =+ 16;
			}
		}
	listblk = -1;
	}
if (tflg)
	printf("%d return from list\n",level);
}
