#include <stdio.h>
#include <math.h>

double expr(), getitem(), atof();
char *getarg();
int argc; char **argv;
char *outfmt = "%g";

main(targc,targv) char **targv;
{
double f;
register char *argp;

argc = targc-1;
argv = targv+1;
if (argc == 0)
	exit(1);
argp = argv[0];
if (argp[0] == '-' && argp[1] == 'f')
	{
	outfmt = argp+2;
	--argc; ++argv;
	}
f = expr();
printf(outfmt,f);
printf("\n");
exit(0);
}

double expr()
{
register int op;
double f1, f2;
double fmod();

f1 = getitem();
while ((op = getop()) && op != ')')
	{
	f2 = getitem();
	switch(op)
		{
	case '+':
		f1 += f2;
		break;
	case '-':
		f1 -= f2;
		break;
	case '*':
		f1 *= f2;
		break;
	case '/':
		f1 /= f2;
		break;
	case '%':
		f1 = fmod(f1,f2);
		break;
	case '^':
		f1 = exp(log(f1) * f2);
		break;
	default:
		err("fexpr: bad operator %c",op);
		}
	}
if (op == ')')
	ungetarg();
return(f1);
}

double getitem()
{
register char *p;
double f;

p = getarg();
switch(p[0])
	{
case '-':
case '+':
	if (p[1] == 0)
		return(getitem());
case '0':
case '1':
case '2':
case '3':
case '4':
case '5':
case '6':
case '7':
case '8':
case '9':
case '.':
	f = atof(p);
	break;
case '(':
	f = expr();
	if (*getarg() != ')')
		err("fexpr: ')' expected");
	break;
default:
	err("fexpr: bad syntax '%s'",p);
	}
return(f);
}
	

getop()
{
register char *p;

p = getarg();
return(*p);
}

char *getarg()
{
static cnt = 0;

if (++cnt > 1000)
	err("fexpr: internal error");
if (argc-- < 0)
	return("");
return(*argv++);
}

ungetarg()
{
++argc; --argv;
}
