#
char name[58];
int status;
int sflg;
int magic;
int size 578;		/* size of a DEC-tape */
int yflg, kflg;
int no;
int dt, tape;
char buff[4096];
#define	UNITNO	8
char dtname[] "/dev/tap0";
char flname[] "/dev/rrx0";
char dkname[] "/dev/rrk0";
char rotate[10];		/* rotated names */
char *rptr;			/* current rotated name */

char *tpname dtname;

struct fsdir
{
int d_magic;
int d_no;
char d_name[58];
char d_ids[2];
int d_sdate[2];
int d_vers;
int d_mdate[2];
int d_flags;
int d_size[2];
} fsdir;

int namecnt;			/* number of names in table */
#define	MAXNAMES	512
char *names[MAXNAMES];	/* table of file names */

main(argc,argv) char **argv;
{
register int vers;
register int l;
register char *argp;
int oldunit;
extern int fout;

--argc;
++argv;
while (--argc >= 0)
	{
	doarg(*argv++);

	}
tape = open("/dev/rmt0",2);
if (tape < 0)
	err("can't open /dev/rmt0");
fout = dup(1);
while ((l=read(tape,&fsdir,sizeof fsdir)) > 0)
	{
	no = fsdir.d_no;
	magic = fsdir.d_magic;
	printf("%d: %s\n",fsdir.d_no,fsdir.d_name);
	flush();
	if (fsdir.d_name[0] == ' ')
		unlink(&fsdir.d_name[18]);
	store(fsdir.d_name);
	fsf(1);
	}
if (l < 0)
	err("reading tape");
bsf(1);
/*
 * now at logical end of tape. start writing the new files.
 */
while (getname())
	{
	while (wait(&status) != -1)
		;
	vers = getvers(name);
	if (vers > 1)
		{
		printf("version %d\n",vers);
		flush();
		}
	clear(&fsdir,sizeof fsdir);
	fsdir.d_magic = magic;
	fsdir.d_no = ++no;
	copy(fsdir.d_name,name);
	if ((dt=open(tpname,0)) < 0)
		err("no %s",tpname);
	oldunit = tpname[UNITNO];
	if (sflg)
		{
		++tpname[UNITNO];
		if (tpname[UNITNO] == '8')
			tpname[UNITNO] = '0';
		}
	if (rptr)
		{
		if (*rptr == 0)
			rptr = rotate;
		tpname[UNITNO] = *rptr++;
		}
	if (tpname == flname)
		size = (tpname[UNITNO]&02) ? 1001: 500;
	fsdir.d_vers = vers;
	fsdir.d_flags = 0666;
	time(fsdir.d_sdate);
	time(fsdir.d_mdate);
	fsdir.d_size[0] = hmul(size,512);
	fsdir.d_size[1] = size*512;
	if(write(tape,&fsdir,sizeof fsdir) <= 0)
		err("writing tape directory");
	store(fsdir.d_name);
	if (!dtcopy(size))
		{		/* back up over bad copy */
		tpname[UNITNO] = oldunit;
		if (rptr)
			--rptr;
		--namecnt;
		--no;
		wtm(1);
		bsf(1);
		bsf(1);
		wtm(1);
		}
	else
		wtm(1);
	if (tpname == dtname && fork() == 0)
		{
		close(tape);
		seek(dt,0,0);
		read(dt,&fsdir,2);
		putchar(07);
		exit(0);
		}
	close(dt);
	}
wtm(3);
rew();
}

dtcopy(blocks)
{
register int len, l;
int blk;
register int i;
char ans[20];

for (blk=0; blocks > 0; )
	{
	len = blocks;
	if (len > 8)
		len = 8;
	if ((l = read(dt,buff,len*512)) < 0)
		{
		printf("error reading %s blocks %d ... %d will try incrementally\n",tpname,blk,blk+len-1);
		for (i=0; i<len; ++i)
			{
			seek(dt,i+blk,3);
			if (read(dt,buff+i*512,512) < 0)
				{
				printf("read error %s block %d\n",tpname,i+blk);
				printf("ignore error? ");
				flush();
				if (readline(ans) <= 0 || ans[0] != 'y')
					return(0);
				}
			}
		l = len * 512;
		}
	if (write(tape,buff,l) <= 0)
		err("writing mt");
	blocks =- len;
	blk =+ len;
	}
return(1);
}

bsf(n)
{
dostty(2,n);
}

fsf(n)
{
dostty(1,n);
}

wtm(n)
{
dostty(0,n);
}

dostty(fn,n)
{
int arg[3];

arg[0] = fn;
arg[1] = n;
if (stty(tape,arg) < 0)
	err("stty error");
}

getname()
{
register int l;

for (;;)
	{
	if (sflg)
		printf("%c:",tpname[UNITNO]);
	putchar('*');
	flush();
	if (readline(name) <= 0)
		return(0);
	if (name[0] == '-')
		doarg(name);
	else if (name[0] == '!')
		system(name+1);
	else if (any(name," *[]?\\"))
		printf("illegal character in file name\n");
	else 
		return(1);
	}
}

rew()
{
dostty(5,1);
}

store(ptr) char *ptr;
{
register int l;
register char *p;

l = length(ptr);
p = alloc(l+1);
copy(p,ptr);
names[namecnt++] = p;
return(p);
}

getvers(ptr) char *ptr;
{
register int vers;
register int i;

vers = 1;
for (i=0; i<namecnt; ++i)
	if (equal(names[i],ptr))
		++vers;
return(vers);
}

doarg(argp) char *argp;
{
while (*argp)
	{
	switch(*argp++)
		{
	case 'd':
		tpname = dtname;
		size = 578;
		break;
	case 'y':
		tpname = flname;
		size = 1001;
		break;
	case 'k':
		tpname = dkname;
		size = 4872;
		break;
	case '-':
		break;
	case 'r':
		rptr = rotate;
		while (*argp)
			*rptr++ = *argp++;
		break;
	case 's':
		++sflg;
		break;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
		tpname[UNITNO] = argp[-1];
		break;
	default:
		err("invalid option");
		}
	}
}
