#include <stdio.h>
#include <grp.h>

#define	NONE	-1

FILE *_grf;

getgrnam(name) char *name;
{
register struct group *p;

setgrent();
while (p = getgrent())
	if (strcmp(name,p->gr_name) == 0)
		return(p);
return(NULL);
}

getgrgid(id)
{
register struct group *p;

id =& 0377;		/* insure only 8 bit id */
setgrent();
while (p = getgrent())
	if (p->gr_gid == id)
		return(p);
return(NULL);
}

setgrent()
{
if (_grf != NULL)
	fseek(_grf,(long) 0,0);
}

endgrent()
{
if (_grf != NULL)
	fclose(_grf);
_grf = NULL;
}

getgrent()
{
	register char *p;
	register c;
	register char **q;
	static struct group group;
	static char line[256];
	static char *idvec[50];

	if (_grf == NULL)
		if ((_grf = fopen("/etc/group","r")) == NULL)
			return(NULL);
	p = line;
	while((c=getc(_grf)) != '\n') {
		if(c <= 0)
			return(0);
		if(p < line+(sizeof line)-2)
			*p++ = c;
	}
	*p = 0;
	p = line;
	group.gr_name = p;
	p = grskip(p,':');
	group.gr_passwd = p;
	p = grskip(p,':');
	group.gr_gid = atoi(p);
	p = grskip(p,':');
	grskip(p,':');
	for (group.gr_mem = q = idvec; *p; p = grskip(p,','))
		*q++ = p;
	*q++ = 0;
	return(&group);
}

grskip(ap,delim)
char *ap;
{
	register char *p;

	p = ap;
	while(*p != delim) {
		if(*p == 0)
			return(p);
		p++;
	}
	*p++ = 0;
	return(p);
}

#ifdef DEBUG
main()
{
register struct group *p;
register char **q;

while (p = getgrent())
	{
	printf("group=%s gid=%d passwd=%s ids=",p->gr_name,p->gr_gid,p->gr_passwd);
	for (q=p->gr_mem; *q; ++q)
		printf("%s ",*q);
	printf("\n");
	}
}
#endif
