#include "rtunix.h"
/*		Copyright 1976 by Bill Webb. 		*/

#define	SWS	0177570		/* hardware switch register */
#define	ECHO	010	/* stty echo bit */
#define	SPTTY	010000	/* rt-11 special tty mode bit */

getcsw()
{
return(SWS->INT);
}

chdir(path)
char *path;
{
top;
seterr(ENOTDIR);
}

unlink(path)
char *path;
{
register struct file *f;

top;
#ifdef	debug
	_trace("unlink('%s')",path);
#endif
f = _newfile();
_cvtname(path,f->f_dev);
if(rtdelete(f->f_chan,f->f_dev) == -1)
	seterr(ENOENT);
return(0);
}

link(path,path2)
char *path, path2;
{
register struct file *f;
int dev[4];
int dev2[4];

top;
#ifdef	debug
	_trace("link('%s','%s')",path,path2);
#endif
f = _newfile();
_cvtname(path,f->f_dev);
_cvtname(path2,dev2);
if(rtrename(f->f_chan,dev,dev2) == -1)
	seterr(ENOENT);
return(0);
}


_exit(n)
{
register int i;

for (i=0; i<MAXFILE; ++i)
	if (chan_use[i])
		rtclose(i);
rtexit(0);
}


fork()
{
top;
seterr(EAGAIN);
}


sleep(n)
{
int tvec[2];

tvec[0] = hmul(n,60);
tvec[1] = n * 60;
rttwait(tvec);
}

getpid()
{
return(63);
}

getuid()
{
return(3);
}

getgrp()
{
return(3);
}

kill(pid,sig)
{
err("can't kill");
}

nice(n)
{
}

sync()
{
}

brk(addr)
char *addr;
{
register char *lasttop;
register int l;
extern end;

top;
if(addr&1)
	++addr;
lasttop = r_top;
if(addr < &end || addr > r_mon || rtsettop(addr) != addr)
	seterr(ENOMEM);
l = addr - lasttop;
if(l > 0)
	_clear(lasttop,l);
return(lasttop);
}

chmod(path,mode)
char *path;
{
return(0);
}
chown(path,owner)
char *path;
{
return(0);
}

wait(status)
int *status;
{
top;
seterr(ECHILD);
}

ttyn(des)
{
return('8');
}

char *_sptr &end;
sbrk(n)
{
register char *oldptr;

if(n&1)
	++n;
oldptr = _sptr;
brk(_sptr =+ n);
return(oldptr);
}

gtty(des,v)
int *v;
{
register struct file *f;
register int *i;

top;
f = _getf(des);
if(f->f_type != TTY)
	seterr(ENOTTY);
i = v;
*i++ = (7<<8)+7;
*i++ = 0;
*i = 020 + 04 + 02;	/* -nl  -lcase xtab */
if ((r_jsw & SPTTY) == 0)
	*i =+ ECHO;
return(0);
}

stty(des,v)
int *v;
{
register struct file *f;

top;
f = _getf(des);
if(f->f_type != TTY)
	seterr(ENOTTY);
if ((v[2] & ECHO) == 0)
	r_jsw =| SPTTY;
else
	r_jsw =& ~SPTTY;
return(0);
}

smdate()
{
}
