#include "rtunix.h"
/*		Copyright 1976 by Bill Webb. 		*/

char *_radaddr;
_newfile()
{
register int i;
register int j;

for (i=0; i<MAXFILE; ++i)
	if(_files[i].f_type == FREE)
		{
		for (j=0; j<MAXFILE; ++j)
			{
			if(chan_use[j] == 0)
				{
				_files[i].f_chan = j;
				return(&_files[i]);
				}
			}
		break;
		}
seterr(EBADF);
}

_getf(des)
{
register int i;

if((i=des) < 0 || i>= MAXFILE || _fdes[i]==0)
	seterr(EBADF);
return(_fdes[i]);
}


_newdes()
{
register int i;

for (i=0; i<MAXFILE; ++i)
	if(_fdes[i] == 0)
		return(i);
seterr(EMFILE);
}

open(path,how)
{
register struct file *f;
register int n;

top;
#ifdef	debug
	_trace("open('%s',%d)",path,how);
#endif
f = _newfile();
n = _newdes();

_cvtname(path,f->f_dev);
if(!_nowopen(f))
	if(rtlookup(f->f_chan,f->f_dev) == -1)
		seterr(ENOENT);
f->f_type = FILE;
++f->f_cnt;
_fdes[n] = f;
f->f_howopen = how;
++chan_use[f->f_chan];
return(n);
}

creat(path,how)
char *path;
{
register struct file *f;
register int n;

top;
#ifdef	debug
	_trace("creat('%s',%o)",path,how);
#endif
f = _newfile();
n = _newdes();

_cvtname(path,f->f_dev);
if(!_nowopen(f))
	if(rtenter(f->f_chan,f->f_dev,0) == -1)
		seterr(ENOENT);
f->f_type = FILE;
++f->f_cnt;
_fdes[n] = f;
f->f_howopen = -1;
++chan_use[f->f_chan];
return(n);
}

close(des)
{
register struct file *f;

top;
#ifdef	debug
	_trace("close(%d)",des);
#endif
f = _getf(des);
_fdes[des] = 0;
if(--f->f_cnt == 0)
	{
	if(--chan_use[f->f_chan] == 0)
		switch(f->f_type)
			{
		case FILE:
			if(f->f_length == 0 && f->f_howopen < 0)
				{
				++chan_use[f->f_chan];
				return(des);
				}
		case OTHER:
			rtclose(f->f_chan);
			}
	_clear(f,FSIZE);
	}
return(des);
}

dup(des)
{
register struct file *f;
register int n;

top;
#ifdef	debug
	_trace("dup(%d)",des);
#endif
f = _getf(des);
n = _newdes();
_fdes[n] = f;
++f->f_cnt;
return(n);
}


char *_devptr _devspc;

_fetch(dev)
int *dev;
{
/*
 * _fetch the rt11 driver for the particular device if it is 
 * not already in memory.
 */
struct 
{
int d_status;
int d_size;
char *d_entry;
int d_block;
} d;

if(rtdstatus(&d,dev) == -1)
	seterr(ENOENT);
if(d.d_entry == 0)
	{
	if(_devptr + d.d_size > _devspc + MAXDEV)
		err("no room");
	_devptr = rtfetch(dev,_devptr);
	if(_devptr < _devspc || _devptr > _devptr + MAXDEV)
		err("bad fetch");
	}
}

_cvtname(path,dev)
char *path;
int *dev;
{
/*
 * convert the unix path name in "path" into a rt-11 devblk in "dev".
 *
 * /tmp/name ==> name.tmp
 * .../name ==> name 
 * /dev/name ==> na:
 * /xxx:name ==> xxx:name
 */

register int *d;
register char *p, *s;
char devname[4];

d = dev;
p = path;
_clear(d,8);
if(_eq(p,"/dev/"))
	{
	p =+ 5;
	devname[0] = *p++;
	devname[1] = *p++;
	devname[2] = ('1' <= *p && *p <= '7') ? *p : 0;
	*d = _radpk(devname);
	goto done;
	}
d[0] = DK;
if(_eq(p,"/tmp/"))
	d[3] = TMP;
else if (*p == '/')
	{
	d[0] = _radpk(++p);
	p = _radaddr;
	if (*p == ':')
		++p;
	}
s = p;
++d;
while (*p)
	if(*p++ == '/')
		s = p;
*d++ = _radpk(s);
*d++ = _radpk(_radaddr);
s = _radaddr;
if(*s++ == '.')
	*d = _radpk(s);
done:
	;
#ifdef	debug
	_trace(" %s --> %o %o %o %o",path,d[-3],d[-2],d[-1],d[0]);
#endif
}

_nowopen(file)
struct file *file;
{
register struct file *f;
register struct file *g;
register int i;

f = file;
for (g=_files; g<_files+MAXFILE; ++g)
	{
	if(f == g)
		continue;
	for (i=0; i<4; ++i)
		if(f->f_dev[i] != g->f_dev[i])
			goto nope;
#ifdef	debug
	_trace("chan %o file in use on %o",f->f_chan,g->f_chan);
#endif
	f->f_chan = g->f_chan;
	if(g->f_cnt == 0)
		{
		--chan_use[g->f_chan];
		_clear(g,FSIZE);
		}
	return(1);
	nope:
		;
	}
_fetch(f->f_dev);
return(0);
}

_clear(buff,length)
char *buff;
{
register int l;
register char *p;

if(l = length)
	{
	p = buff;
	do
		*p++ = 0;
	while (--l);
	}
}

_eq(s1,s2)
char *s1,*s2;
{
register char c;

while (( c = *s2++) !='\0' && c== *s1++) ;
return(c=='\0');
}
