#include "rt11.h"
/*		Copyright 1976 by Bill Webb. 		*/

extern errno;
#define	YES	1
#define	NO	0
#define	MAXEMT	032
#define	MAX374	011

#define em_init 6
#define	emttrap	0
#define	iottrap	1
#define	fputrap 2
#define traptrap 3
#define	bustrap	4
#define	instrap	5
#define	segtrap	6

#define	v_trap	034		/* trap vectors for trap instn */
#define	V_BUS	4		/* trap vector for BUS trap */
#define	V_INS	10		/* trap vector for INS trap */

struct trap 
{
int *v_pc;
int v_ps;
};

struct trap trpaddr;

#define	EMT	0


run()
{
register struct emt *e;
register int i;
register int chan;
int tlevel;
/*
 * start execution of rt11 program. 
 */

setsigs(sflg);
settrap();			/* prevent issuing of unix sys calls */
setint();			/* allow attn traps */
setexit();
errno = 0;
clear(0,034);			/* clear initial trap vectors */
for (EVER)
	{
	i = transfer();
	if(u.sp < SP_MIN || u.sp > &top)
		{
		where();
		err("stack %o outside boundaries",u.sp);
		}
	switch(i)
		{
	case EMT:
		errwrd = 0;
		u.ps =& ~ C_BIT;
		emt = i = u.pc[-1] & 0377;
		chan = i & 017;
		if(i < 0340)
			{
			e = &rtemts[i>>4];
			pars[0] = chan;
			}
		else
			{
			if(i < 0360)
				{
				e = &miscemts[chan];
				}
			else
				{
				switch (i)
					{
				case 0375:
					i = u.r0->hi;
					if(i < 0 || i >= MAXEMT)
						goto bademt;
					e = &rtemts[i];
					break;

				case 0374:
					i = u.r0.hi;
					if(i < 0 || i >= MAX374)
						goto bademt;
					e = &emtminor[i];
					break;

				default:
				bademt:
					where();
					if (iflg)
						{
						printf("bad emt code %o ignored\n",i);
						break;
						}
					else
						err("bad emt code %o",i);
					}
				}
			}
		emtptr = e;
		if(e->e_rtn == 0)
			{
			where();
			if(e->e_name)
				printf(" .%s",e->e_name);
			err("emt %o not available",emt);
			}
		tlevel = e->e_flag>>1;
		if(tflg > tlevel)
			{
			where();
			printf(" .%s",e->e_name);
			}
		getpars(tflg > tlevel);
		(*e->e_rtn) (pars[0],pars[1],pars[2],pars[3],pars[4]);
		if(tflg > tlevel)
			putchar('\n');
		break;

	case traptrap:
		trpsim(v_trap,YES);
		break;

	case bustrap:
	case segtrap:		/* treat same as bus trap */
		if (trpsim(V_BUS,NO))
			break;
		else
			{
			trpaddr.v_ps = 1;		/* c set for bus */
			if (!trpsim(&trpaddr,NO))
				trpsim(V_BUS,YES);
			trpaddr.v_pc = 0;
			}
		break;
	case instrap:
		if (trpsim(V_INS,NO))
			break;
		else
			{
			trpaddr.v_ps = 0;		/* c clear for ins */
			if (!trpsim(&trpaddr,NO))
				trpsim(V_INS,YES);
			trpaddr.v_pc = 0;
			}
		break;
	default:
		err("bad trap %d",i);
		}
	}
}

nullrtn()
{
}

where()
{
if(u.pc)
	printf("at %6o",u.pc);
}

getpars(flag)
{
register struct emt *e;
register int *p;
register int *q;
int i;

p = pars;
e = emtptr;

switch(emt)
	{
case 0375:
	q = u.r0;
	*p++ = q->lo;
	++q;
	for (i=0; i< e->e_args; ++i)
		*p++ = *q++;
	break;

case 0374:
	*p++ = u.r0.lo;
	break;

default:
	if(emt < 0340)
		++p;
	for (i=0; i < e->e_args; ++i)
		{
		if(i == 0 && (e->e_flag&SPFLAG) == 0)
			*p++ = u.r0;
		else
			*p++ = *u.sp++;
		}
	}
if(flag)
	{
	for (q = pars; q < p; )
		printf(" %o",*q++);
	}
while (p < pars + 5)
	*p++ = 0;
}

trpset(chan,addr)
{
trpaddr.v_pc = addr;
}

trpsim(tvec,flag) char *tvec;
{
if(tvec->v_pc)
	{
	if(tflg)
		{
		where();
		printf(" trap thru %o to %o %o",tvec,tvec->v_pc,tvec->v_ps);
		}
	*--u.sp = u.ps;
	*--u.sp = u.pc;
	u.ps = tvec->v_ps;
	u.pc = tvec->v_pc;
	return(YES);
	}
else if (!flag)
	return(NO);
else
	{
	where();
	err(" trap to %o ",tvec);
	}
}
