#include "rt11.h"
/*		Copyright 1976 by Bill Webb. 		*/

#define	FMASK	060000
#define	FILE	0

rtprint(msg)
char *msg;
{
register char *p;

if(tflg)
	putchar(' ');
p = msg;
while (*p & 0177)
	putchar(*p++);
if(*p == 0)
	putchar('\n');
}

rtenter(chan,dev,length)
struct devblk *dev;
{
/*
 * enter the given device name from the directory.
 */
register struct chan *c;

c = &channels[chan];
if(c->c_state != FREE)
	return(seterr(0));
if(!cvtfile(dev,path) ||
	(c->c_des = cropen(path,0666)) < 0)
	return(seterr(1));
if(tflg)
	printf(" ==> %d",c->c_des);
c->c_state = OPEN;
c->c_length = length;
return(OK);
}

seterr(n)
{
if(csiflg)
	return(0);
errwrd = n;
if(tflg)
	printf(" err %o\n",n);
u.ps =| C_BIT;
reset();
}


rtlookup(chan,dev)
struct devblk *dev;
{
register struct chan *c;
register int i;

c = &channels[chan];
if(c->c_state != FREE)
	return(seterr(0));
if(cvtfile(dev,path))
	{
	if (path[0] != '/')
		{
		copy(path2,"/usr/rt11/");
		append(path2,path);
		}
	else
		path2[0] = 0;
	if ((i = open(path,2)) >= 0 || (i = open(path,0)) >= 0
		|| (path2[0] && (i = open(path2,0) >= 0)))
		{
		c->c_des = i;
		errno = 0;
		if(tflg)
			printf(" ==> %d",i);
		c->c_state = OPEN;
		return(OK);
		}
	}
return(seterr(1));
}

rtrename(chan,dev)
int *dev;
{
register struct chan *c;

c = &channels[chan];
if(c->c_state != FREE)
	seterr(0);
if(!cvtfile(dev,path) || !cvtfile(dev =+ 3,path2) ||
	!file(path) ||
	link(path,path2) < 0 || unlink(path) < 0)
	seterr(1);
if(tflg)
	printf(" rename %s to %s",path,path2);
}

rtread(chan,blk,buffer,cnt,code)
char *buffer;
char *code;
{
register struct chan *c;
register int l;
register int n;

c = &channels[chan];
if(c->c_state != OPEN)
	seterr(2);
#ifdef	debug
if(buffer&1)
	err("buffer address is odd");
#endif
seek(c->c_des, blk, 3);
n = cnt << 1;
if((l = read(c->c_des, buffer, n)) < 0)
	seterr(1);
if(l == 0)
	seterr(0);
if(l != n)
	clear(buffer + l, n-l);
if(code > 1)
	{
	*--u.sp = u.pc;
	u.pc = code;
	}
else
	u.r0 = cnt;
}

rtwrite(chan,blk,buffer,cnt,code)
char *buffer;
char *code;
{
register struct chan *c;
register int l;
register int des;

c = &channels[chan];
if(c->c_state != OPEN)
	seterr(2);
#ifdef	debug
if(buffer&1)
	err("buffer address is odd");
#endif
des = c->c_des;
seek(des, blk, 3);
l = cnt << 1;
if(!zflg)
	l = nulltrim(buffer,l);
if((l = write(des, buffer, l)) < 0)
	seterr(1);
if(code > 1)
	{
	*--u.sp = u.pc;
	u.pc = code;
	}
}

rtwait(chan)
{
register struct chan *c;

c = &channels[chan];
if(c->c_state != OPEN)
	seterr(0);
}

rtdelete(chan,dev)
struct devblk *dev;
{
register struct chan *c;

c = &channels[chan];
if(c->c_state != FREE)
	seterr(0);
if(!cvtfile(dev,path)  || !file(path) || unlink(path) < 0)
	seterr(1);
}

file(name)
{
if(stat(name,&statb) < 0 || (statb.s_flags & FMASK) != FILE)
	return(0);
return(1);
}

char lastchar;

ttyin()
{
register char c;

if(u.r0 = lastchar)
	goto done;
c = getchar() & 0177;
if(c == 0)
	exit(0);		/* exit on unix eof */
lastchar = c;
if(c == '\n' && !cflg)
	{
	u.r0 = '\r';
	}
else
	{
	if( (j.j_jsw & J_LC)==0 && c >= 'a' && c <= 'z')
		c =- 'a' - 'A';
	u.r0 = c;
done:
	lastchar = 0;
	}
if(tflg > 1)
	printf(" ==> '%c' %o",u.r0,u.r0);
if(u.r0 == 03)
	exit(1);		/* exit upon control-c */
}

ttyout(c)
{
if(tflg>1)
	putchar(' ');
putchar(c);
}


rtclose(chan)
{
register struct chan *c;

c = &channels[chan];
if(c->c_state == OPEN)
	close(c->c_des);
clear(c, CSIZE);
}

rtexit(how)
{
exit(0);
}

restart()
{
if(j.j_jsw&j_reenter)
	u.pc = j.j_pc-1;		/* the restart address */
else
	exit(0);
}


settop(addr)
char *addr;
{
if(addr > &top)
	j.j_top = &top;
else
	j.j_top = addr;
u.r0 = j.j_top;
}

nulltrim(buffer,length)
char *buffer;
{
register int l;
register char *p;

l = length;
p = buffer + l;
while (l > 0 && *--p == 0)
	--l;
return(l);
}

sreset()
{
register int i;

for (i=0; i<MAXCHAN-1; ++i)	/* excluding channel 017 from close */
	if(channels[i].c_state != FREE)
		rtclose(i);
}

savestatus(chan,info)
int *info;
{
register int *i;
register struct chan *c;

i = info;

c = &channels[chan];
if(c->c_state != OPEN)
	seterr(0);
getlength(c);
*i++ = c->c_state;
*i++ = c->c_des;
*i++ = c->c_length;
*i++ = 0;
*i++ = 0;
clear(c,CSIZE);
}

reopen(chan,info)
int *info;
{
register struct chan *c;
register int *i;

i = info;
c = &channels[chan];
if(c->c_state != FREE)
	return(seterr(0));
if(tflg>1)
	printf(" ==> %o %o %o %o %o",i[0],i[1],i[2],i[3],i[4]);
c->c_state = *i++;
c->c_des = *i++;
c->c_length = *i++;
}

getlength(chan)
struct chan *chan;
{
register struct chan *c;
extern ldivr;

c = chan;
if(fstat(c->c_des,&statb) < 0)
	seterr(0);
c->c_length = ldiv(statb.s_size0,statb.s_size1,512);
if(ldivr)
	c->c_length++;
}

cropen(name,mode)
char *name;
{
register int i;

if((i = creat(name,mode)) >= 0)
	{
	if(fstat(i,&statb) >= 0 && (statb.s_flags&060000))
		return(i);		/* its a device of some sort */
	close(i);
	if((i = open(name,2)) >= 0)
		return(i);
	}
return(-1);
}

rtchain()
{
/*
 * chain to another rt-11 program.
 * 500...507 contain a devblk of the rtn to run
 * 510...777 contain parameters for the routine to run
 */

if(!cvtfile(chaindev,path))
	err("bad name");

load(path);

j.j_jsw =| J_CHAIN;
}

rtgtjb(chan,p) int *p;
{
/*
 * return info about the job.
 */
register int *q;

q = p;
*q++ =  0;		/* background */
*q++ = 0;		/* low limit */
*q++ = j.j_top;		/* top of memory */
*q++ = 0;
*q++ = 0;
*q++ = 0;
*q++ = 0;
*q++ = 0;
}

gttime(chan,addr)
long *addr;
{
int tvec[2];
long hmul();
register int *i;

time(tvec);
i = localtime(tvec);
r_date = (1+i[4] << 10) | (i[3] << 5) | (i[5] - 72);
*addr = hmul(i[2]*60+i[1],3600);
dpadd(addr,i[0]*60);
if (tflg)
	{
	i = addr;
	printf(" %o %o",i[0],i[1]);
	}
}
