#include "rt11.h"
/*		Copyright 1976 by Bill Webb. 		*/

int spflag 1;			/* in special mode do lookups */
char *csi;
int *swspc buff+256;		/* use the rest of the buffer */
int swcnt;
int *csisws;			/* pointer to switch space */
int csigot;			/* if we got a csi specification */
int csiout;			/* if = or < specified in the string */

csiget(name,length)
char *name;
{
register char *n;
register int len;
register int c;

n = name;
len = length;
while ( ((c = *csi) >= 'A' && c <= 'Z') ||
	(c >= '0' && c <= '9'))
	{
	++csi;
	++csigot;
	if(--len >= 0)
		*n++ = c;
	}
while (--len >= 0)
	*n++ = ' ';
}

csioct()
{
register int n;
register int c;

n = 0;
while ((c = *csi) >= '0' && c <= '7')
	{
	++csi;
	n = n * 8 + c - '0';
	}
return(n);
}

struct devblk devblk;

csifile(fileno,dext)
{
char dev[3];
char file[6];
char ext[3];
register int *p;
register int sws;
register char *ptr;

p = &devblk;
csigot = 0;
ptr = csi;
if(tflg>1)
	printf(" ==> %.10s",csi);
csiget(dev,3);
if(*csi == ':')
	{
	++csi;
	*p++ = radpk(dev);
	}
else
	{
	*p++ = DEF_DEV;
	csi = ptr;
	}

csiget(file,6);
*p++ = radpk(file);
*p++ = radpk(file+3);

if(*csi == '.')
	{
	++csi;
	csiget(ext,3);
	*p++ = radpk(ext);
	}
else
	*p++ = dext;

if(*csi == '[')
	{
	++csi;
	*p++ = csioct();
	if(*csi == ']')
		++csi;
	}
else
	*p++ = 0;
while (*csi == '/')
	{
	++swcnt;
	++csi;
	sws = *csi++ & 0177;
	sws =| fileno << 8;
	if(*csi == ':')
		{
		sws =| 0100000;
		++csi;
		*csisws++ = csioct();
		}
	*csisws++ = sws;
	}
if(tflg>1)
	printf(" return(%o)\n",csigot);
return(csigot);
}

csigen(str,dext,devspc)
char *str;
char *devspc;
int *dext;
{
csisub(1,str,dext,devspc);
}

csispc(str,dext,devspc)
char *str;
char *devspc;
int *dext;
{
csisub(0,str,dext,devspc);
}

csisub(flag,str,dext,devspc)
char *str;
int *dext;
char *devspc;
{
/*
 * process (possibly after reading) a csi string.
 * flag==1	open the files found
 *       0	return the names found
 */

register int i;
register int *p;
register int l;

loop:
if(str == 0)
	{
	++csiflg;
	readline(buff);
	copystr(buff,buff);
	}
else
	copystr(buff,str);

csi = buff;
csisws = swspc;
swcnt = 0;

if(flag)
	{
	for (i=0; i<=010; ++i)
		if(channels[i].c_state == OPEN)
			rtclose(i);
	}
else
	{
	p = devspc;
	clear(p, 39 * 2);
	}
if(csiout == 0)
	goto output;
for (i=0; i<3; ++i)
	{
	if(csifile(i,dext[i+1]))
		if(flag)
			{
			if(! rtenter(i, &devblk, devblk.d_size))
				{
				printf("?*can't enter*? (%s)\n",path);
				goto loop;
				}
			}
		else
			{
			move(5<<1,&devblk,p);
			if(tflg)
				printf("\n	csispc %o: %o %o %o %o %o %o ",
					i,p,p[0],p[1],p[2],p[3],p[4]);
			}
	if(!flag)
		p =+ 5;
	switch(*csi)
		{
	case ',':
		++csi;
		break;
	case '\0':
		goto done;
	case '=':
		++csi;
		goto output;
	default:
		goto badsyn;
		}
	}
goto badsyn;			/* more than 3 output files */
output:
for (i=3; i<=010; ++i)
	{
	if(csifile(i,dext[0]))
		{
		if(flag || spflag)
			{
			if(! rtlookup(i, &devblk))
				{
				printf("?*fil not fnd*? (%s)\n",path);
				goto loop;
				}
			}
		if(!flag)
			{
			move(4<<1,&devblk,p);
			if(tflg)
				printf("\n	csispc %o: %o %o %o %o %o ",
					i,p,p[0],p[1],p[2],p[3]);
			}
		}
	if(!flag)
		p =+ 4;
	switch(*csi)
		{
	case ',':
		++csi;
		break;
	case '\0':
		goto done;
	default:
	badsyn:
		seterr(0);
		if(tflg)
			printf(" near ==> %.10s",csi);
		printf("?csi syntax?\n");
		goto loop;
		}
	}
goto badsyn;			/* too many input files */
done:

l = csisws - swspc;	/* calculate the switch space */
for (i=0; i<l; ++i)
	{
	if(tflg>1)
		printf(" %o",swspc[i]);
	*--u.sp = swspc[i];
	}
*--u.sp = swcnt;
if(tflg)
	printf(" sws: %o",swcnt);
if(flag)
	u.r0 = devspc;
csiflg = 0;
}

readline(line)
char *line;
{
register char *p;
register int c;

p = line;
putchar('*');

while (c = getchar())
	{
	if(c == '\n')
		{
		*p++ = 0;
		return(p-line);
		}
	*p++ = c;
	}
*p++ = 0;
exit(0);
}

copystr(out,in)
char *out, *in;
{
/*
 * copy string "in" to "out", translating to uc and 
 * removing blanks and other junk. 
 */
register char *p, *q;
register int c;

p = in;
csiout = 0;
q = out;

for(EVER)
	{
	switch(c = *p++)
		{
	case 014:
	case '\r':
	case '\n':
	case '\0':
		*q++ = 0;
		return;

	case ' ':
		break;

	case '<':
	case '=':
		++csiout;
		*q++ = '=';
		break;

	default:
		if(c >= 'a' && c<= 'z')
			c =- 'a' - 'A';
		*q++ = c;
		}
	}
}
