#
/*			Copyright 1977 by Bill Webb.	 		*/


#define	SCALE	5/6
#define	UP	32
#define	DOWN	16
#define	UPX	1
#define	DOWNX	2
#define	UPY	4
#define	DOWNY	8

#define	LOWER	-1
#define	INSIDE	0
#define	HIGHER	1

#define	MAXINT	32767
#define setbit(x,y) if(!(x<xbmin||x>=xbmax||y<ybmin||y>=ybmax))bits[y-ybmin][x/BYTESIZE]=|ones[x%BYTESIZE];
#define	FLAG	040000
#define	draw	2
#define	move	3

#define	BYTESIZE	6
#define	YMAX	144
#define	XMAX	132
#define	MASK	((1<<BYTESIZE)-1)
char bits[YMAX][XMAX];
char plotfile[] "/tmp/ptmp";
char moves[] { 0, 1, -1, 0 };
int plotdes;
int xpos, ypos;		/* where it is */
int pen UP;
char ones[] { 01, 02, 04, 010, 020, 040 };
int xoff;
int outbuff[518/2];
int debug 0;
int flag;
int xmax, ymax;
int xmin, ymin;
int xbmin, xbmax, ybmin, ybmax;
int rmflg;		/* remove file after use */
int sflg;		/* scale input */
int bflg;		/* buffer output thru pipe */
int fin[518/2];

main(argc,argv) char **argv;
{
register int c;
register int x,y;
extern int fout;
char *argp;

--argc;
++argv;
fout = open("/dev/lp",1);
if (fout < 0)
	fout = pipeout("/bin/opr","opr",0);
while (argc > 0)
	{
	argp = *argv++;
	--argc;
	if (*argp == '-')
		{
		switch(*++argp)
			{
		case 's':
			++sflg;
			break;
		case 'b':
			++bflg;
			break;
		case 'r':
			++rmflg;
			break;
		case 'd':
			++debug;
			}
		}
	else
		{
		if (fopen(argp,&fin) < 0)
			err("can't open %s",argp);
		doplot();
		if (rmflg)
			unlink(argp);
		}
	}
if (fin[0] == 0)
	doplot();
exit(0);
}

doplot()
{
register int c;
register int x,y;
int cnt;

init();
while ((c = getc(&fin)) >= 0)
	{
	ypos =+ moves[c&03];
	xpos =+ moves[(c>>2)&03];
	x = xpos; y = ypos;
	if (sflg)
		x = x * SCALE;
	if (c & UP)
		pen = UP;
	else if (c & DOWN)
		pen = DOWN;
	if (pen & DOWN)
		{
		if (x > xmax)
			xmax = x;
		if (x < xmin)
			xmin = x;
		if (y > ymax)
			ymax = y;
		if (y < ymin)
			ymin = y;
		}
	if (x >= 0)
		{
		putc(c,outbuff);
		}
	else
		x = xpos = 0;
	}
if (debug)
	printf("%d %d,%d %d\n",xmin,xmax,ymin,ymax);
scan();
}


scan()
{
if (xmin != MAXINT)
	genplot();
init();
}

genplot()
{
register int x, y;
register int c;
int s1, s2;

fflush(outbuff);
putchar(014);
xbmin = 0; xbmax = XMAX*BYTESIZE;
xoff = 0;
if (xmax > xbmax)
	{
	if (xmax-xmin < xbmax)
		xoff = (xbmax+xmin-xmax)/2;
	else
		xoff = xmin;
	}
for (ybmin=ymin; ybmin < ymax; ybmin=ybmax)
	{
	ybmax = ybmin+YMAX;
	clear(bits,sizeof bits);
	seek(plotdes,0,0);
	outbuff[1] = 0;		/* empty it */
	xpos = ypos = 0;
	while ((c = getc(outbuff)) >= 0)
		{
		if (c & UP)
			pen = UP;
		else if (c & DOWN)
			{
			x = xpos; y = ypos;
			if (sflg)
				x = x * SCALE;
			setbit(x,y);
			pen = DOWN;
			}
		ypos =+ moves[c&03];
		xpos =+ moves[(c>>2)&03];
		x = xpos; y = ypos;
		if (sflg)
			x = x * SCALE;
		if (pen & DOWN)
			setbit(x,y);
		}
	dump();
	}
putchar(012);
putchar(014);
flush();
}



dump()
{
register int i;
for (i=0; i<YMAX; ++i)
	putrow(bits[i]);
flush();
}

putrow(ptr) char *ptr;
{
register char *p;
register char *s;

putchar(05);
for (p=ptr+XMAX; --p >= ptr; )
	{
	if (*p & MASK)
		{
		for (s=ptr; s <=p; ++s)
			putchar(0100 | *s);
		break;
		}
	}
putchar(012);
}

init()
{
if (plotdes)
	close(plotdes);
if (close(creat(plotfile,0666)) < 0)
	err("creating %s",plotfile);
plotdes = open(plotfile,2);
outbuff[0] = plotdes;
if (!debug)
	unlink(plotfile);
xpos = ypos = 0;
xmax = ymax = 0;
xmin = ymin = MAXINT;
}

