#
/*
 * printer plot routines for printronix 300 line printer/plotter.
 * input is in UBC UNIX plot format, as provided by the plotting
 * routines. Output is in plot mode for the Printronix 300 line
 * printer.
 */
/*			Copyright 1977 by Bill Webb.	 		*/


#define	LOWER	-1
#define	INSIDE	0
#define	HIGHER	1

#define	MAXINT	32767
#ifndef	REVERSED
#define dobit(x,y) if(!(x>=xbmax||y<ybmin||y>=ybmax)) setbit(x,y);
#define setbit(x,y) bitptrs[ybmax-y-1][x]='*';
#endif

#ifdef REVERSED
#define dobit(x,y) if(!(x>=xbmax||y<ybmin||y>=ybmax)) setbit(x,y);
#define setbit(x,y) bitptrs[y-ybmin][x]='*';
#endif

#define	FLAG	040000
#define	draw	2
#define	move	3

#define	BYTESIZE	6
#define	YPAGE	24
#define	YMAX	24
#define	XMAX	80
char bits[YMAX][XMAX];
char *bitptrs[YMAX];
char plotfile[] "/tmp/ptmp";
int plotdes;
char ones[] { 01, 02, 04, 010, 020, 040 };
int xoff;
int outbuff[518/2];
int debug 0;
int flag;
int xmax, ymax;
int xmin, ymin;
int xbmin, xbmax, ybmin, ybmax;
int rmflg;		/* remove file after use */
int sflg 1;		/* scale input */
int iflg;		/* inches */
int bflg;		/* buffer output thru pipe */
int nflg;
int fin[518/2];

main(argc,argv) char **argv;
{
register int c;
register int x,y;
extern int fout;
char *argp;

--argc;
++argv;
fout = dup(1);
while (argc > 0)
	{
	argp = *argv++;
	--argc;
	if (*argp == '-')
		{
		switch(*++argp)
			{
		case 'n':
			++nflg;
			break;
		case 's':
			sflg = !sflg;
			break;
		case 'i':	/* inches */
			++iflg;
			break;
		case 'b':
			++bflg;
			break;
		case 'w':
			fout = pipeout("/bin/lpr","lpr","-w",0);
			break;
		case 'r':
			++rmflg;
			break;
		case 'd':
			++debug;
			}
		}
	else
		{
		if (fopen(argp,&fin) < 0)
			err("can't open %s",argp);
		doplot();
		if (rmflg)
			unlink(argp);
		}
	}
if (fin[0] == 0)
	doplot();
exit(0);
}

doplot()
{
register int c;
register int x,y;
int cnt;

init();
while ((c = getc(&fin)) >= 0)
	{
	switch(c)
		{
	case 030:	/* erase screen */
		if (debug)
			printf("erase\n");
		scan();
		while ((c = getc(&fin)) != 0377 && c >= 0)
			;
		break;
	default:
		err("out of sync");
		break;
	case 035:	/* draw x1 y1, move x2 y2 ... */
		flag = 0;
		cnt = 0;
#ifndef	REVERSED
		while ((x = coord()) >= 0 && (y = coord()) >= 0)
#endif
#ifdef	REVERSED
		while ((y = coord()) >= 0 && (x = coord()) >= 0)
#endif
			{
			x = x * 80 / 1000;
			y = y * 24 / 1000;
			if (x > xmax)
				xmax = x;
			if (x < xmin)
				xmin = x;
			if (y > ymax)
				ymax = y;
			if (y < ymin)
				ymin = y;
			if (debug)
				printf("(%d,%d) ",x,y);
			if (flag++ == 0)
				x =| FLAG;
			putw(x,outbuff);
			putw(y,outbuff);
			}
		if (debug)
			printf("\n");
		break;
	case 0377:
		break;
		}
	}
scan();
}

coord()
{
register int c;
register int c2;
extern int fin[];

c = getc(&fin);
if (c < 0 || c == 0377)
	return(-1);
c2 = getc(&fin);
if (c2 < 0 || c2 == 0377)
	return(-1);
return(((c & 077) << 6) + (c2 & 077));
}

int xpos, ypos;		/* where it is */

scan()
{
if (xmin != MAXINT)
	genplot();
init();
}

int s1, s2;
int bdychk;		/* must check boundaries */
genplot()
{
register int x, y;
register int flg;
extern int fout;

fflush(outbuff);
if (bflg)
	{
	bflg = 0;
	flush();
	close(fout);
	fout = pipeout("/bin/lpr","lpr",0);
	}
putchar(014);
if (!nflg) for (y=(YPAGE-ymax)/2; --y >= 0; )
	putchar(012);
xbmin = 0; xbmax = XMAX*BYTESIZE;
xoff = 0;
if (xmax > xbmax)
	{
	if (xmax-xmin < xbmax)
		xoff = (xbmax+xmin-xmax)/2;
	else
		xoff = xmin;
	}
#ifndef	REVERSED
for (ybmax=ymax+1; ybmax >= 0; ybmax=ybmin)
	{
	ybmin = ybmax-YMAX;
#endif
#ifdef	REVERSED
for (ybmin=0; ybmin<=ymax; ybmin=ybmax)
	{
	ybmax = ybmin+YMAX;
#endif
	if (debug)
		printf("\n");
	clear(bits,sizeof bits);
	seek(plotdes,0,0);
	outbuff[1] = 0;		/* nothing in buffer */
	while ((x = getw(outbuff)) >= 0)
		{
		y = getw(outbuff);
		flg = x & FLAG;
		x =- flg;
		if (debug > 1)
			{
			if (flg)
				printf("\n");
			printf("(%d,%d) ",x,y);
			}
		x =- xoff;
		s2 = (y >= ybmax) ? HIGHER : ((y < ybmin) ? LOWER : INSIDE);
		if (!flg)
			{
			if (s1 == INSIDE || s2 == INSIDE || s1 != s2)
				{
				bdychk = s1 != INSIDE || s2 != INSIDE ||
					x >= xbmax || xpos >= xbmax;
				xymov(x-xpos,y-ypos);
				}
			}
		xpos = x; ypos = y;
		s1 = s2;
		}
	dump();
	}
flush();
}

xymov(x,y)
{
#define	minusx	0377
#define	plusx	1
#define	minusy	-1 << 8
#define	plusy	1 << 8
/*
 * draw by (x,y) increments.
 */
int absx, absy, i;
int maj, min;
register int nomaj, nomin, start;

if ((absx = x) < 0)
	absx = -absx;
if ((absy = y) < 0)
	absy = -absy;
if (absx > absy)
	{
	maj = (x < 0) ? minusx : plusx;
	min = (y < 0) ? minusy : plusy;
	nomaj = absx;
	nomin = absy;
	}
else
	{
	min = (x < 0) ? minusx : plusx;
	maj = (y < 0) ? minusy : plusy;
	nomaj = absy;
	nomin = absx;
	}
min =| maj;
start = nomaj>>1;
if (bdychk)
	xysteps(nomaj,nomin,start,maj,min);
else
	xyfast(nomaj,nomin,start,maj,min);
}

xysteps(nomaj,nomin,start,maj,min)
{
register int x, y;
int i;
struct { char x, y; };

x = xpos; y = ypos;
dobit(x,y);
for (i=0; i<nomaj; ++i)
	{
	start =+ nomin;
	if (start < nomaj)
		{
		x =+ maj.x;
		y =+ maj.y;
		}
	else
		{
		x =+ min.x;
		y =+ min.y;
		start =- nomaj;
		}
	dobit(x,y);
	}
xpos = x; ypos = y;
}

xyfast(nomaj,nomin,start,maj,min)
{
register int x, y;
int i;
struct { char x, y; };

x = xpos; y = ypos;
setbit(x,y);
for (i=0; i<nomaj; ++i)
	{
	start =+ nomin;
	if (start < nomaj)
		{
		x =+ maj.x;
		y =+ maj.y;
		}
	else
		{
		x =+ min.x;
		y =+ min.y;
		start =- nomaj;
		}
	setbit(x,y);
	}
xpos = x; ypos = y;
}


dump()
{
register int i;
if(nflg)
	return;
for (i=0; i<YMAX; ++i)
	putrow(bits[i]);
flush();
}

putrow(ptr) char *ptr;
{
register char *p;
register char *s;

for (p=ptr+XMAX; --p >= ptr; )
	{
	if (*p)
		{
		for (s=ptr; s <=p; ++s)
			putchar(*s ? *s : ' ');
		break;
		}
	}
putchar(012);
}

init()
{
register int i;

for (i=0; i<YMAX; ++i)
	bitptrs[i] = bits[i];
if (plotdes)
	close(plotdes);
if (close(creat(plotfile,0666)) < 0)
	err("creating %s",plotfile);
plotdes = open(plotfile,2);
outbuff[0] = plotdes;
if (!debug)
	unlink(plotfile);
xmax = ymax = 0;
xmin = ymin = MAXINT;
}

side(x,y)
{
if (y >= ybmax)
	return(HIGHER);
if (y < ybmin)
	return(LOWER);
return(INSIDE);
}
