#
/*
 * plot filter for the Intcolor 8001 color graphics terminal.
 * note that the output is in raw mode and uses all 8 bits.
 * this requires a change to the tty driver (for DZ11) to support
 * full 8 bit transmission.
 */
 */
#define	xmaxscreen	159
#define	ymaxscreen	191
#define	xfudge	5
#define	yfudge	4

#define	max	128
int xpos[max], ypos[max];
int oldv[3], newv[3];

#define	draw	2
#define	move	3

int debug 0;
int flag;
int xmax, ymax;
int rmflg;		/* remove file after use */
int sflg;		/* force spooling of output */
int bflg;		/* buffer output thru pipe */

main(argc,argv) char **argv;
{
extern fout;
register int c;
extern int fin[];
register int x,y;
char *argp;

--argc;
++argv;
fout = dup(1);
while (argc > 0)
	{
	argp = *argv++;
	--argc;
	if (*argp == '-')
		{
		switch(*++argp)
			{
		case 's':
			++sflg;
			break;
		case 'b':
			++bflg;
			break;
		case 'r':
			++rmflg;
			break;
		case 'd':
			++debug;
			}
		}
	else
		{
		if (fopen(argp,&fin) < 0)
			err("can't open %s",argp);
		if (rmflg)
			unlink(argp);
		}
	}
init();
while ((c = getc(&fin)) >= 0)
	{
	switch(c)
		{
	case 030:	/* erase screen */
		if (debug)
			printf("erase\n");
		xmax = ymax = 0;
		stty(1,newv);
		putchar(014);
		flush();
		sleep(1);
		stty(1,oldv);
		reorigin();
	default:
		while ((c = getc(&fin)) < 0377)
			;
		break;
	case 035:	/* draw x1 y1, move x2 y2 ... */
		flag = 0;
		for (flag=0; (x = coord()) >= 0; ++flag)
			{
			y = coord();
			if (x > xmax)
				xmax = x;
			if (y > ymax)
				ymax = y;
			if (debug)
				printf("(%d,%d) ",x,y);
			x =/ xfudge;
			y =/ yfudge;
			if (x > xmaxscreen)
				x = xmaxscreen;
			if (y > ymaxscreen)
				y = ymaxscreen;
			xpos[flag]=x;
			ypos[flag]=y;
			}
		if (debug)
			printf("\n");
			doit();
		break;
		}
	}
}

coord()
{
register int c;
extern int fin[];

c = getc(&fin);
if (c < 0 || c == 0377)
	return(-1);
return((c << 6) + getc(&fin));
}


doit()
{
register int i;

stty(1,newv);
putchar(02);
putchar(253);
for (i=0; i<flag; ++i)
	{
	putchar(xpos[i]);
	putchar(ypos[i]);
	putchar(242);
	putchar(242);
	putchar(242);
	}
putchar(255);
flush();
stty(1,oldv);
}

init()
{
gtty(1,oldv);
newv[0] = oldv[0];
newv[1] = oldv[1];
newv[2] = 040;		/* raw mode */
}

reorigin()
{
xmax = -1; ymax = -1;
}
