#

#define	RAW	040	/* tty raw mode */
#define	PARITY	0300	/* parity bits */

int eflg 0;	/* echo input */
int tty;	/* dial up line fdes */
int v[3], oldv[3];
int outpid;
int done();

char *ttyname;
main(argc,argv) char **argv;
{
/*
 * program to run the tty line as a slave.
 */

if (argc > 1)
	ttyname = argv[1];
else
	ttyname = "/dev/ttys";
if (inuse(ttyname[8]))
	err("%s is set up as a UNIX terminal",ttyname);
tty = open(ttyname,2);	/* open dial up line */
if (tty < 0)
	err("can't open %s",ttyname);
setuid(getuid()&0377);
signal(1,1);
signal(2,1);
#ifndef	test
if (outpid = fork())
	input();		/* parent */
else
	output();
#endif
#ifdef	test
	output();
#endif
}

input()
{
/*
 * read from the user's terminal and write to the line.
 * terminal is first set to raw mode.
 * on null character from the terminal the program will
 * exit.
 */
char c;
gtty(0,oldv);
v[0] = oldv[0];
v[1] = 0;
v[2] = RAW;
stty(0,v);
signal(1,&done);		/* in case of hang up */
while ((c = getch(0)) > 0)
	if (write(tty,&c,1) < 0)
		break;
done();
}

done()
{
int status;
kill(outpid,9);
stty(0,oldv);
while (wait(&status) != -1)
	;
exit(0);
}

output()
{
/*
 * read from the remote line and write to the terminal.
 */
register int l;
char c;
gtty(tty,oldv);
v[0] = oldv[0];
v[1] = 0;
v[2] = (oldv[2] & PARITY) | RAW;
stty(tty,v);
for (;;)
	{
	l = read(tty,&c,1);
	write(1,&c,l);
	}
stty(tty,oldv);
}

getch(fd)
{
char c;

if (read(fd,&c,1) <= 0)
	return(0);
c =& 0177;
if (c == 02)
	c = 0;
if(eflg)
	write(1,&c,1);
return(c);
}

inuse(ttynum)
{
char ttyinfo[4];
register int i;

if ((i = open("/etc/ttys",0)) < 0)
	err("no /etc/ttys");
while (read(i,ttyinfo,4) == 4)
	if (ttyinfo[1] == ttynum)
		{
		close(i);
		return(ttyinfo[0] == '1');
		}
err("%c not in /etc/ttys",ttynum);
}
