#

#define	MAXLINE	512
#define	BS	010
#define	CR	'\r'
#define	NL	'\n'
#define	FF	014
#define	REQCR	01
#define	BLANK	' '
#define	AESTAB	020		/* use DLE as tab space */

char line[MAXLINE];
char startmem 18;		/* DC2 */
char endmem 20;			/* DC4 */
char outline[MAXLINE];
int nflg, aflg;
int ffcnt;			/* number of FF's processed */
int tflg 1;			/* produce leading tabs */
int width 55;

main(argc,argv) char **argv;
{
extern int fin;
register char *argp;
register int i;

for (i=1; i<argc; ++i)
	{
	argp = argv[i];
	if (*argp == '-')
		switch(argp[1])
			{
		case 'n':
			++nflg;
			break;
		case 't':
			tflg = !tflg;
			break;
		case 'a':
			++aflg;
			break;
		case 'w':
			width = atoi(argp+2);
			break;
			}
	else
		{
		if ((fin = open(argp,0)) < 0)
			err("can't open %s",argp);
		dofile();
		close(fin);
		fin = -1;
		}
	}

if (fin == 0)
	dofile();
write(1,&endmem,1);
}

dofile()
{
register char *p;
register int l;
register char *s;


while ((l = readline(line)) >= 0)
	{
	s = line;
	if ((line[0]&0177) == FF)
		{
		*s = 0214;
		write(1,line,1);
		--l;
		++s;
		if (ffcnt++ == 0)
			write(1,&startmem,1);
		}
	if (tflg)
		cvttabs(s);
	p = any(s,"\r");
	if (p)
		{
		*p++ = 0;
		combine(s,p);
		}
	else
		{
		if (reqcr(s))
			s[l++] = REQCR;
		s[l++] = NL;
		write(1,s,l);
		}
	}
}

combine(l1,l2) char *l1, *l2;
{
register char *p1, *p2;
register char *o;
int flag;

flag = reqcr(l1);
p1 = l1; p2 = l2;
for (o = outline; *p1; )
	{
	*o++ = *p1++;
	if (*p2)
		{
		if (*p2 == ' ')
			++p2;
		else
			{
			*o++ = BS;
			*o++ = *p2++;
			}
		}
	}
if (flag)
	*o++ = REQCR;
*o++ = NL;
write(1,outline,o-outline);
}

readline(ptr) char *ptr;
{
register int c;
register char *p;

for (p = ptr; c = getchar(); )
	{
	if (c == NL)
		{
		*p = 0;
		return(p-ptr);
		}
	*p++ = c;
	}
return(-1);
}

reqcr(ln) char *ln;
{
/*
 * -n = never provide required cr's
 * -a = always provide
 * if length < width then provide it, otherwise not.
 */
if (nflg)
	return(0);
if (aflg || length(ln) < width)
	return(1);
return(0);
}

cvttabs(ptr) char *ptr;
{
register char *p;

for (p = ptr; *p == BLANK; ++p)
	*p = AESTAB;
}
